/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.vavr.CheckedFunction1;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.MavenCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawRepositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDownloader {
    private static final Logger logger = LoggerFactory.getLogger(MavenDownloader.class);
    private static final RetryConfig retryConfig = RetryConfig.custom().retryExceptions(new Class[]{SocketTimeoutException.class, TimeoutException.class}).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().callTimeout(1L, TimeUnit.MINUTES).connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private static final Retry mavenDownloaderRetry = retryRegistry.retry("MavenDownloader");
    private static final CheckedFunction1<Request, Response> sendRequest = Retry.decorateCheckedFunction((Retry)mavenDownloaderRetry, (CheckedFunction1 & Serializable)request -> httpClient.newCall(request).execute());
    private static final RawRepositories.Repository SUPER_POM_REPOSITORY = new RawRepositories.Repository("central", "https://repo.maven.apache.org/maven2", new RawRepositories.ArtifactPolicy(true), new RawRepositories.ArtifactPolicy(false));
    private final MavenCache mavenCache;
    private final Map<Path, RawMaven> projectPoms;
    @Nullable
    private final MavenSettings settings;
    private final Map<String, MavenSettings.Server> serverIdToServer;

    public MavenDownloader(MavenCache mavenCache, Map<Path, RawMaven> projectPoms, @Nullable MavenSettings settings) {
        this.mavenCache = mavenCache;
        this.projectPoms = projectPoms;
        this.settings = settings;
        this.serverIdToServer = settings == null || settings.getServers() == null ? new HashMap<String, MavenSettings.Server>() : settings.getServers().getServers().stream().collect(Collectors.toMap(MavenSettings.Server::getId, Function.identity()));
    }

    public MavenMetadata downloadMetadata(String groupId, String artifactId, List<RawRepositories.Repository> repositories) {
        Timer.Sample sample = Timer.start();
        return Stream.concat(repositories.stream().distinct(), Stream.of(SUPER_POM_REPOSITORY)).map(this::normalizeRepository).distinct().filter(Objects::nonNull).map(repo -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "metadata");
            try {
                CacheResult<MavenMetadata> result = this.mavenCache.computeMavenMetadata(URI.create(repo.getUrl()), groupId, artifactId, () -> this.forceDownloadMetadata(groupId, artifactId, null, (RawRepositories.Repository)repo));
                sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
                return result.getData();
            }
            catch (Exception e) {
                sample.stop(timer.tags(new String[]{"outcome", "error", "exception", e.getClass().getName()}).register((MeterRegistry)Metrics.globalRegistry));
                return null;
            }
        }).filter(Objects::nonNull).reduce(MavenMetadata.EMPTY, (m1, m2) -> {
            if (m1 == MavenMetadata.EMPTY) {
                if (m2 == MavenMetadata.EMPTY) {
                    return m1;
                }
                return m2;
            }
            if (m2 == MavenMetadata.EMPTY) {
                return m1;
            }
            return new MavenMetadata(new MavenMetadata.Versioning(Stream.concat(m1.getVersioning().getVersions().stream(), m2.getVersioning().getVersions().stream()).collect(Collectors.toList()), null));
        });
    }

    @Nullable
    private MavenMetadata forceDownloadMetadata(String groupId, String artifactId, @Nullable String version, RawRepositories.Repository repo) throws IOException {
        logger.debug("Resolving {}:{} metadata from {}", new Object[]{groupId, artifactId, repo.getUrl()});
        String uri = repo.getUrl() + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + (version == null ? "" : version + '/') + "maven-metadata.xml";
        Request.Builder request = this.applyAuthentication(repo, new Request.Builder().url(uri).get());
        try {
            Response response;
            block10: {
                MavenMetadata mavenMetadata;
                block11: {
                    response = (Response)sendRequest.apply((Object)request.build());
                    try {
                        if (!response.isSuccessful() || response.body() == null) break block10;
                        byte[] responseBody = response.body().bytes();
                        mavenMetadata = MavenMetadata.parse(responseBody);
                        if (response == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return mavenMetadata;
            }
            if (response != null) {
                response.close();
            }
        }
        finally {
            return null;
        }
        {
        }
    }

    private Timer.Builder addTagsByResult(Timer.Builder timer, CacheResult<?> result) {
        switch (result.getState()) {
            case Cached: {
                timer = timer.tags(new String[]{"outcome", "cached", "exception", "none"});
                break;
            }
            case Unavailable: {
                timer = timer.tags(new String[]{"outcome", "unavailable", "exception", "none"});
                break;
            }
            case Updated: {
                timer = timer.tags(new String[]{"outcome", "downloaded", "exception", "none"});
            }
        }
        return timer;
    }

    @Nullable
    public RawMaven download(String groupId, String artifactId, String version, @Nullable String classifier, @Nullable String relativePath, @Nullable RawMaven containingPom, List<RawRepositories.Repository> repositories) {
        RawMaven maybeLocalPom;
        Path folderContainingPom;
        String versionMaybeDatedSnapshot = this.findDatedSnapshotVersionIfNecessary(groupId, artifactId, version, repositories);
        if (versionMaybeDatedSnapshot == null) {
            return null;
        }
        Timer.Sample sample = Timer.start();
        for (RawMaven projectPom : this.projectPoms.values()) {
            if (!groupId.equals(projectPom.getPom().getGroupId()) || !artifactId.equals(projectPom.getPom().getArtifactId())) continue;
            return projectPom;
        }
        if (containingPom != null && !StringUtils.isBlank((String)relativePath) && (folderContainingPom = containingPom.getSourcePath().getParent()) != null && (maybeLocalPom = this.projectPoms.get(folderContainingPom.resolve(Paths.get(relativePath, "pom.xml")).normalize())) != null && groupId.equals(maybeLocalPom.getPom().getGroupId()) && artifactId.equals(maybeLocalPom.getPom().getArtifactId()) && version.equals(maybeLocalPom.getPom().getVersion())) {
            return maybeLocalPom;
        }
        return Stream.concat(repositories.stream(), Stream.of(SUPER_POM_REPOSITORY)).map(this::normalizeRepository).filter(Objects::nonNull).distinct().filter(repo -> repo.acceptsVersion(version)).map(repo -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("repo.id", repo.getUrl()).tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "pom");
            try {
                CacheResult<RawMaven> result = this.mavenCache.computeMaven(URI.create(repo.getUrl()), groupId, artifactId, versionMaybeDatedSnapshot, () -> {
                    String uri = URI.create(repo.getUrl()) + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + versionMaybeDatedSnapshot + ".pom";
                    Request.Builder request = this.applyAuthentication((RawRepositories.Repository)repo, new Request.Builder().url(uri).get());
                    try {
                        Response response;
                        block10: {
                            RawMaven rawMaven;
                            block11: {
                                response = (Response)sendRequest.apply((Object)request.build());
                                try {
                                    if (!response.isSuccessful() || response.body() == null) break block10;
                                    byte[] responseBody = response.body().bytes();
                                    Path inputPath = Paths.get(groupId, artifactId, version);
                                    rawMaven = RawMaven.parse(new Parser.Input(inputPath, () -> new ByteArrayInputStream(responseBody), true), null, versionMaybeDatedSnapshot.equals(version) ? null : versionMaybeDatedSnapshot);
                                    if (response == null) break block11;
                                }
                                catch (Throwable throwable) {
                                    if (response != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                response.close();
                            }
                            return rawMaven;
                        }
                        if (response != null) {
                            response.close();
                        }
                    }
                    finally {
                        return null;
                    }
                    {
                    }
                });
                sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
                return result.getData();
            }
            catch (Exception e) {
                logger.debug("Failed to download {}:{}:{}:{}", new Object[]{groupId, artifactId, version, classifier, e});
                sample.stop(timer.tags(new String[]{"outcome", "error", "exception", e.getClass().getName()}).register((MeterRegistry)Metrics.globalRegistry));
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private String findDatedSnapshotVersionIfNecessary(String groupId, String artifactId, String version, List<RawRepositories.Repository> repositories) {
        MavenMetadata mavenMetadata;
        if (version.endsWith("-SNAPSHOT") && (mavenMetadata = (MavenMetadata)repositories.stream().map(this::normalizeRepository).filter(Objects::nonNull).distinct().filter(repo -> repo.acceptsVersion(version)).map(repo -> {
            try {
                return this.forceDownloadMetadata(groupId, artifactId, version, (RawRepositories.Repository)repo);
            }
            catch (IOException e) {
                logger.debug("Failed to download snapshot metadata for {}:{}:{}", new Object[]{groupId, artifactId, version});
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
            MavenMetadata.Snapshot snapshot = mavenMetadata.getVersioning().getSnapshot();
            if (snapshot == null) {
                return null;
            }
            return version.replaceFirst("SNAPSHOT$", snapshot.getTimestamp() + "-" + snapshot.getBuildNumber());
        }
        return version;
    }

    @Nullable
    private RawRepositories.Repository normalizeRepository(RawRepositories.Repository repository) {
        CacheResult<RawRepositories.Repository> result;
        RawRepositories.Repository repoWithMirrors = this.applyMirrors(repository);
        try {
            result = this.mavenCache.computeRepository(repoWithMirrors, () -> {
                String originalUrl = repoWithMirrors.getUrl();
                String httpsUrl = originalUrl.replaceFirst("[hH][tT][tT][pP]://", "https://");
                Request.Builder request = this.applyAuthentication(repoWithMirrors, new Request.Builder().url(httpsUrl).get());
                try (Response response = (Response)sendRequest.apply((Object)request.build());){
                    if (response.isSuccessful()) {
                        RawRepositories.Repository repository = new RawRepositories.Repository(repoWithMirrors.getId(), httpsUrl, repoWithMirrors.getReleases(), repoWithMirrors.getSnapshots());
                        return repository;
                    }
                    RawRepositories.Repository repository = null;
                    return repository;
                }
                catch (SSLException e) {
                    block21: {
                        Response httpResponse;
                        block20: {
                            RawRepositories.Repository repository;
                            if (httpsUrl.equals(originalUrl)) {
                                return null;
                            }
                            httpResponse = (Response)sendRequest.apply((Object)request.url(originalUrl).build());
                            try {
                                if (!httpResponse.isSuccessful()) break block20;
                                repository = new RawRepositories.Repository(repoWithMirrors.getId(), originalUrl, repoWithMirrors.getReleases(), repoWithMirrors.getSnapshots());
                                if (httpResponse == null) return repository;
                            }
                            catch (Throwable throwable) {
                                if (httpResponse == null) throw throwable;
                                try {
                                    httpResponse.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            httpResponse.close();
                            return repository;
                        }
                        if (httpResponse != null) {
                            httpResponse.close();
                        }
                        break block21;
                        finally {
                            return null;
                        }
                        catch (Throwable t) {
                            return null;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            return null;
        }
        return result.getData();
    }

    private RawRepositories.Repository applyMirrors(RawRepositories.Repository repository) {
        if (this.settings == null) {
            return repository;
        }
        return this.settings.applyMirrors(repository);
    }

    private Request.Builder applyAuthentication(RawRepositories.Repository repository, Request.Builder request) {
        MavenSettings.Server authInfo = this.serverIdToServer.get(repository.getId());
        if (authInfo != null) {
            String credentials = Credentials.basic((String)authInfo.getUsername(), (String)authInfo.getPassword());
            request.header("Authorization", credentials);
        }
        return request;
    }
}

