/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.GroupArtifactRepository;
import org.openrewrite.maven.cache.MavenCache;
import org.openrewrite.maven.internal.MavenDownloader;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.GroupArtifact;

public class InMemoryCache
implements MavenCache {
    private final Map<String, Optional<RawMaven>> pomCache = new HashMap<String, Optional<RawMaven>>();
    private final Map<GroupArtifactRepository, Optional<MavenMetadata>> mavenMetadataCache = new HashMap<GroupArtifactRepository, Optional<MavenMetadata>>();
    private final Map<RawRepositories.Repository, Optional<RawRepositories.Repository>> normalizedRepositoryUrls = new HashMap<RawRepositories.Repository, Optional<RawRepositories.Repository>>();
    private final Set<String> unresolvablePoms = new HashSet<String>();
    CacheResult<RawMaven> UNAVAILABLE_POM = new CacheResult<Object>(CacheResult.State.Unavailable, null);
    CacheResult<MavenMetadata> UNAVAILABLE_METADATA = new CacheResult<Object>(CacheResult.State.Unavailable, null);
    CacheResult<RawRepositories.Repository> UNAVAILABLE_REPOSITORY = new CacheResult<Object>(CacheResult.State.Unavailable, null);

    public InMemoryCache() {
        Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "inmem", "content", "poms"}), this.pomCache);
        Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "inmem", "content", "metadata"}), this.mavenMetadataCache);
        Metrics.gaugeMapSize((String)"rewrite.maven.cache.size", (Iterable)Tags.of((String[])new String[]{"type", "inmem", "content", "repository urls"}), this.normalizedRepositoryUrls);
        this.fillUnresolvablePoms();
    }

    private void fillUnresolvablePoms() {
        new BufferedReader(new InputStreamReader(MavenDownloader.class.getResourceAsStream("/unresolvable.txt"), StandardCharsets.UTF_8)).lines().filter(line -> !line.isEmpty()).forEach(this.unresolvablePoms::add);
    }

    @Override
    public CacheResult<MavenMetadata> computeMavenMetadata(URI repo, String groupId, String artifactId, Callable<MavenMetadata> orElseGet) throws Exception {
        GroupArtifactRepository gar = new GroupArtifactRepository(repo, new GroupArtifact(groupId, artifactId));
        Optional<MavenMetadata> rawMavenMetadata = this.mavenMetadataCache.get(gar);
        if (rawMavenMetadata == null) {
            try {
                MavenMetadata metadata2 = orElseGet.call();
                this.mavenMetadataCache.put(gar, Optional.ofNullable(metadata2));
                return new CacheResult<MavenMetadata>(CacheResult.State.Updated, metadata2);
            }
            catch (Exception e) {
                this.mavenMetadataCache.put(gar, Optional.empty());
                throw e;
            }
        }
        return rawMavenMetadata.map(metadata -> new CacheResult<MavenMetadata>(CacheResult.State.Cached, (MavenMetadata)metadata)).orElse(this.UNAVAILABLE_METADATA);
    }

    @Override
    public CacheResult<RawMaven> computeMaven(URI repo, String groupId, String artifactId, String version, Callable<RawMaven> orElseGet) throws Exception {
        String artifactCoordinates = groupId + ':' + artifactId + ':' + version;
        if (this.unresolvablePoms.contains(artifactCoordinates)) {
            return this.UNAVAILABLE_POM;
        }
        String cacheKey = repo.toString() + ":" + artifactCoordinates;
        Optional<RawMaven> rawMaven = this.pomCache.get(cacheKey);
        if (rawMaven == null) {
            try {
                RawMaven maven = orElseGet.call();
                this.pomCache.put(cacheKey, Optional.ofNullable(maven));
                return new CacheResult<RawMaven>(CacheResult.State.Updated, maven);
            }
            catch (Exception e) {
                this.pomCache.put(cacheKey, Optional.empty());
                throw e;
            }
        }
        return rawMaven.map(pom -> new CacheResult<RawMaven>(CacheResult.State.Cached, (RawMaven)pom)).orElse(this.UNAVAILABLE_POM);
    }

    @Override
    public CacheResult<RawRepositories.Repository> computeRepository(RawRepositories.Repository repository, Callable<RawRepositories.Repository> orElseGet) throws Exception {
        Optional<RawRepositories.Repository> normalizedRepository = this.normalizedRepositoryUrls.get(repository);
        if (normalizedRepository == null) {
            try {
                RawRepositories.Repository repo = orElseGet.call();
                this.normalizedRepositoryUrls.put(repository, Optional.ofNullable(repo));
                return new CacheResult<RawRepositories.Repository>(CacheResult.State.Updated, repo);
            }
            catch (Exception e) {
                this.normalizedRepositoryUrls.put(repository, Optional.empty());
                throw e;
            }
        }
        return normalizedRepository.map(pom -> new CacheResult<RawRepositories.Repository>(CacheResult.State.Cached, (RawRepositories.Repository)pom)).orElse(this.UNAVAILABLE_REPOSITORY);
    }
}

