/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangeParentVersion;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.cache.NoopCache;
import org.openrewrite.maven.internal.MavenDownloader;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.tree.Xml;

public class UpgradeParentVersion
extends MavenRefactorVisitor {
    @Nullable
    private Collection<String> availableVersions;
    private String groupId;
    private String artifactId;
    private String toVersion;
    @Nullable
    private String metadataPattern;
    private VersionComparator versionComparator;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public void setMetadataPattern(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    public UpgradeParentVersion() {
        this.setCursoringOn();
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId)).and(Validated.required((String)"toVersion", (Object)this.toVersion)).and(Semver.validate((String)this.toVersion, (String)this.metadataPattern));
    }

    @Override
    public Maven visitMaven(Maven maven) {
        this.versionComparator = (VersionComparator)Semver.validate((String)this.toVersion, (String)this.metadataPattern).getValue();
        return super.visitMaven(maven);
    }

    public Xml visitTag(Xml.Tag tag) {
        if (this.isParentTag() && this.groupId.equals(tag.getChildValue("groupId").orElse(null)) && this.artifactId.equals(tag.getChildValue("artifactId").orElse(null))) {
            tag.getChildValue("version").flatMap(parentVersion -> this.findNewerDependencyVersion(this.groupId, this.artifactId, (String)parentVersion)).ifPresent(newer -> {
                ChangeParentVersion changeParentVersion = new ChangeParentVersion();
                changeParentVersion.setGroupId(this.groupId);
                changeParentVersion.setArtifactId(this.artifactId);
                changeParentVersion.setToVersion((String)newer);
                this.andThen((RefactorVisitor)changeParentVersion);
            });
        }
        return super.visitTag(tag);
    }

    private Optional<String> findNewerDependencyVersion(String groupId, String artifactId, String currentVersion) {
        if (this.availableVersions == null) {
            MavenMetadata mavenMetadata = new MavenDownloader(new NoopCache(), Collections.emptyMap(), this.settings).downloadMetadata(groupId, artifactId, Collections.emptyList());
            this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(arg_0 -> ((VersionComparator)this.versionComparator).isValid(arg_0)).collect(Collectors.toList());
        }
        LatestRelease latestRelease = new LatestRelease(this.metadataPattern);
        return this.availableVersions.stream().filter(v -> latestRelease.compare(currentVersion, v) < 0).max((Comparator<String>)this.versionComparator);
    }
}

