/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.RawRepositories;

public class MavenSettings {
    private static final ObjectMapper xmlMapper;
    @Nullable
    private final Profiles profiles;
    @Nullable
    private final ActiveProfiles activeProfiles;
    @Nullable
    private final Mirrors mirrors;
    @Nullable
    private final Servers servers;

    @JsonCreator
    MavenSettings(@JsonProperty(value="profiles") @Nullable Profiles profiles, @JsonProperty(value="activeProfiles") @Nullable ActiveProfiles activeProfiles, @JsonProperty(value="mirrors") @Nullable Mirrors mirrors, @JsonProperty(value="servers") @Nullable Servers servers) {
        this.profiles = profiles;
        this.activeProfiles = activeProfiles;
        this.mirrors = mirrors;
        this.servers = servers;
    }

    public static MavenSettings parse(Parser.Input source) {
        try {
            return (MavenSettings)xmlMapper.readValue(source.getSource(), MavenSettings.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse " + source.getPath(), e);
        }
    }

    public List<RawRepositories.Repository> getActiveRepositories(Collection<String> activeProfiles) {
        ArrayList<RawRepositories.Repository> activeRepositories = new ArrayList<RawRepositories.Repository>();
        if (this.profiles != null) {
            for (Profile profile : this.profiles.getProfiles()) {
                if (!profile.isActive(activeProfiles) && (this.activeProfiles == null || !profile.isActive(this.activeProfiles.getActiveProfiles())) || profile.repositories == null) continue;
                activeRepositories.addAll(profile.repositories.getRepositories());
            }
        }
        return this.applyMirrors(activeRepositories);
    }

    public List<RawRepositories.Repository> applyMirrors(Collection<RawRepositories.Repository> repositories) {
        if (this.mirrors == null) {
            if (repositories instanceof List) {
                return (List)repositories;
            }
            return new ArrayList<RawRepositories.Repository>(repositories);
        }
        return this.mirrors.applyMirrors(repositories);
    }

    public RawRepositories.Repository applyMirrors(RawRepositories.Repository repository) {
        if (this.mirrors == null) {
            return repository;
        }
        return this.mirrors.applyMirrors(repository);
    }

    public String toString() {
        return "MavenSettings()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenSettings)) {
            return false;
        }
        MavenSettings other = (MavenSettings)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MavenSettings;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public Mirrors getMirrors() {
        return this.mirrors;
    }

    public Servers getServers() {
        return this.servers;
    }

    public MavenSettings withServers(Servers servers) {
        return this.servers == servers ? this : new MavenSettings(this.profiles, this.activeProfiles, this.mirrors, servers);
    }

    static {
        WstxInputFactory input = new WstxInputFactory();
        input.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        input.setProperty("javax.xml.stream.isNamespaceAware", false);
        xmlMapper = new XmlMapper(new XmlFactory((XMLInputFactory)input, (XMLOutputFactory)new WstxOutputFactory())).disable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).disable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static class Server {
        private final String id;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        private final String username;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        private final String password;

        @ConstructorProperties(value={"id", "username", "password"})
        public Server(String id, String username, String password) {
            this.id = id;
            this.username = username;
            this.password = password;
        }

        public String getId() {
            return this.id;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Server)) {
                return false;
            }
            Server other = (Server)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Server;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        public String toString() {
            return "MavenSettings.Server(id=" + this.getId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }

    public static class Servers {
        @JacksonXmlProperty(localName="server")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Server> servers = Collections.emptyList();

        public List<Server> getServers() {
            return this.servers;
        }

        @JacksonXmlProperty(localName="server")
        public void setServers(List<Server> servers) {
            this.servers = servers;
        }
    }

    public static class Mirror {
        @Nullable
        private final String id;
        @Nullable
        private final String name;
        @Nullable
        private final URI url;
        @Nullable
        private final String mirrorOf;
        private ApplicabilitySpec applicabilitySpec = null;
        private static ApplicabilitySpec APPLICABLE_TO_EVERYTHING = repo -> true;
        private static ApplicabilitySpec APPLICABLE_TO_NOTHING = repo -> false;

        private ApplicabilitySpec buildApplicabilitySpec() {
            if (this.mirrorOf == null) {
                return APPLICABLE_TO_NOTHING;
            }
            if (this.mirrorOf.equals("*")) {
                return APPLICABLE_TO_EVERYTHING;
            }
            int colonIndex = this.mirrorOf.indexOf(58);
            String mirrorOfWithoutExternal = this.mirrorOf;
            boolean externalOnly = false;
            if (colonIndex != -1) {
                externalOnly = true;
                mirrorOfWithoutExternal = this.mirrorOf.substring(colonIndex + 1);
            }
            List mirrorsOf = Arrays.stream(mirrorOfWithoutExternal.split(",")).collect(Collectors.toList());
            HashSet<String> excludedRepos = new HashSet<String>();
            HashSet<String> includedRepos = new HashSet<String>();
            for (String mirror : mirrorsOf) {
                if (mirror.startsWith("!")) {
                    excludedRepos.add(mirror.substring(1));
                    continue;
                }
                includedRepos.add(mirror);
            }
            return new DefaultApplicabilitySpec(externalOnly, excludedRepos, includedRepos);
        }

        public RawRepositories.Repository apply(RawRepositories.Repository repo) {
            if (this.isApplicable(repo) && this.url != null) {
                return new RawRepositories.Repository(this.id, this.url.toString(), repo.getReleases(), repo.getSnapshots());
            }
            return repo;
        }

        public boolean isApplicable(RawRepositories.Repository repo) {
            if (this.applicabilitySpec == null) {
                this.applicabilitySpec = this.buildApplicabilitySpec();
            }
            return this.applicabilitySpec.isApplicable(repo);
        }

        @ConstructorProperties(value={"id", "name", "url", "mirrorOf"})
        public Mirror(String id, String name, URI url, String mirrorOf) {
            this.id = id;
            this.name = name;
            this.url = url;
            this.mirrorOf = mirrorOf;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public URI getUrl() {
            return this.url;
        }

        public String getMirrorOf() {
            return this.mirrorOf;
        }

        public ApplicabilitySpec getApplicabilitySpec() {
            return this.applicabilitySpec;
        }

        public void setApplicabilitySpec(ApplicabilitySpec applicabilitySpec) {
            this.applicabilitySpec = applicabilitySpec;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mirror)) {
                return false;
            }
            Mirror other = (Mirror)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            URI this$url = this.getUrl();
            URI other$url = other.getUrl();
            if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
                return false;
            }
            String this$mirrorOf = this.getMirrorOf();
            String other$mirrorOf = other.getMirrorOf();
            if (this$mirrorOf == null ? other$mirrorOf != null : !this$mirrorOf.equals(other$mirrorOf)) {
                return false;
            }
            ApplicabilitySpec this$applicabilitySpec = this.getApplicabilitySpec();
            ApplicabilitySpec other$applicabilitySpec = other.getApplicabilitySpec();
            return !(this$applicabilitySpec == null ? other$applicabilitySpec != null : !this$applicabilitySpec.equals(other$applicabilitySpec));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mirror;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            URI $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
            String $mirrorOf = this.getMirrorOf();
            result = result * 59 + ($mirrorOf == null ? 43 : $mirrorOf.hashCode());
            ApplicabilitySpec $applicabilitySpec = this.getApplicabilitySpec();
            result = result * 59 + ($applicabilitySpec == null ? 43 : $applicabilitySpec.hashCode());
            return result;
        }

        public String toString() {
            return "MavenSettings.Mirror(id=" + this.getId() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", mirrorOf=" + this.getMirrorOf() + ", applicabilitySpec=" + this.getApplicabilitySpec() + ")";
        }

        private static class DefaultApplicabilitySpec
        implements ApplicabilitySpec {
            final boolean isExternalOnly;
            final Set<String> excludedRepos;
            final Set<String> includedRepos;

            DefaultApplicabilitySpec(boolean isExternalOnly, Set<String> excludedRepos, Set<String> includedRepos) {
                this.isExternalOnly = isExternalOnly;
                this.excludedRepos = excludedRepos;
                this.includedRepos = includedRepos;
            }

            @Override
            public boolean isApplicable(RawRepositories.Repository repo) {
                if (this.isExternalOnly && this.isInternal(repo)) {
                    return false;
                }
                if (this.excludedRepos.stream().anyMatch(it -> it.equals("*"))) {
                    return this.includedRepos.contains(repo.getId());
                }
                if (this.includedRepos.stream().anyMatch(it -> it.equals("*"))) {
                    return !this.excludedRepos.contains(repo.getId());
                }
                return !this.excludedRepos.contains(repo.getId()) && this.includedRepos.contains(repo.getId());
            }

            private boolean isInternal(RawRepositories.Repository repo) {
                URI repoUri = URI.create(repo.getUrl());
                if (repoUri.getScheme().startsWith("file")) {
                    return true;
                }
                return repoUri.getHost().equals("localhost") || repoUri.getHost().equals("127.0.0.1");
            }
        }

        private static interface ApplicabilitySpec {
            public boolean isApplicable(RawRepositories.Repository var1);
        }
    }

    public static class Mirrors {
        @JacksonXmlProperty(localName="mirror")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Mirror> mirrors = Collections.emptyList();

        public List<RawRepositories.Repository> applyMirrors(Collection<RawRepositories.Repository> repositories) {
            return repositories.stream().map(this::applyMirrors).distinct().collect(Collectors.toList());
        }

        public RawRepositories.Repository applyMirrors(RawRepositories.Repository repository) {
            RawRepositories.Repository result = repository;
            for (Mirror mirror : this.mirrors) {
                result = mirror.apply(result);
            }
            return result;
        }

        public List<Mirror> getMirrors() {
            return this.mirrors;
        }

        @JacksonXmlProperty(localName="mirror")
        public void setMirrors(List<Mirror> mirrors) {
            this.mirrors = mirrors;
        }
    }

    public static class Profile {
        @Nullable
        private final String id;
        @Nullable
        private final RawRepositories repositories;

        @JsonIgnore
        public boolean isActive(Collection<String> activeProfiles) {
            if (this.id != null) {
                for (String activeProfile : activeProfiles) {
                    if (!activeProfile.trim().equals(this.id)) continue;
                    return true;
                }
            }
            return false;
        }

        @ConstructorProperties(value={"id", "repositories"})
        public Profile(String id, RawRepositories repositories) {
            this.id = id;
            this.repositories = repositories;
        }

        public String getId() {
            return this.id;
        }

        public RawRepositories getRepositories() {
            return this.repositories;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            RawRepositories this$repositories = this.getRepositories();
            RawRepositories other$repositories = other.getRepositories();
            return !(this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Profile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            RawRepositories $repositories = this.getRepositories();
            result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
            return result;
        }

        public String toString() {
            return "MavenSettings.Profile(id=" + this.getId() + ", repositories=" + this.getRepositories() + ")";
        }
    }

    public static class ActiveProfiles {
        @JacksonXmlProperty(localName="activeProfile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<String> activeProfiles = Collections.emptyList();

        public List<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        @JacksonXmlProperty(localName="activeProfile")
        public void setActiveProfiles(List<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
        }
    }

    public static class Profiles {
        @JacksonXmlProperty(localName="profile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Profile> profiles = Collections.emptyList();

        public List<Profile> getProfiles() {
            return this.profiles;
        }

        @JacksonXmlProperty(localName="profile")
        public void setProfiles(List<Profile> profiles) {
            this.profiles = profiles;
        }
    }
}

