/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddDependency;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.MavenSourceVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlRefactorVisitor;
import org.openrewrite.xml.tree.Xml;

public class MavenRefactorVisitor
extends XmlRefactorVisitor
implements MavenSourceVisitor<Xml> {
    private static final XPathMatcher DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencies/dependency");
    private static final XPathMatcher MANAGED_DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies/dependency");
    private static final XPathMatcher PROPERTY_MATCHER = new XPathMatcher("/project/properties/*");
    private static final XPathMatcher PARENT_MATCHER = new XPathMatcher("/project/parent");
    protected Pom model;
    protected Collection<Pom> modules;
    protected MavenSettings settings;

    @Override
    public Maven visitMaven(Maven maven) {
        this.model = maven.getModel();
        this.modules = maven.getModules();
        this.settings = maven.getSettings();
        return (Maven)this.visitDocument(maven);
    }

    public final Xml visitDocument(Xml.Document document) {
        Xml.Document refactored = (Xml.Document)this.refactor((Tree)document, x$0 -> super.visitDocument(x$0));
        if (refactored != document) {
            return new Maven(refactored, this.settings);
        }
        return refactored;
    }

    public boolean isPropertyTag() {
        return PROPERTY_MATCHER.matches(this.getCursor());
    }

    public boolean isDependencyTag() {
        return DEPENDENCY_MATCHER.matches(this.getCursor());
    }

    public boolean isDependencyTag(String groupId, @Nullable String artifactId) {
        return this.isDependencyTag() && this.hasGroupAndArtifact(groupId, artifactId);
    }

    public boolean isManagedDependencyTag() {
        return MANAGED_DEPENDENCY_MATCHER.matches(this.getCursor());
    }

    public boolean isManagedDependencyTag(String groupId, @Nullable String artifactId) {
        return this.isManagedDependencyTag() && this.hasGroupAndArtifact(groupId, artifactId);
    }

    public boolean isParentTag() {
        return PARENT_MATCHER.matches(this.getCursor());
    }

    private boolean hasGroupAndArtifact(String groupId, @Nullable String artifactId) {
        Xml.Tag tag = (Xml.Tag)this.getCursor().getTree();
        return groupId.equals(tag.getChildValue("groupId").orElse(this.model.getGroupId())) && tag.getChildValue("artifactId").map(a -> a.equals(artifactId)).orElse(artifactId == null) != false;
    }

    @Nullable
    public Pom.Dependency findDependency(Xml.Tag tag) {
        return this.model.getDependencies().stream().filter(d -> tag.getChildValue("groupId").orElse(this.model.getGroupId()).equals(d.getGroupId()) && tag.getChildValue("artifactId").orElse(this.model.getArtifactId()).equals(d.getArtifactId())).findAny().orElse(null);
    }

    public Collection<Pom.Dependency> findDependencies(String groupId, String artifactId) {
        return this.findDependencies(d -> d.getGroupId().equals(groupId) && d.getArtifactId().equals(artifactId));
    }

    public Collection<Pom.Dependency> findDependencies(Predicate<Pom.Dependency> matcher) {
        return Stream.concat(this.model.getDependencies().stream().filter(matcher), this.model.getDependencies().stream().flatMap(d -> d.findDependencies(matcher).stream())).collect(Collectors.toList());
    }

    public void maybeAddDependency(String groupId, String artifactId, @Nullable String version, @Nullable String classifier, @Nullable String scope) {
        AddDependency op = new AddDependency();
        op.setGroupId(groupId);
        op.setArtifactId(artifactId);
        op.setClassifier(classifier);
        op.setScope(scope);
        op.setVersion(version);
        op.setSkipIfPresent(true);
        if (!this.andThen().contains(op)) {
            this.andThen((RefactorVisitor)op);
        }
    }
}

