/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.maven.internal.Version;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.AddToTag;
import org.openrewrite.xml.ChangeTagValue;
import org.openrewrite.xml.RemoveContent;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class ManageDependencies
extends MavenRefactorVisitor {
    Pattern groupPattern;
    @Nullable
    Pattern artifactPattern;
    @Nullable
    String version;
    String selectedVersion;

    public ManageDependencies() {
        this.setCursoringOn();
    }

    public void setGroupPattern(@Nullable String groupPattern) {
        this.groupPattern = groupPattern == null ? null : Pattern.compile(groupPattern.replace("*", ".*"));
    }

    public void setArtifactPattern(@Nullable String artifactPattern) {
        this.artifactPattern = artifactPattern == null ? null : Pattern.compile(artifactPattern.replace("*", ".*"));
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public Validated validate() {
        return Validated.required((String)"groupPattern", (Object)this.groupPattern);
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public Maven visitMaven(Maven maven) {
        this.model = maven.getModel();
        Collection<Pom.Dependency> manageableDependencies = this.findDependencies(d -> this.groupPattern.matcher(d.getGroupId()).matches() && (this.artifactPattern == null || this.artifactPattern.matcher(d.getArtifactId()).matches()));
        this.selectedVersion = this.version;
        if (!manageableDependencies.isEmpty()) {
            List requiresDependencyManagement;
            if (this.version == null) {
                this.selectedVersion = manageableDependencies.stream().map(Pom.Dependency::getVersion).max(Comparator.comparing(Version::new)).get();
            }
            if (!(requiresDependencyManagement = manageableDependencies.stream().filter(d -> this.model.getManagedVersion(d.getGroupId(), d.getArtifactId()) == null).map(d -> new GroupArtifact(d.getGroupId(), d.getArtifactId())).distinct().collect(Collectors.toList())).isEmpty()) {
                Xml.Tag root = maven.getRoot();
                if (!root.getChild("dependencyManagement").isPresent()) {
                    this.andThen((RefactorVisitor)new AddToTag.Scoped(root, Xml.Tag.build((String)"<dependencyManagement>\n<dependencies/>\n</dependencyManagement>"), (Comparator)new MavenTagInsertionComparator(root.getChildren())));
                }
                for (GroupArtifact ga : requiresDependencyManagement) {
                    this.andThen((RefactorVisitor)new InsertDependencyInOrder(ga.getGroupId(), ga.getArtifactId(), this.selectedVersion));
                }
            }
        }
        return super.visitMaven(maven);
    }

    public Xml visitTag(Xml.Tag tag) {
        if (this.isManagedDependencyTag() && this.hasMatchingGroupArtifact(tag)) {
            this.andThen((RefactorVisitor)new ChangeTagValue.Scoped((Xml.Tag)tag.getChild("version").orElseThrow(() -> new IllegalStateException("Version tag must exist")), this.selectedVersion));
        } else if (this.isDependencyTag() && this.hasMatchingGroupArtifact(tag)) {
            tag.getChild("version").ifPresent(version -> this.andThen((RefactorVisitor)new RemoveContent.Scoped((Content)version, false)));
            return tag;
        }
        return super.visitTag(tag);
    }

    private boolean hasMatchingGroupArtifact(Xml.Tag tag) {
        return this.groupPattern.matcher(tag.getChildValue("groupId").orElse(this.model.getGroupId())).matches() && (this.artifactPattern == null || this.artifactPattern.matcher(tag.getChildValue("artifactId").orElse(this.model.getArtifactId())).matches());
    }

    private static class InsertDependencyInOrder
    extends MavenRefactorVisitor {
        private static final XPathMatcher MANAGED_DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies");
        private final String groupId;
        private final String artifactId;
        private final String version;

        private InsertDependencyInOrder(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.setCursoringOn();
        }

        public Xml visitTag(Xml.Tag tag) {
            if (MANAGED_DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + this.groupId + "</groupId>\n<artifactId>" + this.artifactId + "</artifactId>\n" + (this.version == null ? "" : "<version>" + this.version + "</version>\n") + "</dependency>"));
                this.andThen((RefactorVisitor)new AddToTag.Scoped(tag, dependencyTag, (Comparator)new InsertDependencyComparator(tag.getChildren(), dependencyTag)));
                return tag;
            }
            return super.visitTag(tag);
        }
    }
}

