/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.xml.ChangeTagValue;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class ChangeParentVersion
extends MavenRefactorVisitor {
    private static final XPathMatcher PARENT_VERSION_MATCHER = new XPathMatcher("/project/parent/version");
    private String groupId;
    private String artifactId;
    private String toVersion;

    public ChangeParentVersion() {
        this.setCursoringOn();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId)).and(Validated.required((String)"toVersion", (Object)this.toVersion));
    }

    public Xml visitTag(Xml.Tag tag) {
        Xml.Tag parent;
        if (PARENT_VERSION_MATCHER.matches(this.getCursor()) && this.groupId.equals((parent = (Xml.Tag)this.getCursor().getParentOrThrow().getTree()).getChildValue("groupId").orElse(null)) && this.artifactId.equals(parent.getChildValue("artifactId").orElse(null)) && !this.toVersion.equals(tag.getValue().orElse(null))) {
            this.andThen((RefactorVisitor)new ChangeTagValue.Scoped(tag, this.toVersion));
        }
        return super.visitTag(tag);
    }
}

