/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.refactor.Formatter;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public class AddOrUpdateDependencyManagement
extends MavenRefactorVisitor {
    private String groupId;
    private String artifactId;
    @Nullable
    private String version;
    @Nullable
    private String scope;
    @Nullable
    private String type;

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId));
    }

    @Override
    public Maven visitPom(Maven.Pom pom) {
        if (this.dependencyManagementSectionExists(pom) && this.managedDependencyExists(pom)) {
            return pom;
        }
        this.andThen((RefactorVisitor)new AddDependenciesTagIfNotPresent());
        if (this.dependencyWithGroupIdAndArtifactIdExists(pom)) {
            this.andThen((RefactorVisitor)new UpdateDependency());
        } else {
            this.andThen((RefactorVisitor)new InsertDependencyInOrder());
        }
        return pom;
    }

    private boolean dependencyManagementSectionExists(Maven.Pom pom) {
        return pom.getModel().getDependencyManagement() != null;
    }

    private boolean managedDependencyExists(Maven.Pom pom) {
        if (pom.getDependencyManagement() != null) {
            return pom.getDependencyManagement().getDependencies().stream().anyMatch(this::sameDependencyExists);
        }
        return false;
    }

    private boolean sameDependencyExists(Maven.Dependency d) {
        return this.artifactId.equals(d.getArtifactId()) && this.groupId.equals(d.getGroupId()) && (this.version != null && d.getVersion() != null ? this.version.equals(d.getVersion()) : this.version == null && d.getVersion() == null) && (this.scope != null && d.getScope() != null ? this.scope.equals(d.getScope()) : this.scope == null && d.getScope() == null) && (this.type != null && d.getScope() != null ? this.type.equals(d.getScope()) : this.type == null && d.getScope() == null);
    }

    private boolean dependencyWithGroupIdAndArtifactIdExists(Maven.Pom pom) {
        if (pom.getDependencyManagement() != null) {
            return pom.getDependencyManagement().getDependencies().stream().anyMatch(d -> this.groupId.equals(d.getGroupId()) && this.artifactId.equals(d.getArtifactId()));
        }
        return false;
    }

    @NotNull
    private Maven.Dependency createMavenDependencyManagementDependency(Formatter.Result ident) {
        Xml.Tag tag = this.createDependencyTag(ident);
        return new Maven.Dependency(false, new MavenModel.Dependency(new MavenModel.ModuleVersionId(this.groupId, this.artifactId, null, this.version, "jar"), this.version, this.scope), tag);
    }

    private Xml.Tag createDependencyTag(Formatter.Result indent) {
        int offset = 2;
        return ((Xml.Document)new XmlParser().parse(new String[]{"<dependency>" + indent.getPrefix(offset + 1) + "<groupId>" + this.groupId + "</groupId>" + indent.getPrefix(offset + 1) + "<artifactId>" + this.artifactId + "</artifactId>" + (this.version == null ? "" : indent.getPrefix(offset + 1) + "<version>" + this.version + "</version>") + (this.scope == null ? "" : indent.getPrefix(offset + 1) + "<scope>" + this.scope + "</scope>") + (this.type == null ? "" : indent.getPrefix(offset + 1) + "<type>" + this.type + "</type>") + indent.getPrefix(offset) + "</dependency>"}).get(0)).getRoot().withFormatting(Formatting.format((String)indent.getPrefix(offset)));
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setType(String type) {
        this.type = type;
    }

    private class InsertDependencyInOrder
    extends MavenRefactorVisitor {
        private InsertDependencyInOrder() {
        }

        @Override
        public Maven visitPom(Maven.Pom pom) {
            Maven.Pom p = (Maven.Pom)this.refactor(pom, x$0 -> super.visitPom((Maven.Pom)x$0));
            Maven.DependencyManagement dm = pom.getDependencyManagement();
            if (dm == null) {
                return p;
            }
            ArrayList<Maven.Dependency> dependencies = new ArrayList<Maven.Dependency>(dm.getDependencies());
            Maven.Dependency toAdd = AddOrUpdateDependencyManagement.this.createMavenDependencyManagementDependency(this.formatter.wholeSourceIndent());
            int indexToAdd = 0;
            if (!dependencies.isEmpty()) {
                List<Maven.Dependency> dependenciesWithSameGroupid = this.getDependenciesWithSameGroupId(pom, toAdd);
                indexToAdd = dependenciesWithSameGroupid.isEmpty() ? this.findIndexWithoutExistingGroupId(dependencies, toAdd) : this.findIndexWithExistingGroupId(dependencies, toAdd, dependenciesWithSameGroupid);
            }
            dependencies.add(indexToAdd, toAdd);
            p = p.withDependencyManagement(dm.withDependencies(dependencies));
            return p;
        }

        private int findIndexWithoutExistingGroupId(List<Maven.Dependency> dependencies, Maven.Dependency toAdd) {
            ArrayList<Maven.Dependency> sortedDependencies = new ArrayList<Maven.Dependency>(dependencies);
            sortedDependencies.add(toAdd);
            sortedDependencies.sort(Comparator.comparing(Maven.Dependency::getGroupId).thenComparing(Maven.Dependency::getArtifactId));
            int indexInSortedList = sortedDependencies.indexOf(toAdd);
            if (indexInSortedList > 0) {
                Maven.Dependency predecessor = (Maven.Dependency)sortedDependencies.get(indexInSortedList - 1);
                return dependencies.indexOf(predecessor) + 1;
            }
            return 0;
        }

        private int findIndexWithExistingGroupId(List<Maven.Dependency> dependencies, Maven.Dependency toAdd, List<Maven.Dependency> dependenciesWithSameGroupid) {
            dependenciesWithSameGroupid.add(toAdd);
            dependenciesWithSameGroupid.sort(Comparator.comparing(Maven.Dependency::getGroupId).thenComparing(Maven.Dependency::getArtifactId));
            int indexInSortedList = dependenciesWithSameGroupid.indexOf(toAdd);
            if (indexInSortedList > 0) {
                Maven.Dependency predecessor = dependenciesWithSameGroupid.get(indexInSortedList - 1);
                indexInSortedList = dependencies.indexOf(predecessor) + 1;
            } else {
                Maven.Dependency successor = dependenciesWithSameGroupid.get(indexInSortedList + 1);
                indexInSortedList = dependencies.indexOf(successor);
            }
            return indexInSortedList;
        }

        @NotNull
        private List<Maven.Dependency> getDependenciesWithSameGroupId(Maven.Pom pom, Maven.Dependency toAdd) {
            if (pom.getDependencyManagement() == null) {
                return Collections.emptyList();
            }
            return pom.getDependencyManagement().getDependencies().stream().filter(d -> d.getGroupId() != null && d.getGroupId().equals(toAdd.getGroupId())).collect(Collectors.toList());
        }
    }

    private class UpdateDependency
    extends MavenRefactorVisitor {
        private UpdateDependency() {
        }

        @Override
        public Maven visitPom(Maven.Pom pom) {
            Maven.Pom p = (Maven.Pom)this.refactor(pom, x$0 -> super.visitPom((Maven.Pom)x$0));
            Maven.DependencyManagement dm = pom.getDependencyManagement();
            if (dm == null) {
                return p;
            }
            ArrayList<Maven.Dependency> dependencies = new ArrayList<Maven.Dependency>(dm.getDependencies());
            Maven.Dependency dependency = this.findDependencyWithGroupIdAndArtifactId(dependencies);
            if (dependency == null) {
                return p;
            }
            Maven.Dependency updatedDependency = AddOrUpdateDependencyManagement.this.createMavenDependencyManagementDependency(this.formatter.wholeSourceIndent());
            dependencies.set(dependencies.indexOf(dependency), updatedDependency);
            p = p.withDependencyManagement(dm.withDependencies(dependencies));
            return p;
        }

        @Nullable
        private Maven.Dependency findDependencyWithGroupIdAndArtifactId(List<Maven.Dependency> dependencies) {
            return dependencies.stream().filter(d -> AddOrUpdateDependencyManagement.this.groupId.equals(d.getGroupId()) && AddOrUpdateDependencyManagement.this.artifactId.equals(d.getArtifactId())).findFirst().orElse(null);
        }
    }

    private static class AddDependenciesTagIfNotPresent
    extends MavenRefactorVisitor {
        private AddDependenciesTagIfNotPresent() {
        }

        @Override
        public Maven visitPom(Maven.Pom pom) {
            Maven.Pom p = (Maven.Pom)this.refactor(pom, x$0 -> super.visitPom((Maven.Pom)x$0));
            if (!this.hasDependencyManagementTag(p)) {
                p = this.addDependencyManagementTag(p);
            }
            if (!this.hasDependenciesTag(p)) {
                p = this.addDependenciesTag(p);
            }
            return p;
        }

        private boolean hasDependencyManagementTag(Maven.Pom p) {
            return p.getDependencyManagement() != null;
        }

        private Maven.Pom addDependencyManagementTag(Maven.Pom p) {
            p = p.withDependencyManagement(new Maven.DependencyManagement(new MavenModel.DependencyManagement(new ArrayList<MavenModel.Dependency>()), this.createDependencyManagementTag(this.formatter.wholeSourceIndent())));
            return p;
        }

        @NotNull
        private Xml.Tag createDependencyManagementTag(Formatter.Result indent) {
            int offset = 0;
            return ((Xml.Document)new XmlParser().parse(new String[]{"<dependencyManagement>" + indent.getPrefix(offset) + "</dependencyManagement>"}).get(0)).getRoot().withFormatting(Formatting.format((String)indent.getPrefix(offset)));
        }

        private boolean hasDependenciesTag(Maven.Pom p) {
            return p.getDependencyManagement() != null && p.getDependencyManagement().getDependencies() != null && !p.getDependencyManagement().getDependencies().isEmpty();
        }

        private Maven.Pom addDependenciesTag(Maven.Pom p) {
            Maven.DependencyManagement dm = p.getDependencyManagement();
            if (dm == null) {
                return p;
            }
            Xml.Tag tag = dm.getTag();
            ArrayList<Xml.Tag> contents = new ArrayList<Xml.Tag>(tag.getContent());
            Xml.Tag dependenciesTag = this.createDependenciesTag(this.formatter.wholeSourceIndent());
            contents.add(dependenciesTag);
            dm = new Maven.DependencyManagement(dm.getModel(), tag.withContent(contents));
            p = p.withDependencyManagement(dm);
            return p;
        }

        private Xml.Tag createDependenciesTag(Formatter.Result indent) {
            int offset = 1;
            return ((Xml.Document)new XmlParser().parse(new String[]{"<dependencies>" + indent.getPrefix(offset) + "</dependencies>"}).get(0)).getRoot().withFormatting(Formatting.format((String)indent.getPrefix(offset)));
        }
    }
}

