/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MavenRepositorySystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(MavenRepositorySystemUtils.class);

    private MavenRepositorySystemUtils() {
    }

    public static RepositorySystem getRepositorySystem() {
        DefaultServiceLocator serviceLocator = org.apache.maven.repository.internal.MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, FileTransporterFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
    }

    public static DefaultRepositorySystemSession getRepositorySystemSession(RepositorySystem system, File localRepositoryDir, WorkspaceReader workspaceReader) {
        DefaultRepositorySystemSession repositorySystemSession = org.apache.maven.repository.internal.MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(localRepositoryDir);
        repositorySystemSession.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)repositorySystemSession, localRepository));
        repositorySystemSession.setChecksumPolicy("ignore");
        repositorySystemSession.setCache((RepositoryCache)new DefaultRepositoryCache());
        repositorySystemSession.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(3));
        repositorySystemSession.setWorkspaceReader(workspaceReader);
        repositorySystemSession.setRepositoryListener((RepositoryListener)new ConsoleRepositoryEventListener());
        repositorySystemSession.setDependencySelector((DependencySelector)new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(Collections.emptyList(), Arrays.asList("provided", "test", "runtime")), new OptionalDependencySelector()}));
        repositorySystemSession.setReadOnly();
        return repositorySystemSession;
    }

    private static class ConsoleRepositoryEventListener
    extends AbstractRepositoryListener {
        private ConsoleRepositoryEventListener() {
        }

        public void artifactInstalled(RepositoryEvent event) {
            logger.debug("artifact {} installed to file {}", (Object)event.getArtifact(), (Object)event.getFile());
        }

        public void artifactInstalling(RepositoryEvent event) {
            logger.debug("installing artifact {} to file {}", (Object)event.getArtifact(), (Object)event.getFile());
        }

        public void artifactResolved(RepositoryEvent event) {
            logger.debug("artifact {} resolved from repository {}", (Object)event.getArtifact(), (Object)event.getRepository());
        }

        public void artifactDownloading(RepositoryEvent event) {
            logger.debug("downloading artifact {} from repository {}", (Object)event.getArtifact(), (Object)event.getRepository());
        }

        public void artifactDownloaded(RepositoryEvent event) {
            logger.debug("downloaded artifact {} from repository {}", (Object)event.getArtifact(), (Object)event.getRepository());
        }

        public void artifactResolving(RepositoryEvent event) {
            logger.debug("resolving artifact {}", (Object)event.getArtifact());
        }
    }
}

