/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsSource;
import org.apache.maven.settings.building.StringSettingsSource;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenModuleLoader;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public class MavenParser
implements Parser<Maven.Pom> {
    public static final File DEFAULT_LOCAL_REPOSITORY = new File(System.getProperty("user.home") + "/.m2/rewrite");
    private final XmlParser xmlParser = new XmlParser();
    private final boolean resolveDependencies;
    private final File localRepository;
    @Nullable
    private final File workspaceDir;
    private final List<RemoteRepository> remoteRepositories;

    private MavenParser(boolean resolveDependencies, File localRepository, @Nullable File workspaceDir, List<RemoteRepository> remoteRepositories) {
        this.resolveDependencies = resolveDependencies;
        this.localRepository = localRepository;
        this.workspaceDir = workspaceDir;
        this.remoteRepositories = remoteRepositories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Maven.Pom> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo) {
        List pomSourceFiles = this.acceptedInputs(sourceFiles);
        List<MavenModel> modules = new MavenModuleLoader(this.resolveDependencies, this.localRepository, this.workspaceDir, this.remoteRepositories).load(pomSourceFiles);
        ArrayList<Maven.Pom> poms = new ArrayList<Maven.Pom>();
        Iterator xmlDocuments = this.xmlParser.parseInputs((Iterable)pomSourceFiles, relativeTo).iterator();
        for (MavenModel module : modules) {
            poms.add(new Maven.Pom(module, (Xml.Document)xmlDocuments.next()));
        }
        return poms;
    }

    public boolean accept(Path path) {
        return path.getFileName().toString().equals("pom.xml");
    }

    public static class Builder {
        private boolean resolveDependencies = true;
        private boolean useMavenCentral = true;
        private File localRepository;
        private List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        private Parser.Input userSettingsXmlOverride;
        private Parser.Input globaLSettingsXmlOverride;
        @Nullable
        private File workspaceDir;

        public Builder noMavenCentral() {
            this.useMavenCentral = false;
            return this;
        }

        public Builder userSettingsXml(Parser.Input settingsXmlOverride) {
            this.userSettingsXmlOverride = settingsXmlOverride;
            return this;
        }

        public Builder globalSettingsXml(Parser.Input settingsXmlOverride) {
            this.globaLSettingsXmlOverride = settingsXmlOverride;
            return this;
        }

        public Builder localRepository(File localRepository) {
            this.localRepository = localRepository;
            return this;
        }

        public Builder workspaceDir(File workspaceDir) {
            this.workspaceDir = workspaceDir;
            return this;
        }

        public Builder resolveDependencies(boolean resolveDependencies) {
            this.resolveDependencies = resolveDependencies;
            return this;
        }

        public Builder remoteRepositories(List<RemoteRepository> remoteRepositories) {
            this.remoteRepositories = new ArrayList<RemoteRepository>(remoteRepositories);
            return this;
        }

        public Builder addRemoteRepository(RemoteRepository remoteRepository) {
            this.remoteRepositories.add(remoteRepository);
            return this;
        }

        private Settings getEffectiveSettings() {
            StringSettingsSource source;
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
            if (this.userSettingsXmlOverride == null) {
                File settingsXml = new File(System.getProperty("user.home"), ".m2/settings.xml");
                if (settingsXml.exists()) {
                    settingsRequest.setUserSettingsFile(settingsXml);
                }
            } else {
                source = new StringSettingsSource((CharSequence)StringUtils.readFully((InputStream)this.userSettingsXmlOverride.getSource()));
                settingsRequest.setUserSettingsSource((SettingsSource)source);
            }
            if (this.globaLSettingsXmlOverride == null) {
                File globalSettingsXml = new File(System.getProperty("maven.conf"), "settings.xml");
                if (globalSettingsXml.exists()) {
                    settingsRequest.setGlobalSettingsFile(globalSettingsXml);
                }
            } else {
                source = new StringSettingsSource((CharSequence)StringUtils.readFully((InputStream)this.globaLSettingsXmlOverride.getSource()));
                settingsRequest.setGlobalSettingsSource((SettingsSource)source);
            }
            try {
                return settingsBuilder.build((SettingsBuildingRequest)settingsRequest).getEffectiveSettings();
            }
            catch (SettingsBuildingException e) {
                throw new RuntimeException(e);
            }
        }

        public MavenParser build() {
            Settings effectiveSettings = this.getEffectiveSettings();
            if (this.localRepository == null) {
                this.localRepository = effectiveSettings.getLocalRepository() == null ? DEFAULT_LOCAL_REPOSITORY : new File(effectiveSettings.getLocalRepository());
            }
            Map idToServer = effectiveSettings.getServers().stream().collect(Collectors.toMap(IdentifiableBase::getId, Function.identity()));
            List settingsDefinedRepositories = Builder.getActiveProfiles(effectiveSettings).stream().flatMap(profile -> profile.getRepositories().stream()).map(mvnRepository -> {
                RemoteRepository.Builder builder = new RemoteRepository.Builder(mvnRepository.getId(), "default", mvnRepository.getUrl());
                Server credentials = (Server)idToServer.get(mvnRepository.getId());
                if (credentials != null) {
                    Authentication authentication = new AuthenticationBuilder().addPassword(credentials.getPassword()).addUsername(credentials.getUsername()).addPrivateKey(credentials.getPrivateKey(), credentials.getPassphrase()).build();
                    builder.setAuthentication(authentication);
                }
                return builder.build();
            }).collect(Collectors.toList());
            if (this.useMavenCentral) {
                this.remoteRepositories.add(new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build());
            }
            this.remoteRepositories.addAll(settingsDefinedRepositories);
            return new MavenParser(this.resolveDependencies, this.localRepository, this.workspaceDir, this.remoteRepositories);
        }

        private static List<Profile> getActiveProfiles(Settings settings) {
            HashSet explicitlyActivatedProfiles = new HashSet(settings.getActiveProfiles());
            return settings.getProfiles().stream().filter(profile -> explicitlyActivatedProfiles.contains(profile.getId()) || Builder.isActive(profile.getActivation())).collect(Collectors.toList());
        }

        private static boolean isActive(Activation activation) {
            return activation.isActiveByDefault();
        }
    }
}

