/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.stream.Collectors;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.xml.tree.Content;

public class ChangeDependencyScope
extends MavenRefactorVisitor {
    private String groupId;
    private String artifactId;
    @Nullable
    private String toScope;

    public ChangeDependencyScope() {
        this.setCursoringOn();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToScope(@Nullable String toScope) {
        this.toScope = toScope;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId));
    }

    @Override
    public Maven visitDependency(Maven.Dependency dependency) {
        Maven.Dependency d = (Maven.Dependency)this.refactor(dependency, x$0 -> super.visitDependency((Maven.Dependency)x$0));
        Maven.Pom pom = (Maven.Pom)this.getCursor().firstEnclosing(Maven.Pom.class);
        assert (pom != null);
        MavenModel.ModuleVersionId mvid = dependency.getModel().getModuleVersion();
        if (mvid.getGroupId().equals(this.groupId) && (this.artifactId == null || mvid.getArtifactId().equals(this.artifactId))) {
            String scope = dependency.getScope();
            if (scope == null && this.toScope != null) {
                this.andThen((RefactorVisitor)new Scoped(d, this.toScope));
            } else if (this.toScope == null && scope != null) {
                this.andThen((RefactorVisitor)new Scoped(d, null));
            } else if (scope != null && !scope.equals(this.toScope)) {
                this.andThen((RefactorVisitor)new Scoped(d, this.toScope));
            }
        }
        return d;
    }

    public static class Scoped
    extends MavenRefactorVisitor {
        private final Maven.Dependency scope;
        private final String toScope;

        public Scoped(Maven.Dependency scope, String toScope) {
            this.scope = scope;
            this.toScope = toScope;
        }

        @Override
        public Maven visitDependency(Maven.Dependency dependency) {
            Maven.Dependency d = (Maven.Dependency)this.refactor(dependency, x$0 -> super.visitDependency((Maven.Dependency)x$0));
            if (this.scope.isScope(dependency)) {
                d = this.toScope == null ? d.withTag(d.getTag().withContent(d.getTag().getChildren().stream().filter(t -> !t.getName().equals("scope")).map(Content.class::cast).collect(Collectors.toList()))) : d.withScope(this.toScope);
            }
            return d;
        }
    }
}

