/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Formatting;
import org.openrewrite.Metadata;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenSourceVisitor;
import org.openrewrite.maven.internal.PrintMaven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.maven.tree.MemoizedTags;
import org.openrewrite.xml.ChangeTagContent;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface Maven
extends Serializable,
Tree {
    default public String print() {
        return (String)new PrintMaven().visit(this);
    }

    default public <R> R accept(SourceVisitor<R> v) {
        return (R)(v instanceof MavenSourceVisitor ? this.acceptMaven((MavenSourceVisitor)v) : v.defaultTo(null));
    }

    default public <R> R acceptMaven(MavenSourceVisitor<R> v) {
        return (R)v.defaultTo(null);
    }

    public static Optional<String> getPropertyKey(String textValue) {
        if (textValue.startsWith("${") && textValue.endsWith("}")) {
            return Optional.of(textValue.substring(2, textValue.length() - 1));
        }
        return Optional.empty();
    }

    public static class DependencyManagement
    implements Maven {
        private final MavenModel.DependencyManagement model;
        private final Xml.Tag tag;
        @JsonIgnore
        private final MemoizedTags<Dependency> memoizedDependencies;

        @ConstructorProperties(value={"model", "tag"})
        public DependencyManagement(MavenModel.DependencyManagement model, Xml.Tag tag) {
            this.model = model;
            this.tag = tag;
            this.memoizedDependencies = new MemoizedTags<Dependency>(tag, "dependencies/dependency", dm -> new Dependency(true, model.getDependencies().stream().filter(d -> d.getModuleVersion().getGroupId().equals(dm.getChildValue("groupId").orElse(null)) && d.getModuleVersion().getArtifactId().equals(dm.getChildValue("artifactId").orElse(null))).findAny().orElse(null), (Xml.Tag)dm), Dependency::getTag);
        }

        public MavenModel.DependencyManagement getModel() {
            return this.model;
        }

        public Xml.Tag getTag() {
            return this.tag;
        }

        public DependencyManagement withDependencies(List<Dependency> dependencies) {
            return this.memoizedDependencies.with(dependencies).map(root -> new DependencyManagement(this.model.withDependencies(dependencies.stream().map(Dependency::getModel).collect(Collectors.toList())), (Xml.Tag)root)).orElse(this);
        }

        @JsonIgnore
        public List<Dependency> getDependencies() {
            return this.memoizedDependencies.getModels();
        }

        @JsonIgnore
        public Formatting getFormatting() {
            return this.tag.getFormatting();
        }

        @JsonIgnore
        public UUID getId() {
            return this.tag.getId();
        }

        public <T extends Tree> T withFormatting(Formatting fmt) {
            return (T)this.tag.withFormatting(fmt);
        }

        @Override
        public <R> R acceptMaven(MavenSourceVisitor<R> v) {
            return v.visitDependencyManagement(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyManagement that = (DependencyManagement)o;
            return this.model.equals(that.model) && this.tag.equals((Object)that.tag);
        }

        public int hashCode() {
            return Objects.hash(this.model, this.tag);
        }
    }

    public static class Property
    implements Maven {
        final Xml.Tag tag;

        @ConstructorProperties(value={"tag"})
        public Property(Xml.Tag tag) {
            this.tag = tag;
        }

        @JsonIgnore
        public String getKey() {
            return this.tag.getName();
        }

        public Property withKey(String key) {
            return new Property(this.tag.withName(key));
        }

        @JsonIgnore
        public String getValue() {
            return this.tag.getValue().orElse("");
        }

        public Property withValue(String value) {
            return new Property(this.tag.withValue(value));
        }

        @JsonIgnore
        public Formatting getFormatting() {
            return this.tag.getFormatting();
        }

        public Property withFormatting(Formatting fmt) {
            return new Property(this.tag.withFormatting(fmt));
        }

        @JsonIgnore
        public UUID getId() {
            return this.tag.getId();
        }

        @Override
        public <R> R acceptMaven(MavenSourceVisitor<R> v) {
            return v.visitProperty(this);
        }

        public Stream<MavenModel.Dependency> findDependencies(@Nullable Pom pom, String groupId, @Nullable String artifactId) {
            return Optional.ofNullable(pom).map(pom2 -> pom2.getModel().getInheriting().stream().flatMap(mod -> mod.getDependencies().stream().filter(d -> Maven.getPropertyKey(d.getRequestedVersion()).map(prop -> prop.equals(this.getKey())).orElse(false)).filter(d -> d.getModuleVersion().getGroupId().equals(groupId) && (artifactId == null || d.getModuleVersion().getArtifactId().equals(artifactId))))).orElse(Stream.empty());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            return this.tag == property.tag;
        }

        public int hashCode() {
            return Objects.hash(this.tag);
        }

        public Xml.Tag getTag() {
            return this.tag;
        }
    }

    public static class Dependency
    implements Maven {
        private final boolean isManaged;
        private final MavenModel.Dependency model;
        private final Xml.Tag tag;

        @ConstructorProperties(value={"isManaged", "model", "tag"})
        public Dependency(boolean isManaged, MavenModel.Dependency model, Xml.Tag tag) {
            this.isManaged = isManaged;
            this.model = model;
            this.tag = tag;
        }

        public boolean isManaged() {
            return this.isManaged;
        }

        @JsonIgnore
        @Nullable
        public String getGroupId() {
            return this.tag.getChildValue("groupId").orElse(null);
        }

        public Dependency withGroupId(String groupId) {
            return new Dependency(this.isManaged, this.model.withModuleVersion(this.model.getModuleVersion().withGroupId(groupId)), this.tag.withChildValue("groupId", groupId));
        }

        @JsonIgnore
        @Nullable
        public String getArtifactId() {
            return this.tag.getChildValue("artifactId").orElse(null);
        }

        public Dependency withArtifactId(String artifactId) {
            return new Dependency(this.isManaged, this.model.withModuleVersion(this.model.getModuleVersion().withArtifactId(artifactId)), this.tag.withChildValue("artifactId", artifactId));
        }

        @JsonIgnore
        @Nullable
        public String getVersion() {
            return this.tag.getChildValue("version").orElse(null);
        }

        public Dependency withVersion(String version) {
            Xml.Tag t = this.tag.withChildValue("version", version);
            if (!t.getChild("version").isPresent()) {
                ArrayList<Xml.Tag> content = new ArrayList<Xml.Tag>(t.getContent());
                content.add(new XmlParser().parseTag("<version>" + version + "</version>").withFormatting(((Content)content.get(0)).getFormatting()));
                t = t.withContent(content);
            }
            return new Dependency(this.isManaged, this.model.withModuleVersion(this.model.getModuleVersion().withVersion(version)), t);
        }

        @JsonIgnore
        @Nullable
        public String getScope() {
            return this.tag.getChildValue("scope").orElse(null);
        }

        public Dependency withScope(String scope) {
            Xml.Tag t = this.tag.withChildValue("scope", scope);
            if (!t.getChild("scope").isPresent()) {
                ArrayList<Xml.Tag> content = new ArrayList<Xml.Tag>(t.getContent());
                content.add(new XmlParser().parseTag("<scope>" + scope + "</scope>").withFormatting(((Content)content.get(0)).getFormatting()));
                t = t.withContent(content);
            }
            return new Dependency(this.isManaged, this.model, t);
        }

        @JsonIgnore
        public Formatting getFormatting() {
            return this.tag.getFormatting();
        }

        public Dependency withFormatting(Formatting fmt) {
            return new Dependency(this.isManaged, this.model, this.tag.withFormatting(fmt));
        }

        @JsonIgnore
        public UUID getId() {
            return this.tag.getId();
        }

        @Override
        public <R> R acceptMaven(MavenSourceVisitor<R> v) {
            return v.visitDependency(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dependency that = (Dependency)o;
            return this.model.equals(that.model) && this.tag == that.tag;
        }

        public int hashCode() {
            return Objects.hash(this.model, this.tag);
        }

        public MavenModel.Dependency getModel() {
            return this.model;
        }

        public Dependency withModel(MavenModel.Dependency model) {
            return this.model == model ? this : new Dependency(this.isManaged, model, this.tag);
        }

        public Xml.Tag getTag() {
            return this.tag;
        }

        public Dependency withTag(Xml.Tag tag) {
            return this.tag == tag ? this : new Dependency(this.isManaged, this.model, tag);
        }
    }

    public static class Parent
    implements Maven {
        private final MavenModel model;
        @Nullable
        private final Xml.Tag tag;

        @ConstructorProperties(value={"model", "tag"})
        public Parent(MavenModel model, @Nullable Xml.Tag tag) {
            this.model = model;
            this.tag = tag;
        }

        @JsonIgnore
        @Nullable
        public String getGroupId() {
            return this.tag == null ? null : (String)this.tag.getChildValue("groupId").orElse(null);
        }

        public Parent withGroupId(String groupId) {
            return this.tag == null ? this : new Parent(this.model, this.tag.withChildValue("groupId", groupId));
        }

        @JsonIgnore
        @Nullable
        public String getArtifactId() {
            return this.tag == null ? null : (String)this.tag.getChildValue("artifactId").orElse(null);
        }

        public Parent withArtifactId(String artifactId) {
            return this.tag == null ? this : new Parent(this.model, this.tag.withChildValue("artifactId", artifactId));
        }

        @JsonIgnore
        @Nullable
        public String getVersion() {
            return this.tag == null ? null : (String)this.tag.getChildValue("version").orElse(null);
        }

        public Parent withVersion(String version) {
            return this.tag == null ? this : new Parent(this.model, this.tag.withChildValue("version", version));
        }

        @JsonIgnore
        public Formatting getFormatting() {
            return this.tag == null ? Formatting.EMPTY : this.tag.getFormatting();
        }

        @JsonIgnore
        public UUID getId() {
            return this.tag == null ? UUID.randomUUID() : this.tag.getId();
        }

        public Parent withFormatting(Formatting fmt) {
            return this.tag == null ? this : new Parent(this.model, this.tag.withFormatting(fmt));
        }

        @Override
        public <R> R acceptMaven(MavenSourceVisitor<R> v) {
            return v.visitParent(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parent parent = (Parent)o;
            return this.model.equals(parent.model) && this.tag == parent.tag;
        }

        public int hashCode() {
            return Objects.hash(this.model, this.tag);
        }

        public MavenModel getModel() {
            return this.model;
        }

        public Xml.Tag getTag() {
            return this.tag;
        }
    }

    @JsonIgnoreProperties(value={"styles"})
    public static class Pom
    implements Maven,
    SourceFile {
        private final MavenModel model;
        private final Xml.Document document;
        @Nullable
        @JsonIgnore
        private final DependencyManagement dependencyManagement;
        @JsonIgnore
        private final MemoizedTags<Dependency> memoizedDependencies;
        @JsonIgnore
        private final MemoizedTags<Property> memoizedProperties;

        @ConstructorProperties(value={"model", "document"})
        public Pom(MavenModel model, Xml.Document document) {
            this.model = model;
            this.document = document;
            this.dependencyManagement = document.getRoot().getChild("dependencyManagement").map(dm -> new DependencyManagement(model.getDependencyManagement(), (Xml.Tag)dm)).orElse(null);
            this.memoizedDependencies = new MemoizedTags<Dependency>(document.getRoot(), "dependencies/dependency", tag -> new Dependency(false, model.getDependencies().stream().filter(d -> d.getModuleVersion().getGroupId().equals(tag.getChildValue("groupId").orElse(null)) && d.getModuleVersion().getArtifactId().equals(tag.getChildValue("artifactId").orElse(null))).findAny().orElse(null), (Xml.Tag)tag), Dependency::getTag);
            this.memoizedProperties = new MemoizedTags<Property>(document.getRoot(), "properties/*", Property::new, Property::getTag);
        }

        public Xml.Document getDocument() {
            return this.document;
        }

        public Pom withDocument(Xml.Document document) {
            return new Pom(this.model, document);
        }

        public MavenModel getModel() {
            return this.model;
        }

        @JsonIgnore
        @Nullable
        public String getGroupId() {
            return this.document.getRoot().getChildValue("groupId").orElse(null);
        }

        public Pom withGroupId(String groupId) {
            return new Pom(this.model, this.document.withRoot(this.document.getRoot().withChildValue("groupId", groupId)));
        }

        @JsonIgnore
        @Nullable
        public String getArtifactId() {
            return this.document.getRoot().getChildValue("artifactId").orElse(null);
        }

        public Pom withArtifactId(String artifactId) {
            return new Pom(this.model, this.document.withRoot(this.document.getRoot().withChildValue("artifactId", artifactId)));
        }

        @JsonIgnore
        @Nullable
        public String getVersion() {
            return this.document.getRoot().getChildValue("version").orElse(null);
        }

        public Pom withVersion(String version) {
            return new Pom(this.model, this.document.withRoot(this.document.getRoot().withChildValue("version", version)));
        }

        @JsonIgnore
        @Nullable
        public Parent getParent() {
            return this.model.getParent() == null ? null : new Parent(this.model.getParent(), this.document.getRoot().getChild("parent").orElse(null));
        }

        public Pom withParent(Parent parent) {
            return this.document.getRoot().getChild("parent").map(parentTag -> new Pom(this.model.withParent(parent.getModel()), this.document.withRoot((Xml.Tag)new ChangeTagContent(parentTag, parent.getTag().getContent()).visit((Tree)this.document.getRoot())))).orElse(this);
        }

        @Nullable
        public DependencyManagement getDependencyManagement() {
            return this.dependencyManagement;
        }

        public Pom withDependencyManagement(DependencyManagement dependencyManagement) {
            return this.document.getRoot().getChild("dependencyManagement").map(dm -> new Pom(this.model.withDependencyManagement(dependencyManagement.getModel()), this.document.withRoot((Xml.Tag)new ChangeTagContent(dm, dependencyManagement.tag.getContent()).visit((Tree)this.document.getRoot())))).orElse(this);
        }

        @JsonIgnore
        public List<Dependency> getDependencies() {
            return this.memoizedDependencies.getModels();
        }

        public Pom withDependencies(List<Dependency> dependencies) {
            return this.memoizedDependencies.with(dependencies).map(root -> new Pom(this.model.withDependencies(dependencies.stream().map(Dependency::getModel).collect(Collectors.toList())), this.document.withRoot(root))).orElse(this);
        }

        @JsonIgnore
        public List<Property> getProperties() {
            return this.memoizedProperties.getModels();
        }

        public Pom withProperties(List<Property> properties) {
            return this.memoizedProperties.with(properties).map(root -> new Pom(this.model.withProperties(properties.stream().collect(Collectors.toMap(Property::getKey, Property::getValue))), this.document.withRoot(root))).orElse(this);
        }

        public Optional<Property> getPropertyFromValue(String maybePropertyReference) {
            return Maven.getPropertyKey(maybePropertyReference).flatMap(key -> this.getProperties().stream().filter(prop -> prop.getKey().equals(key)).findAny());
        }

        @JsonIgnore
        public String getSourcePath() {
            return this.document.getSourcePath();
        }

        public Pom withMetadata(Collection<Metadata> metadata) {
            return new Pom(this.model, this.document.withMetadata(metadata));
        }

        @JsonIgnore
        public Collection<Metadata> getMetadata() {
            return this.document.getMetadata();
        }

        @JsonIgnore
        public Formatting getFormatting() {
            return this.document.getFormatting();
        }

        public Pom withFormatting(Formatting fmt) {
            return new Pom(this.model, this.document.withFormatting(fmt));
        }

        @JsonIgnore
        public UUID getId() {
            return this.document.getId();
        }

        @Override
        public <R> R acceptMaven(MavenSourceVisitor<R> v) {
            return v.visitPom(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pom pom = (Pom)o;
            return this.model.equals(pom.model) && this.document.equals((Object)pom.document);
        }

        public int hashCode() {
            return Objects.hash(this.model, this.document);
        }
    }
}

