/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.aether.repository.RemoteRepository;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenModuleLoader;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.xml.XmlParser;

public class MavenParser {
    private final XmlParser xmlParser = new XmlParser();
    private final boolean resolveDependencies;
    private final File localRepository;
    private final List<RemoteRepository> remoteRepositories;

    private MavenParser(boolean resolveDependencies, File localRepository, List<RemoteRepository> remoteRepositories) {
        this.resolveDependencies = resolveDependencies;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Maven.Pom> parse(List<Path> sourceFiles, @Nullable Path relativeTo) {
        Map<Path, MavenModel> modules = new MavenModuleLoader(this.resolveDependencies, this.localRepository, this.remoteRepositories).load(sourceFiles);
        return sourceFiles.stream().map(sourceFile -> new Maven.Pom((MavenModel)modules.get(sourceFile), this.xmlParser.parse(sourceFile, relativeTo))).collect(Collectors.toList());
    }

    public Maven.Pom parse(Path sourceFile, @Nullable Path relativeTo) {
        return this.parse(Collections.singletonList(sourceFile), relativeTo).get(0);
    }

    public static class Builder {
        private boolean resolveDependencies = true;
        private File localRepository = new File(System.getProperty("user.home") + "/.m2");
        private List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();

        public Builder() {
            this.remoteRepositories.add(new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build());
        }

        public Builder localRepository(File localRepository) {
            this.localRepository = localRepository;
            return this;
        }

        public Builder resolveDependencies(boolean resolveDependencies) {
            this.resolveDependencies = resolveDependencies;
            return this;
        }

        public void remoteRepositories(List<RemoteRepository> remoteRepositories) {
            this.remoteRepositories = remoteRepositories;
        }

        public void addRemoteRepository(RemoteRepository remoteRepository) {
            this.remoteRepositories.add(remoteRepository);
        }

        public MavenParser build() {
            return new MavenParser(this.resolveDependencies, this.localRepository, this.remoteRepositories);
        }
    }
}

