/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.style;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.openrewrite.kotlin.style.ImportLayoutStyle;

class Deserializer
extends JsonDeserializer<ImportLayoutStyle> {
    Deserializer() {
    }

    public ImportLayoutStyle deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ImportLayoutStyle.Builder builder = ImportLayoutStyle.builder();
        String currentField = null;
        while (p.hasCurrentToken() && p.getCurrentToken() != JsonToken.END_OBJECT) {
            switch (p.currentToken()) {
                case FIELD_NAME: {
                    currentField = p.getCurrentName();
                    break;
                }
                case VALUE_STRING: {
                    boolean withSubpackages;
                    String block;
                    if ("layout".equals(currentField)) {
                        block = p.getText().trim();
                        if ("<blank line>".equals(block)) {
                            builder.blankLine();
                            break;
                        }
                        if (block.startsWith("import ")) {
                            if ("all other imports".equals(block = block.substring("import ".length()))) {
                                builder.importAllOthers();
                                break;
                            }
                            withSubpackages = !block.contains(" without subpackages");
                            block = withSubpackages ? block : block.substring(0, block.indexOf(" without subpackage"));
                            builder.importPackage(block, withSubpackages);
                            break;
                        }
                        throw new IllegalArgumentException("Syntax error in layout block [" + block + "]");
                    }
                    if (!"packagesToFold".equals(currentField) || !(block = p.getText().trim()).startsWith("import ")) break;
                    withSubpackages = !(block = block.substring("import ".length())).contains(" without subpackages");
                    block = withSubpackages ? block : block.substring(0, block.indexOf(" without subpackage"));
                    builder.packageToFold(block, withSubpackages);
                    break;
                }
                case VALUE_NUMBER_INT: {
                    if ("topLevelSymbolsToUseStarImport".equals(currentField)) {
                        builder.topLevelSymbolsToUseStarImport(p.getValueAsInt());
                        break;
                    }
                    if (!"javaStaticsAndEnumsToUseStarImport".equals(currentField)) break;
                    builder.javaStaticsAndEnumsToUseStarImport(p.getValueAsInt());
                }
            }
            p.nextToken();
        }
        return builder.build();
    }
}

