/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.Collections;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KSpace;
import org.openrewrite.marker.Markers;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.UncheckedConsumer;
import org.opentest4j.AssertionFailedError;

public final class Assertions {
    private Assertions() {
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
        if (ctx.getMessage("org.openrewrite.kotlin.skipSourceSetTypeGeneration") == null) {
            ctx.putMessage("org.openrewrite.kotlin.skipSourceSetTypeGeneration", (Object)true);
        }
    }

    @Nullable
    private static String adjustSpaces(@Nullable String input) {
        if (input == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        int count = 0;
        int limit = 1;
        char pre = '\u0000';
        for (char c : input.toCharArray()) {
            if (c == ' ') {
                if (pre == ' ') {
                    if (++count <= limit) {
                        out.append(c);
                    }
                } else {
                    ++count;
                    out.append(c);
                }
            } else {
                if (pre == ' ') {
                    for (int i = count; i < limit; ++i) {
                        out.append(' ');
                    }
                    count = 0;
                    if (++limit > 5) {
                        limit = 1;
                    }
                }
                out.append(c);
            }
            pre = c;
        }
        return out.toString();
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before) {
        return Assertions.kotlin(before, (SourceSpec<K.CompilationUnit> s) -> {});
    }

    public static SourceSpecs kotlinScript(@Nullable @Language(value="kts") String before) {
        return Assertions.kotlinScript(before, s -> {});
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before, Consumer<SourceSpec<K.CompilationUnit>> spec) {
        SourceSpec kotlin = new SourceSpec(K.CompilationUnit.class, null, (Parser.Builder)KotlinParser.builder(), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext);
        Assertions.acceptSpec(spec, (SourceSpec<K.CompilationUnit>)kotlin);
        return kotlin;
    }

    public static SourceSpecs kotlinScript(@Nullable @Language(value="kts") String before, Consumer<SourceSpec<K.CompilationUnit>> spec) {
        SourceSpec kotlinScript = new SourceSpec(K.CompilationUnit.class, null, (Parser.Builder)KotlinParser.builder().isKotlinScript(true), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext);
        Assertions.acceptSpec(spec, (SourceSpec<K.CompilationUnit>)kotlinScript);
        return kotlinScript;
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before, @Language(value="kotlin") String after) {
        return Assertions.kotlin(before, after, s -> {});
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before, @Language(value="kotlin") String after, Consumer<SourceSpec<K.CompilationUnit>> spec) {
        SourceSpec kotlin = new SourceSpec(K.CompilationUnit.class, null, (Parser.Builder)KotlinParser.builder(), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext).after(s -> after);
        Assertions.acceptSpec(spec, (SourceSpec<K.CompilationUnit>)kotlin);
        return kotlin;
    }

    public static SourceSpecs srcMainKotlin(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... kotlinSources) {
        return SourceSpecs.dir((String)"src/main/kotlin", spec, (SourceSpecs[])kotlinSources);
    }

    public static SourceSpecs srcMainKotlin(SourceSpecs ... kotlinSources) {
        return Assertions.srcMainKotlin((SourceSpec<SourceFile> spec) -> org.openrewrite.java.Assertions.sourceSet((SourceSpec)spec, (String)"main"), kotlinSources);
    }

    public static SourceSpecs srcTestKotlin(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... kotlinSources) {
        return SourceSpecs.dir((String)"src/test/kotlin", spec, (SourceSpecs[])kotlinSources);
    }

    public static SourceSpecs srcTestKotlin(SourceSpecs ... kotlinSources) {
        return Assertions.srcTestKotlin((SourceSpec<SourceFile> spec) -> org.openrewrite.java.Assertions.sourceSet((SourceSpec)spec, (String)"test"), kotlinSources);
    }

    private static void acceptSpec(Consumer<SourceSpec<K.CompilationUnit>> spec, SourceSpec<K.CompilationUnit> kotlin) {
        Consumer consumer = kotlin.getAfterRecipe().andThen(Assertions.isFullyParsed());
        kotlin.afterRecipe(consumer::accept);
        spec.accept(kotlin);
    }

    public static ThrowingConsumer<K.CompilationUnit> isFullyParsed() {
        return cu -> new KotlinIsoVisitor<Integer>(){

            public J visitUnknown(J.Unknown unknown, Integer integer) {
                throw new AssertionFailedError("Parsing error, J.Unknown detected");
            }

            public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                if (!space.getWhitespace().trim().isEmpty()) {
                    throw new AssertionFailedError("Parsing error detected, whitespace contains non-whitespace characters: " + space.getWhitespace());
                }
                return super.visitSpace(space, loc, (Object)integer);
            }
        }.visit((Tree)cu, 0);
    }

    public static UncheckedConsumer<SourceSpec<?>> spaceConscious() {
        return source -> {
            if (source.getSourceFileType() == K.CompilationUnit.class) {
                SourceSpec kotlinSourceSpec = source;
                kotlinSourceSpec.afterRecipe(Assertions.spaceConscious((SourceSpec<K.CompilationUnit>)kotlinSourceSpec));
            }
        };
    }

    public static ThrowingConsumer<K.CompilationUnit> spaceConscious(SourceSpec<K.CompilationUnit> spec) {
        return cu -> {
            K.CompilationUnit visited = (K.CompilationUnit)new KotlinIsoVisitor<Integer>(){
                int id = 0;

                @Override
                public Space visitSpace(Space space, KSpace.Location loc, Integer integer) {
                    return this.next(space);
                }

                @NotNull
                private Space next(Space space) {
                    if (!space.getComments().isEmpty()) {
                        return space;
                    }
                    return space.withComments(Collections.singletonList(new TextComment(true, Integer.toString(this.id++), "", Markers.EMPTY)));
                }

                public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                    Cursor parentCursor = this.getCursor().getParentOrThrow();
                    if (loc == Space.Location.IDENTIFIER_PREFIX && parentCursor.getValue() instanceof J.Annotation) {
                        return space;
                    }
                    if (loc == Space.Location.IDENTIFIER_PREFIX && parentCursor.getValue() instanceof J.Break && ((J.Break)parentCursor.getValue()).getLabel() == this.getCursor().getValue()) {
                        return space;
                    }
                    if (loc == Space.Location.IDENTIFIER_PREFIX && parentCursor.getValue() instanceof K.KReturn && ((K.KReturn)parentCursor.getValue()).getLabel() == this.getCursor().getValue()) {
                        return space;
                    }
                    if (loc == Space.Location.LABEL_SUFFIX) {
                        return space;
                    }
                    if (this.getCursor().firstEnclosing(J.Import.class) != null) {
                        return space;
                    }
                    if (this.getCursor().firstEnclosing(J.Package.class) != null) {
                        return space;
                    }
                    return this.next(space);
                }
            }.visit((Tree)cu, 0);
            try {
                String s = visited.printAll();
                InMemoryExecutionContext ctx = new InMemoryExecutionContext();
                ctx.putMessage("org.openrewrite.requirePrintEqualsInput", (Object)false);
                SourceFile cu2 = (SourceFile)spec.getParser().build().parse((ExecutionContext)ctx, new String[]{s}).findFirst().get();
                String s1 = cu2.printAll();
                org.junit.jupiter.api.Assertions.assertEquals((Object)s, (Object)s1, (String)"Parser is not whitespace print idempotent");
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.fail((Throwable)e);
            }
        };
    }
}

