/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.Objects;
import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.format.BlankLinesVisitor;
import org.openrewrite.kotlin.format.MinimumViableSpacingVisitor;
import org.openrewrite.kotlin.format.NormalizeFormatVisitor;
import org.openrewrite.kotlin.format.NormalizeLineBreaksVisitor;
import org.openrewrite.kotlin.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.kotlin.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.kotlin.format.SpacesVisitor;
import org.openrewrite.kotlin.format.TabsAndIndentsVisitor;
import org.openrewrite.kotlin.format.WrappingAndBracesVisitor;
import org.openrewrite.kotlin.style.BlankLinesStyle;
import org.openrewrite.kotlin.style.IntelliJ;
import org.openrewrite.kotlin.style.SpacesStyle;
import org.openrewrite.kotlin.style.TabsAndIndentsStyle;
import org.openrewrite.kotlin.style.WrappingAndBracesStyle;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.style.GeneralFormatStyle;

public class AutoFormatVisitor<P>
extends KotlinIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;

    public AutoFormatVisitor() {
        this(null);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    @Override
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof K.CompilationUnit;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        JavaSourceFile cu = tree instanceof JavaSourceFile ? (JavaSourceFile)tree : (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        J t = (J)new NormalizeFormatVisitor(this.stopAfter).visit(tree, p, cursor.fork());
        t = (J)new MinimumViableSpacingVisitor(this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new BlankLinesVisitor(Optional.ofNullable((BlankLinesStyle)((SourceFile)cu).getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines()), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new WrappingAndBracesVisitor(Optional.ofNullable((WrappingAndBracesStyle)((SourceFile)cu).getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces()), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new SpacesVisitor(Optional.ofNullable((SpacesStyle)((SourceFile)cu).getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces()), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new NormalizeTabsOrSpacesVisitor(Optional.ofNullable((TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = new TabsAndIndentsVisitor<P>(Optional.ofNullable((TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new NormalizeLineBreaksVisitor(Optional.ofNullable((GeneralFormatStyle)((SourceFile)cu).getStyle(GeneralFormatStyle.class)).orElse(new GeneralFormatStyle(false)), this.stopAfter).visit((Tree)t, p, cursor.fork());
        t = (J)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visit((Tree)t, p, cursor.fork());
        return t;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            if (!(cu instanceof J.CompilationUnit)) {
                return cu;
            }
            JavaSourceFile t = (JavaSourceFile)new RemoveTrailingWhitespaceVisitor<P>(this.stopAfter).visit((Tree)cu, p);
            t = (JavaSourceFile)new BlankLinesVisitor<P>(Optional.ofNullable((BlankLinesStyle)((SourceFile)cu).getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines()), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new SpacesVisitor<P>(Optional.ofNullable((SpacesStyle)((SourceFile)cu).getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces()), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new WrappingAndBracesVisitor<P>(Optional.ofNullable((WrappingAndBracesStyle)((SourceFile)cu).getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces()), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new NormalizeTabsOrSpacesVisitor<P>(Optional.ofNullable((TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit((Tree)t, p);
            t = (JavaSourceFile)new TabsAndIndentsVisitor<P>(Optional.ofNullable((TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit((Tree)t, p);
            assert (t != null);
            return t;
        }
        return (J)tree;
    }
}

