/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethod;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeMapping;
import org.openrewrite.java.internal.JavaReflectionTypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinTypeSignatureBuilder;

@Incubating(since="0.0")
public class KotlinTypeMapping
implements JavaTypeMapping<Object> {
    private final KotlinTypeSignatureBuilder signatureBuilder;
    private final JavaTypeCache typeCache;
    private final FirSession firSession;
    private final JavaReflectionTypeMapping reflectionTypeMapping;

    public KotlinTypeMapping(JavaTypeCache typeCache, FirSession firSession) {
        this.signatureBuilder = new KotlinTypeSignatureBuilder(firSession);
        this.typeCache = typeCache;
        this.firSession = firSession;
        this.reflectionTypeMapping = new JavaReflectionTypeMapping(typeCache);
    }

    public JavaType type(@Nullable Object type) {
        return this.type(type, null);
    }

    public JavaType type(@Nullable Object type, @Nullable FirBasedSymbol<?> ownerFallBack) {
        if (type == null || type instanceof FirUserTypeRef) {
            return JavaType.Unknown.getInstance();
        }
        String signature = this.signatureBuilder.signature(type, ownerFallBack);
        JavaType existing = (JavaType)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        if (type instanceof String) {
            JavaType.ShallowClass javaType = JavaType.ShallowClass.build((String)((String)type));
            this.typeCache.put(signature, (Object)javaType);
            return javaType;
        }
        if (type instanceof FirClass) {
            return this.classType(type, signature, ownerFallBack);
        }
        if (type instanceof FirFunction) {
            return this.methodDeclarationType((FirFunction)type, null, ownerFallBack);
        }
        if (type instanceof FirVariable) {
            return this.variableType((FirVariableSymbol<? extends FirVariable>)((FirVariable)type).getSymbol(), null, ownerFallBack);
        }
        if (type instanceof FirFile) {
            return JavaType.ShallowClass.build((String)((FirFile)type).getName());
        }
        return this.resolveType(type, signature, ownerFallBack);
    }

    @Nullable
    private JavaType resolveType(Object type, String signature, @Nullable FirBasedSymbol<?> ownerFallBack) {
        if (type instanceof ConeTypeProjection) {
            return this.resolveConeTypeProjection((ConeTypeProjection)type, signature, ownerFallBack);
        }
        if (type instanceof FirExpression) {
            return this.type(((FirExpression)type).getTypeRef(), ownerFallBack);
        }
        if (type instanceof FirFunctionTypeRef) {
            return this.type(((FirFunctionTypeRef)type).getReturnTypeRef(), ownerFallBack);
        }
        if (type instanceof FirJavaTypeRef) {
            return JavaType.Unknown.getInstance();
        }
        if (type instanceof FirResolvedNamedReference) {
            FirBasedSymbol resolvedSymbol = ((FirResolvedNamedReference)type).getResolvedSymbol();
            if (resolvedSymbol instanceof FirConstructorSymbol) {
                return this.type(((FirConstructorSymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirEnumEntrySymbol) {
                return this.type(((FirEnumEntrySymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirNamedFunctionSymbol) {
                return this.type(((FirNamedFunctionSymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirPropertySymbol) {
                return this.type(((FirPropertySymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirValueParameterSymbol) {
                return this.type(((FirValueParameterSymbol)resolvedSymbol).getResolvedReturnType(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirFieldSymbol) {
                return this.type(((FirFieldSymbol)resolvedSymbol).getResolvedReturnType(), ownerFallBack);
            }
        } else {
            if (type instanceof FirResolvedTypeRef) {
                FirClassifierSymbol classifierSymbol;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)((FirResolvedTypeRef)type));
                if (coneKotlinType instanceof ConeTypeParameterType && (classifierSymbol = LookupTagUtilsKt.toSymbol((ConeClassifierLookupTag)((ConeTypeParameterType)coneKotlinType).getLookupTag(), (FirSession)this.firSession)) != null && classifierSymbol.getFir() instanceof FirTypeParameter) {
                    return this.resolveConeTypeProjection((FirTypeParameter)classifierSymbol.getFir(), signature);
                }
                return this.classType(type, signature, ownerFallBack);
            }
            if (type instanceof FirTypeParameter) {
                return this.resolveConeTypeProjection((FirTypeParameter)type, signature);
            }
            if (type instanceof FirVariableAssignment) {
                return this.type(((FirVariableAssignment)type).getCalleeReference(), ownerFallBack);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private JavaType.FullyQualified classType(Object classType, String signature, @Nullable FirBasedSymbol<?> ownerFallBack) {
        FirClass firClass;
        FirResolvedTypeRef resolvedTypeRef = null;
        if (classType instanceof FirResolvedTypeRef) {
            resolvedTypeRef = (FirResolvedTypeRef)classType;
            FirRegularClassSymbol symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)resolvedTypeRef.getType(), (FirSession)this.firSession);
            if (symbol == null) {
                this.typeCache.put(signature, (Object)JavaType.Unknown.getInstance());
                return JavaType.Unknown.getInstance();
            }
            firClass = (FirClass)symbol.getFir();
        } else {
            firClass = (FirClass)classType;
        }
        FirClassSymbol sym = firClass.getSymbol();
        String classFqn = KotlinTypeSignatureBuilder.convertClassIdToFqn(sym.getClassId());
        JavaType.FullyQualified fq = (JavaType.FullyQualified)this.typeCache.get(classFqn);
        if (fq instanceof JavaType.Unknown) {
            return fq;
        }
        JavaType.Class clazz = (JavaType.Class)(fq instanceof JavaType.Parameterized ? ((JavaType.Parameterized)fq).getType() : fq);
        if (clazz == null) {
            void var20_31;
            FirClassLikeSymbol ownerSymbol;
            clazz = new JavaType.Class(null, this.convertToFlagsBitMap(firClass.getStatus()), classFqn, this.convertToClassKind(firClass.getClassKind()), null, null, null, null, null, null, null);
            this.typeCache.put(classFqn, (Object)clazz);
            FirTypeRef superTypeRef = null;
            ArrayList<FirTypeRef> interfaceTypeRefs = null;
            for (FirTypeRef typeRef : firClass.getSuperTypeRefs()) {
                FirRegularClassSymbol symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)typeRef), (FirSession)this.firSession);
                if (symbol != null && ClassKind.CLASS == ((FirRegularClass)symbol.getFir()).getClassKind()) {
                    superTypeRef = typeRef;
                    continue;
                }
                if (symbol == null || ClassKind.INTERFACE != ((FirRegularClass)symbol.getFir()).getClassKind()) continue;
                if (interfaceTypeRefs == null) {
                    interfaceTypeRefs = new ArrayList<FirTypeRef>();
                }
                interfaceTypeRefs.add(typeRef);
            }
            JavaType.FullyQualified supertype = superTypeRef == null ? null : TypeUtils.asFullyQualified((JavaType)this.type(superTypeRef));
            JavaType.FullyQualified owner = null;
            if (firClass.getSymbol().getClassId().getOuterClassId() != null && (ownerSymbol = FirSymbolProviderKt.getSymbolProvider((FirSession)this.firSession).getClassLikeSymbolByClassId(firClass.getSymbol().getClassId().getOuterClassId())) != null) {
                owner = TypeUtils.asFullyQualified((JavaType)this.type(ownerSymbol.getFir()));
            }
            ArrayList<FirProperty> properties = new ArrayList<FirProperty>(firClass.getDeclarations().size());
            ArrayList<FirJavaField> javaFields = new ArrayList<FirJavaField>(firClass.getDeclarations().size());
            ArrayList<FirFunction> functions = new ArrayList<FirFunction>(firClass.getDeclarations().size());
            ArrayList<FirEnumEntry> enumEntries = new ArrayList<FirEnumEntry>(firClass.getDeclarations().size());
            for (Object declaration : firClass.getDeclarations()) {
                if (declaration instanceof FirProperty) {
                    if (declaration.getSource() != null && declaration.getSource().getKind() instanceof KtFakeSourceElementKind) continue;
                    properties.add((FirProperty)declaration);
                    continue;
                }
                if (declaration instanceof FirJavaField) {
                    javaFields.add((FirJavaField)declaration);
                    continue;
                }
                if (declaration instanceof FirSimpleFunction) {
                    functions.add((FirFunction)declaration);
                    continue;
                }
                if (declaration instanceof FirConstructor) {
                    functions.add((FirFunction)declaration);
                    continue;
                }
                if (declaration instanceof FirRegularClass || !(declaration instanceof FirEnumEntry)) continue;
                enumEntries.add((FirEnumEntry)declaration);
            }
            ArrayList<JavaType.Variable> fields = null;
            if (!enumEntries.isEmpty()) {
                fields = new ArrayList<JavaType.Variable>(properties.size() + enumEntries.size());
                for (FirEnumEntry firEnumEntry : enumEntries) {
                    fields.add(this.variableType((FirVariableSymbol<? extends FirVariable>)firEnumEntry.getSymbol(), (JavaType.FullyQualified)clazz, ownerFallBack));
                }
            }
            if (!properties.isEmpty()) {
                if (fields == null) {
                    fields = new ArrayList(properties.size());
                }
                for (FirProperty firProperty : properties) {
                    fields.add(this.variableType((FirVariableSymbol<? extends FirVariable>)firProperty.getSymbol(), (JavaType.FullyQualified)clazz, ownerFallBack));
                }
            }
            if (!javaFields.isEmpty()) {
                if (fields == null) {
                    fields = new ArrayList(javaFields.size());
                }
                for (FirJavaField firJavaField : javaFields) {
                    fields.add(this.variableType((FirVariableSymbol<? extends FirVariable>)firJavaField.getSymbol(), (JavaType.FullyQualified)clazz, ownerFallBack));
                }
            }
            ArrayList<JavaType.Method> methods = null;
            if (!functions.isEmpty()) {
                methods = new ArrayList<JavaType.Method>(functions.size());
                for (FirFunction firFunction : functions) {
                    methods.add(this.methodDeclarationType(firFunction, (JavaType.FullyQualified)clazz, ownerFallBack));
                }
            }
            Object var20_29 = null;
            if (interfaceTypeRefs != null && !interfaceTypeRefs.isEmpty()) {
                ArrayList<JavaType.FullyQualified> arrayList = new ArrayList<JavaType.FullyQualified>(interfaceTypeRefs.size());
                for (FirTypeRef iParam : interfaceTypeRefs) {
                    JavaType.FullyQualified javaType = TypeUtils.asFullyQualified((JavaType)this.type(iParam));
                    if (javaType == null) continue;
                    arrayList.add(javaType);
                }
            }
            List<JavaType.FullyQualified> list = this.listAnnotations(firClass.getAnnotations());
            clazz.unsafeSet(null, supertype, owner, list, (List)var20_31, fields, methods);
        }
        if (!firClass.getTypeParameters().isEmpty()) {
            JavaType.Parameterized pt = (JavaType.Parameterized)this.typeCache.get(signature);
            if (pt == null) {
                pt = new JavaType.Parameterized(null, null, null);
                this.typeCache.put(signature, (Object)pt);
                ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(firClass.getTypeParameters().size());
                if (resolvedTypeRef != null && resolvedTypeRef.getType().getTypeArguments().length > 0) {
                    for (ConeTypeProjection typeArgument : resolvedTypeRef.getType().getTypeArguments()) {
                        typeParameters.add(this.type(typeArgument));
                    }
                } else {
                    for (FirTypeParameterRef tParam : firClass.getTypeParameters()) {
                        typeParameters.add(this.type(tParam));
                    }
                }
                pt.unsafeSet((JavaType.FullyQualified)clazz, typeParameters);
            }
            return pt;
        }
        return clazz;
    }

    @Nullable
    public JavaType.Method methodDeclarationType(@Nullable FirFunction function, @Nullable JavaType.FullyQualified declaringType, @Nullable FirBasedSymbol<?> ownerFallBack) {
        FirFunctionSymbol methodSymbol;
        FirFunctionSymbol firFunctionSymbol = methodSymbol = function == null ? null : function.getSymbol();
        if (methodSymbol != null) {
            String signature = this.signatureBuilder.methodDeclarationSignature((FirFunctionSymbol<? extends FirFunction>)function.getSymbol());
            JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
            if (existing != null) {
                return existing;
            }
            ArrayList<String> paramNames = null;
            if (!methodSymbol.getValueParameterSymbols().isEmpty()) {
                paramNames = new ArrayList<String>(methodSymbol.getValueParameterSymbols().size());
                for (FirValueParameterSymbol p : methodSymbol.getValueParameterSymbols()) {
                    String s = p.getName().asString();
                    paramNames.add(s);
                }
            }
            List defaultValues = null;
            JavaType.Method method = new JavaType.Method(null, this.convertToFlagsBitMap((FirDeclarationStatus)methodSymbol.getResolvedStatus()), null, methodSymbol instanceof FirConstructorSymbol ? "<constructor>" : methodSymbol.getName().asString(), null, paramNames, null, null, null, defaultValues);
            this.typeCache.put(signature, (Object)method);
            List exceptionTypes = null;
            JavaType.FullyQualified resolvedDeclaringType = declaringType;
            if (declaringType == null) {
                if (methodSymbol instanceof FirConstructorSymbol) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(methodSymbol.getResolvedReturnType()));
                } else if (methodSymbol.getDispatchReceiverType() != null) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(methodSymbol.getDispatchReceiverType()));
                } else if (ownerFallBack != null) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(ownerFallBack.getFir()));
                }
            }
            if (resolvedDeclaringType == null) {
                return null;
            }
            JavaType returnType = function instanceof FirJavaMethod ? this.type(((FirFunction)methodSymbol.getFir()).getDispatchReceiverType()) : this.type(methodSymbol.getResolvedReturnTypeRef());
            ArrayList<JavaType> parameterTypes = null;
            if (!methodSymbol.getValueParameterSymbols().isEmpty()) {
                parameterTypes = new ArrayList<JavaType>(methodSymbol.getValueParameterSymbols().size());
                for (FirValueParameterSymbol parameterSymbol : methodSymbol.getValueParameterSymbols()) {
                    JavaType javaType = parameterSymbol.getFir() instanceof FirJavaValueParameter ? this.type(((FirValueParameter)parameterSymbol.getFir()).getReturnTypeRef()) : this.type(parameterSymbol.getResolvedReturnTypeRef());
                    parameterTypes.add(javaType);
                }
            }
            method.unsafeSet(resolvedDeclaringType, (JavaType)(methodSymbol instanceof FirConstructorSymbol ? resolvedDeclaringType : returnType), parameterTypes, exceptionTypes, this.listAnnotations(methodSymbol.getAnnotations()));
            return method;
        }
        return null;
    }

    @Nullable
    public JavaType.Method methodInvocationType(@Nullable FirFunctionCall functionCall, @Nullable FirBasedSymbol<?> ownerSymbol) {
        String s;
        if (functionCall == null || functionCall.getCalleeReference() instanceof FirErrorNamedReference) {
            return null;
        }
        String signature = this.signatureBuilder.methodSignature(functionCall, ownerSymbol);
        JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        FirBasedSymbol symbol = ((FirResolvedNamedReference)functionCall.getCalleeReference()).getResolvedSymbol();
        FirConstructor constructor = null;
        FirSimpleFunction simpleFunction = null;
        if (symbol instanceof FirConstructorSymbol) {
            constructor = (FirConstructor)symbol.getFir();
        } else {
            simpleFunction = (FirSimpleFunction)symbol.getFir();
        }
        ArrayList<String> paramNames = null;
        if (simpleFunction != null && !simpleFunction.getValueParameters().isEmpty()) {
            paramNames = new ArrayList<String>(simpleFunction.getValueParameters().size());
            for (FirValueParameter p : simpleFunction.getValueParameters()) {
                s = p.getName().asString();
                paramNames.add(s);
            }
        } else if (constructor != null && !constructor.getValueParameters().isEmpty()) {
            paramNames = new ArrayList(constructor.getValueParameters().size());
            for (FirValueParameter p : constructor.getValueParameters()) {
                s = p.getName().asString();
                paramNames.add(s);
            }
        }
        JavaType.Method method = new JavaType.Method(null, this.convertToFlagsBitMap(constructor != null ? constructor.getStatus() : simpleFunction.getStatus()), null, constructor != null ? "<constructor>" : simpleFunction.getName().asString(), null, paramNames, null, null, null, null);
        this.typeCache.put(signature, (Object)method);
        ArrayList<JavaType> parameterTypes = null;
        List exceptionTypes = null;
        if (constructor != null && !constructor.getValueParameters().isEmpty()) {
            parameterTypes = new ArrayList<JavaType>(constructor.getValueParameters().size());
            for (FirValueParameter argtype : constructor.getValueParameters()) {
                if (argtype == null) continue;
                JavaType javaType = this.type(argtype);
                parameterTypes.add(javaType);
            }
        }
        JavaType resolvedDeclaringType = null;
        if (functionCall.getCalleeReference() instanceof FirResolvedNamedReference && ((FirResolvedNamedReference)functionCall.getCalleeReference()).getResolvedSymbol() instanceof FirNamedFunctionSymbol) {
            FirNamedFunctionSymbol resolvedSymbol = (FirNamedFunctionSymbol)((FirResolvedNamedReference)functionCall.getCalleeReference()).getResolvedSymbol();
            if (ClassMembersKt.containingClass((FirCallableSymbol)resolvedSymbol) != null) {
                FirRegularClassSymbol classSymbol;
                ConeClassLikeLookupTag lookupTag = ClassMembersKt.containingClass((FirCallableSymbol)resolvedSymbol);
                if (lookupTag != null && (classSymbol = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)lookupTag, (FirSession)this.firSession)) != null) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(classSymbol.getFir()));
                }
            } else if (resolvedSymbol.getOrigin() == FirDeclarationOrigin.Library.INSTANCE) {
                if (((FirSimpleFunction)resolvedSymbol.getFir()).getContainerSource() instanceof JvmPackagePartSource) {
                    JvmPackagePartSource source = (JvmPackagePartSource)((FirSimpleFunction)resolvedSymbol.getFir()).getContainerSource();
                    resolvedDeclaringType = source.getFacadeClassName() != null ? TypeUtils.asFullyQualified((JavaType)this.type(KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq(source.getFacadeClassName().toString()))) : TypeUtils.asFullyQualified((JavaType)this.type(KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq(source.getClassName().toString())));
                }
            } else if (resolvedSymbol.getOrigin() == FirDeclarationOrigin.Source.INSTANCE && ownerSymbol != null) {
                if (ownerSymbol instanceof FirFileSymbol) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(((FirFileSymbol)ownerSymbol).getFir()));
                } else if (ownerSymbol instanceof FirNamedFunctionSymbol) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(((FirNamedFunctionSymbol)ownerSymbol).getFir()));
                } else if (ownerSymbol instanceof FirRegularClassSymbol) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(((FirRegularClassSymbol)ownerSymbol).getFir()));
                }
            }
        }
        if (resolvedDeclaringType == null) {
            return null;
        }
        JavaType returnType = this.type(functionCall.getTypeRef(), ownerSymbol);
        method.unsafeSet((JavaType.FullyQualified)resolvedDeclaringType, constructor != null ? resolvedDeclaringType : returnType, parameterTypes, exceptionTypes, this.listAnnotations(constructor != null ? constructor.getAnnotations() : simpleFunction.getAnnotations()));
        return method;
    }

    @Nullable
    public JavaType.Variable variableType(@Nullable FirVariableSymbol<? extends FirVariable> symbol, @Nullable JavaType.FullyQualified owner, @Nullable FirBasedSymbol<?> ownerFallBack) {
        if (symbol == null) {
            return null;
        }
        String signature = this.signatureBuilder.variableSignature(symbol, ownerFallBack);
        JavaType.Variable existing = (JavaType.Variable)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        JavaType.Variable variable = new JavaType.Variable(null, this.convertToFlagsBitMap(symbol.getRawStatus()), symbol.getName().asString(), null, null, null);
        this.typeCache.put(signature, (Object)variable);
        List<JavaType.FullyQualified> annotations = this.listAnnotations(symbol.getAnnotations());
        JavaType.FullyQualified resolvedOwner = owner;
        if (owner == null && ownerFallBack != null) {
            resolvedOwner = this.type(ownerFallBack.getFir());
        }
        if (resolvedOwner == null) {
            resolvedOwner = JavaType.Unknown.getInstance();
        }
        FirTypeRef typeRef = symbol.getFir() instanceof FirJavaField || symbol.getFir() instanceof FirEnumEntry ? ((FirVariable)symbol.getFir()).getReturnTypeRef() : symbol.getResolvedReturnTypeRef();
        variable.unsafeSet((JavaType)resolvedOwner, this.type(typeRef), annotations);
        return variable;
    }

    public JavaType.Primitive primitive(ConeClassLikeType type) {
        ClassId classId = type.getLookupTag().getClassId();
        if (StandardClassIds.INSTANCE.getByte().equals((Object)classId)) {
            return JavaType.Primitive.Byte;
        }
        if (StandardClassIds.INSTANCE.getBoolean().equals((Object)classId)) {
            return JavaType.Primitive.Boolean;
        }
        if (StandardClassIds.INSTANCE.getChar().equals((Object)classId)) {
            return JavaType.Primitive.Char;
        }
        if (StandardClassIds.INSTANCE.getDouble().equals((Object)classId)) {
            return JavaType.Primitive.Double;
        }
        if (StandardClassIds.INSTANCE.getFloat().equals((Object)classId)) {
            return JavaType.Primitive.Float;
        }
        if (StandardClassIds.INSTANCE.getInt().equals((Object)classId)) {
            return JavaType.Primitive.Int;
        }
        if (StandardClassIds.INSTANCE.getLong().equals((Object)classId)) {
            return JavaType.Primitive.Long;
        }
        if (StandardClassIds.INSTANCE.getShort().equals((Object)classId)) {
            return JavaType.Primitive.Short;
        }
        if (StandardClassIds.INSTANCE.getString().equals((Object)classId)) {
            return JavaType.Primitive.String;
        }
        if (StandardClassIds.INSTANCE.getUnit().equals((Object)classId)) {
            return JavaType.Primitive.Void;
        }
        if (StandardClassIds.INSTANCE.getNothing().equals((Object)classId)) {
            return JavaType.Primitive.Null;
        }
        throw new IllegalArgumentException("Unsupported primitive type " + type);
    }

    private JavaType resolveConeTypeProjection(ConeTypeProjection type, String signature, @Nullable FirBasedSymbol<?> ownerSymbol) {
        boolean isGeneric;
        JavaType.Unknown resolvedType = JavaType.Unknown.getInstance();
        boolean bl = isGeneric = type instanceof ConeKotlinTypeProjectionIn || type instanceof ConeKotlinTypeProjectionOut || type instanceof ConeStarProjection || type instanceof ConeTypeParameterType;
        if (isGeneric) {
            JavaType.GenericTypeVariable.Variance variance = JavaType.GenericTypeVariable.Variance.INVARIANT;
            ArrayList<JavaType.Unknown> bounds = null;
            String name = type instanceof ConeKotlinTypeProjectionIn || type instanceof ConeKotlinTypeProjectionOut ? "" : (type instanceof ConeStarProjection ? "*" : type.toString());
            JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, name, JavaType.GenericTypeVariable.Variance.INVARIANT, null);
            this.typeCache.put(signature, (Object)gtv);
            if (type instanceof ConeKotlinTypeProjectionIn) {
                ConeKotlinTypeProjectionIn in = (ConeKotlinTypeProjectionIn)type;
                variance = JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
                FirRegularClassSymbol classSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)in.getType(), (FirSession)this.firSession);
                bounds = new ArrayList<JavaType.Unknown>(1);
                bounds.add((JavaType.Unknown)(classSymbol != null ? this.type(classSymbol.getFir()) : JavaType.Unknown.getInstance()));
            } else if (type instanceof ConeKotlinTypeProjectionOut) {
                ConeKotlinTypeProjectionOut out = (ConeKotlinTypeProjectionOut)type;
                variance = JavaType.GenericTypeVariable.Variance.COVARIANT;
                FirRegularClassSymbol classSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)out.getType(), (FirSession)this.firSession);
                bounds = new ArrayList(1);
                bounds.add((JavaType.Unknown)(classSymbol != null ? this.type(classSymbol.getFir()) : JavaType.Unknown.getInstance()));
            }
            gtv.unsafeSet(name, variance, bounds);
            resolvedType = gtv;
        } else if (type instanceof ConeClassLikeType) {
            resolvedType = this.resolveConeLikeClassType((ConeClassLikeType)type, signature, ownerSymbol);
        } else if (type instanceof ConeFlexibleType) {
            resolvedType = this.type(((ConeFlexibleType)type).getLowerBound());
        }
        return resolvedType;
    }

    private JavaType resolveConeLikeClassType(ConeClassLikeType coneClassLikeType, String signature, @Nullable FirBasedSymbol<?> ownerSymbol) {
        FirRegularClassSymbol classSymbol = TypeUtilsKt.toRegularClassSymbol((ConeClassLikeType)coneClassLikeType, (FirSession)this.firSession);
        if (classSymbol == null) {
            this.typeCache.put(signature, (Object)JavaType.Unknown.getInstance());
            return JavaType.Unknown.getInstance();
        }
        return this.type(classSymbol.getFir(), ownerSymbol);
    }

    private JavaType resolveConeTypeProjection(FirTypeParameter typeParameter, String signature) {
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, typeParameter.getName().asString(), JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, (Object)gtv);
        ArrayList<JavaType> bounds = null;
        JavaType.GenericTypeVariable.Variance variance = JavaType.GenericTypeVariable.Variance.INVARIANT;
        if (typeParameter.getBounds().size() != 1 || !(typeParameter.getBounds().get(0) instanceof FirImplicitNullableAnyTypeRef)) {
            bounds = new ArrayList<JavaType>(typeParameter.getBounds().size());
            for (FirTypeRef bound : typeParameter.getBounds()) {
                bounds.add(this.type(bound));
            }
            if ("out".equals(typeParameter.getVariance().getLabel())) {
                variance = JavaType.GenericTypeVariable.Variance.COVARIANT;
            } else if ("in".equals(typeParameter.getVariance().getLabel())) {
                variance = JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
            }
        }
        gtv.unsafeSet(gtv.getName(), variance, bounds);
        return gtv;
    }

    private long convertToFlagsBitMap(FirDeclarationStatus status) {
        long bitMask = 0L;
        Visibility visibility = status.getVisibility();
        switch (visibility.getName()) {
            case "public": {
                ++bitMask;
                break;
            }
            case "private": {
                bitMask += 2L;
                break;
            }
            case "protected": {
                bitMask += 4L;
                break;
            }
            case "internal": {
                break;
            }
        }
        Modality modality = status.getModality();
        if (Modality.FINAL == modality) {
            bitMask += 16L;
        } else if (Modality.ABSTRACT == modality) {
            bitMask += 1024L;
        }
        if (status.isStatic()) {
            bitMask += 8L;
        }
        return bitMask;
    }

    private JavaType.FullyQualified.Kind convertToClassKind(ClassKind classKind) {
        JavaType.FullyQualified.Kind kind;
        if (ClassKind.CLASS == classKind) {
            kind = JavaType.FullyQualified.Kind.Class;
        } else if (ClassKind.ANNOTATION_CLASS == classKind) {
            kind = JavaType.FullyQualified.Kind.Annotation;
        } else if (ClassKind.ENUM_CLASS == classKind) {
            kind = JavaType.FullyQualified.Kind.Enum;
        } else if (ClassKind.INTERFACE == classKind) {
            kind = JavaType.FullyQualified.Kind.Interface;
        } else if (ClassKind.OBJECT == classKind) {
            kind = JavaType.FullyQualified.Kind.Class;
        } else {
            throw new IllegalArgumentException("Unsupported classKind: " + classKind.name());
        }
        return kind;
    }

    private List<JavaType.FullyQualified> listAnnotations(List<FirAnnotation> firAnnotations) {
        ArrayList<JavaType.FullyQualified> annotations = new ArrayList<JavaType.FullyQualified>(firAnnotations.size());
        block0: for (FirAnnotation firAnnotation : firAnnotations) {
            FirRegularClassSymbol symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)firAnnotation.getTypeRef()), (FirSession)this.firSession);
            if (symbol != null) {
                for (FirAnnotation annotation : symbol.getAnnotations()) {
                    if (!(annotation instanceof FirAnnotationCall) || ((FirAnnotationCall)annotation).getArgumentList().getArguments().isEmpty()) continue;
                    for (FirExpression argument : ((FirAnnotationCall)annotation).getArgumentList().getArguments()) {
                        FirEnumEntrySymbol enumEntrySymbol;
                        FirPropertyAccessExpression accessExpression;
                        FirBasedSymbol callRefSymbol;
                        if (!(argument instanceof FirPropertyAccessExpression) || !((callRefSymbol = ((FirResolvedNamedReference)(accessExpression = (FirPropertyAccessExpression)argument).getCalleeReference()).getResolvedSymbol()) instanceof FirEnumEntrySymbol) || !"kotlin.annotation.AnnotationRetention$SOURCE".equals(KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq((enumEntrySymbol = (FirEnumEntrySymbol)callRefSymbol).getCallableId().toString()))) continue;
                        continue block0;
                    }
                }
            }
            JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)this.type(firAnnotation.getTypeRef());
            annotations.add(fullyQualified);
        }
        return annotations;
    }
}

