/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.tree;

import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.internal.KotlinPrinter;
import org.openrewrite.marker.Markers;

public interface K
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptKotlin((KotlinVisitor)v.adapt(KotlinVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(KotlinVisitor.class);
    }

    @Nullable
    default public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
        return (J)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    public static final class WhenBranch
    implements K,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> expressions;
        private final JRightPadded<J> body;

        public List<Expression> getExpressions() {
            return this.expressions.getElements();
        }

        public WhenBranch withExpressions(List<Expression> expressions) {
            return this.getPadding().withExpressions((JContainer<Expression>)Objects.requireNonNull(JContainer.withElementsNullable(this.expressions, expressions)));
        }

        public J getBody() {
            return (J)this.body.getElement();
        }

        public WhenBranch withBody(J body) {
            return this.getPadding().withBody((JRightPadded<J>)JRightPadded.withElement(this.body, (Object)body));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitWhenBranch(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new JavaPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhenBranch)) {
                return false;
            }
            WhenBranch other = (WhenBranch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public WhenBranch(UUID id, Space prefix, Markers markers, JContainer<Expression> expressions, JRightPadded<J> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expressions = expressions;
            this.body = body;
        }

        private WhenBranch(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> expressions, JRightPadded<J> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expressions = expressions;
            this.body = body;
        }

        public WhenBranch withId(UUID id) {
            return this.id == id ? this : new WhenBranch(this.padding, id, this.prefix, this.markers, this.expressions, this.body);
        }

        public UUID getId() {
            return this.id;
        }

        public WhenBranch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WhenBranch(this.padding, this.id, prefix, this.markers, this.expressions, this.body);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public WhenBranch withMarkers(Markers markers) {
            return this.markers == markers ? this : new WhenBranch(this.padding, this.id, this.prefix, markers, this.expressions, this.body);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final WhenBranch t;

            @Nullable
            public JRightPadded<J> getBody() {
                return this.t.body;
            }

            public WhenBranch withBody(@Nullable JRightPadded<J> body) {
                return this.t.body == body ? this.t : new WhenBranch(this.t.id, this.t.prefix, this.t.markers, (JContainer<Expression>)this.t.expressions, body);
            }

            public JContainer<Expression> getExpressions() {
                return this.t.expressions;
            }

            public WhenBranch withExpressions(JContainer<Expression> expressions) {
                return this.t.expressions == expressions ? this.t : new WhenBranch(this.t.id, this.t.prefix, this.t.markers, expressions, (JRightPadded<J>)this.t.body);
            }

            public Padding(WhenBranch t) {
                this.t = t;
            }
        }
    }

    public static final class When
    implements K,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final J.ControlParentheses<Expression> selector;
        private final J.Block branches;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitWhen(this, p);
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public When withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            return new When(this.id, this.prefix, this.markers, this.selector, this.branches, this.type);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof When)) {
                return false;
            }
            When other = (When)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public When(UUID id, Space prefix, Markers markers, J.ControlParentheses<Expression> selector, J.Block branches, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.selector = selector;
            this.branches = branches;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public J.ControlParentheses<Expression> getSelector() {
            return this.selector;
        }

        public J.Block getBranches() {
            return this.branches;
        }

        public String toString() {
            return "K.When(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", selector=" + this.getSelector() + ", branches=" + this.getBranches() + ", type=" + this.getType() + ")";
        }

        public When withId(UUID id) {
            return this.id == id ? this : new When(id, this.prefix, this.markers, this.selector, this.branches, this.type);
        }

        public When withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new When(this.id, prefix, this.markers, this.selector, this.branches, this.type);
        }

        public When withMarkers(Markers markers) {
            return this.markers == markers ? this : new When(this.id, this.prefix, markers, this.selector, this.branches, this.type);
        }

        public When withSelector(J.ControlParentheses<Expression> selector) {
            return this.selector == selector ? this : new When(this.id, this.prefix, this.markers, selector, this.branches, this.type);
        }

        public When withBranches(J.Block branches) {
            return this.branches == branches ? this : new When(this.id, this.prefix, this.markers, this.selector, branches, this.type);
        }
    }

    public static final class StatementExpression
    implements K,
    Expression,
    Statement {
        private final UUID id;
        private final Statement statement;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getStatement(), p);
            if (j instanceof StatementExpression) {
                return j;
            }
            if (j instanceof Statement) {
                return this.withStatement((Statement)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withStatement((Statement)this.statement.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.statement.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withStatement((Statement)this.statement.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.statement.getMarkers();
        }

        @Nullable
        public JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            throw new UnsupportedOperationException("StatementExpression cannot have a type");
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public String toString() {
            return "K.StatementExpression(id=" + this.getId() + ", statement=" + this.getStatement() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof StatementExpression;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public StatementExpression(UUID id, Statement statement) {
            this.id = id;
            this.statement = statement;
        }

        public StatementExpression withId(UUID id) {
            return this.id == id ? this : new StatementExpression(id, this.statement);
        }

        public UUID getId() {
            return this.id;
        }

        public StatementExpression withStatement(Statement statement) {
            return this.statement == statement ? this : new StatementExpression(this.id, statement);
        }

        public Statement getStatement() {
            return this.statement;
        }
    }

    public static final class Modifier
    implements K {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type type;
        private final List<J.Annotation> annotations;

        public static boolean hasModifier(Collection<Modifier> modifiers, Type modifier) {
            return modifiers.stream().anyMatch(m -> m.getType() == modifier);
        }

        public String toString() {
            return this.type.toString().toLowerCase();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Modifier)) {
                return false;
            }
            Modifier other = (Modifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Modifier(UUID id, Space prefix, Markers markers, Type type, List<J.Annotation> annotations) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.annotations = annotations;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Type getType() {
            return this.type;
        }

        public Modifier withId(UUID id) {
            return this.id == id ? this : new Modifier(id, this.prefix, this.markers, this.type, this.annotations);
        }

        public Modifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Modifier(this.id, prefix, this.markers, this.type, this.annotations);
        }

        public Modifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Modifier(this.id, this.prefix, markers, this.type, this.annotations);
        }

        public Modifier withType(Type type) {
            return this.type == type ? this : new Modifier(this.id, this.prefix, this.markers, type, this.annotations);
        }

        public Modifier withAnnotations(List<J.Annotation> annotations) {
            return this.annotations == annotations ? this : new Modifier(this.id, this.prefix, this.markers, this.type, annotations);
        }

        public List<J.Annotation> getAnnotations() {
            return this.annotations;
        }

        public static enum Type {
            Public,
            Protected,
            Private,
            Internal,
            Expect,
            Actual,
            Final,
            Open,
            Abstract,
            Sealed,
            Const,
            External,
            Override,
            LateInit,
            TailRec,
            Vararg,
            Suspend,
            Inner,
            Enum,
            Annotation,
            Fun,
            Companion,
            Inline,
            NoInline,
            CrossInline,
            Value,
            Infix,
            Operator,
            Data;

        }
    }

    public static final class ListLiteral
    implements K,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> elements;
        @Nullable
        private final JavaType type;

        public List<Expression> getElements() {
            return this.elements.getElements();
        }

        public ListLiteral withElements(List<Expression> elements) {
            return this.getPadding().withElements((JContainer<Expression>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitListLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListLiteral)) {
                return false;
            }
            ListLiteral other = (ListLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ListLiteral(UUID id, Space prefix, Markers markers, JContainer<Expression> elements, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        private ListLiteral(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> elements, JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        public ListLiteral withId(UUID id) {
            return this.id == id ? this : new ListLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public ListLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ListLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ListLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new ListLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        public JavaType getType() {
            return this.type;
        }

        public ListLiteral withType(JavaType type) {
            return this.type == type ? this : new ListLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final ListLiteral t;

            public JContainer<Expression> getElements() {
                return this.t.elements;
            }

            public ListLiteral withElements(JContainer<Expression> elements) {
                return this.t.elements == elements ? this.t : new ListLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            public Padding(ListLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class KString
    implements K,
    Statement,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String delimiter;
        private final List<J> strings;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitKString(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof KString;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public KString(UUID id, Space prefix, Markers markers, String delimiter, List<J> strings, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.delimiter = delimiter;
            this.strings = strings;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public List<J> getStrings() {
            return this.strings;
        }

        public JavaType getType() {
            return this.type;
        }

        public String toString() {
            return "K.KString(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", delimiter=" + this.getDelimiter() + ", strings=" + this.getStrings() + ", type=" + this.getType() + ")";
        }

        public KString withId(UUID id) {
            return this.id == id ? this : new KString(id, this.prefix, this.markers, this.delimiter, this.strings, this.type);
        }

        public KString withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new KString(this.id, prefix, this.markers, this.delimiter, this.strings, this.type);
        }

        public KString withMarkers(Markers markers) {
            return this.markers == markers ? this : new KString(this.id, this.prefix, markers, this.delimiter, this.strings, this.type);
        }

        public KString withDelimiter(String delimiter) {
            return this.delimiter == delimiter ? this : new KString(this.id, this.prefix, this.markers, delimiter, this.strings, this.type);
        }

        public KString withStrings(List<J> strings) {
            return this.strings == strings ? this : new KString(this.id, this.prefix, this.markers, this.delimiter, strings, this.type);
        }

        public KString withType(JavaType type) {
            return this.type == type ? this : new KString(this.id, this.prefix, this.markers, this.delimiter, this.strings, type);
        }

        public static final class Value
        implements K {
            private final UUID id;
            private final Markers markers;
            private final J tree;
            private final boolean enclosedInBraces;

            public <J2 extends J> J2 withPrefix(Space space) {
                return (J2)this;
            }

            @Override
            public Space getPrefix() {
                return Space.EMPTY;
            }

            @Override
            public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
                return v.visitKStringValue(this, p);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof Value;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public Value(UUID id, Markers markers, J tree, boolean enclosedInBraces) {
                this.id = id;
                this.markers = markers;
                this.tree = tree;
                this.enclosedInBraces = enclosedInBraces;
            }

            public UUID getId() {
                return this.id;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public J getTree() {
                return this.tree;
            }

            public boolean isEnclosedInBraces() {
                return this.enclosedInBraces;
            }

            public String toString() {
                return "K.KString.Value(id=" + this.getId() + ", markers=" + this.getMarkers() + ", tree=" + this.getTree() + ", enclosedInBraces=" + this.isEnclosedInBraces() + ")";
            }

            public Value withId(UUID id) {
                return this.id == id ? this : new Value(id, this.markers, this.tree, this.enclosedInBraces);
            }

            public Value withMarkers(Markers markers) {
                return this.markers == markers ? this : new Value(this.id, markers, this.tree, this.enclosedInBraces);
            }

            public Value withTree(J tree) {
                return this.tree == tree ? this : new Value(this.id, this.markers, tree, this.enclosedInBraces);
            }

            public Value withEnclosedInBraces(boolean enclosedInBraces) {
                return this.enclosedInBraces == enclosedInBraces ? this : new Value(this.id, this.markers, this.tree, enclosedInBraces);
            }
        }
    }

    public static final class KReturn
    implements K,
    Statement {
        private final UUID id;
        private final J.Return expression;
        @Nullable
        private final J.Identifier label;

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withExpression(this.expression.withPrefix(space));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withExpression(this.expression.withMarkers(markers));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitKReturn(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new KotlinPrinter());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KReturn)) {
                return false;
            }
            KReturn other = (KReturn)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public KReturn(UUID id, J.Return expression, J.Identifier label) {
            this.id = id;
            this.expression = expression;
            this.label = label;
        }

        public UUID getId() {
            return this.id;
        }

        public J.Return getExpression() {
            return this.expression;
        }

        public J.Identifier getLabel() {
            return this.label;
        }

        public KReturn withId(UUID id) {
            return this.id == id ? this : new KReturn(id, this.expression, this.label);
        }

        public KReturn withExpression(J.Return expression) {
            return this.expression == expression ? this : new KReturn(this.id, expression, this.label);
        }

        public KReturn withLabel(J.Identifier label) {
            return this.label == label ? this : new KReturn(this.id, this.expression, label);
        }
    }

    public static final class FunctionType
    implements K,
    Expression,
    Statement,
    TypeTree {
        private final UUID id;
        private final TypedTree typedTree;
        @Nullable
        private final J.Annotation suspendModifier;
        @Nullable
        private final JRightPadded<NameTree> receiver;

        @Override
        public Space getPrefix() {
            return this.typedTree.getPrefix();
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withTypedTree((TypedTree)this.typedTree.withPrefix(space));
        }

        public Markers getMarkers() {
            return this.typedTree.getMarkers();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withTypedTree((TypedTree)this.typedTree.withMarkers(markers));
        }

        @Nullable
        public JavaType getType() {
            return this.typedTree.getType();
        }

        public <J2 extends J> J2 withType(@Nullable JavaType type) {
            return (J2)this.withTypedTree((TypedTree)this.typedTree.withType(type));
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitFunctionType(this, p);
        }

        public FunctionType(UUID id, TypedTree typedTree, J.Annotation suspendModifier, JRightPadded<NameTree> receiver) {
            this.id = id;
            this.typedTree = typedTree;
            this.suspendModifier = suspendModifier;
            this.receiver = receiver;
        }

        public UUID getId() {
            return this.id;
        }

        public TypedTree getTypedTree() {
            return this.typedTree;
        }

        public J.Annotation getSuspendModifier() {
            return this.suspendModifier;
        }

        public JRightPadded<NameTree> getReceiver() {
            return this.receiver;
        }

        public String toString() {
            return "K.FunctionType(id=" + this.getId() + ", typedTree=" + this.getTypedTree() + ", suspendModifier=" + this.getSuspendModifier() + ", receiver=" + this.getReceiver() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof FunctionType;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public FunctionType withId(UUID id) {
            return this.id == id ? this : new FunctionType(id, this.typedTree, this.suspendModifier, this.receiver);
        }

        public FunctionType withTypedTree(TypedTree typedTree) {
            return this.typedTree == typedTree ? this : new FunctionType(this.id, typedTree, this.suspendModifier, this.receiver);
        }

        public FunctionType withSuspendModifier(J.Annotation suspendModifier) {
            return this.suspendModifier == suspendModifier ? this : new FunctionType(this.id, this.typedTree, suspendModifier, this.receiver);
        }

        public FunctionType withReceiver(JRightPadded<NameTree> receiver) {
            return this.receiver == receiver ? this : new FunctionType(this.id, this.typedTree, this.suspendModifier, receiver);
        }
    }

    public static final class ExpressionStatement
    implements K,
    Expression,
    Statement {
        private final UUID id;
        private final Expression expression;

        public ExpressionStatement(Expression expression) {
            this.id = Tree.randomId();
            this.expression = expression;
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            J j = (J)v.visit((Tree)this.getExpression(), p);
            if (j instanceof ExpressionStatement) {
                return j;
            }
            if (j instanceof Expression) {
                return this.withExpression((Expression)j);
            }
            return j;
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withExpression((Expression)this.expression.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withExpression((Expression)this.expression.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        @Nullable
        public JavaType getType() {
            return this.expression.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this.withExpression((Expression)this.expression.withType(type));
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public String toString() {
            return "K.ExpressionStatement(id=" + this.getId() + ", expression=" + this.getExpression() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ExpressionStatement;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public ExpressionStatement(UUID id, Expression expression) {
            this.id = id;
            this.expression = expression;
        }

        public ExpressionStatement withId(UUID id) {
            return this.id == id ? this : new ExpressionStatement(id, this.expression);
        }

        public UUID getId() {
            return this.id;
        }

        public ExpressionStatement withExpression(Expression expression) {
            return this.expression == expression ? this : new ExpressionStatement(this.id, expression);
        }

        public Expression getExpression() {
            return this.expression;
        }
    }

    public static final class Binary
    implements K,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        private final Space after;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public Binary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, Space after, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.after = after;
            this.type = type;
        }

        private Binary(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, Space after, JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.after = after;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        public Space getAfter() {
            return this.after;
        }

        public JavaType getType() {
            return this.type;
        }

        public void setPadding(WeakReference<Padding> padding) {
            this.padding = padding;
        }

        public String toString() {
            return "K.Binary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + (Object)((Object)this.getOperator()) + ", right=" + this.getRight() + ", after=" + this.getAfter() + ", type=" + this.getType() + ")";
        }

        public Binary withId(UUID id) {
            return this.id == id ? this : new Binary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.after, this.type);
        }

        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.after, this.type);
        }

        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.after, this.type);
        }

        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.after, this.type);
        }

        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.after, this.type);
        }

        public Binary withAfter(Space after) {
            return this.after == after ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, after, this.type);
        }

        public Binary withType(JavaType type) {
            return this.type == type ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, this.after, type);
        }

        public static enum Type {
            Contains,
            Get,
            IdentityEquals,
            IdentityNotEquals,
            RangeTo;

        }

        public static class Padding {
            private final Binary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.after, this.t.type);
            }

            public Padding(Binary t) {
                this.t = t;
            }
        }
    }

    public static final class CompilationUnit
    implements K,
    JavaSourceFile,
    SourceFile {
        @Nullable
        private transient SoftReference<TypesInUse> typesInUse;
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<J.Annotation> annotations;
        @Nullable
        private final JRightPadded<J.Package> packageDeclaration;
        private final List<JRightPadded<J.Import>> imports;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Nullable
        public J.Package getPackageDeclaration() {
            return this.packageDeclaration == null ? null : (J.Package)this.packageDeclaration.getElement();
        }

        public CompilationUnit withPackageDeclaration(J.Package packageDeclaration) {
            return this.getPadding().withPackageDeclaration((JRightPadded<J.Package>)JRightPadded.withElement(this.packageDeclaration, (Object)packageDeclaration));
        }

        public List<J.Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.imports, imports));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Transient
        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        public CompilationUnit withClasses(List<J.ClassDeclaration> classes) {
            return this.getPadding().withClasses(JRightPadded.withElements(this.getPadding().getClasses(), classes));
        }

        @Override
        public <P> J acceptKotlin(KotlinVisitor<P> v, P p) {
            return v.visitJavaSourceFile(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new KotlinPrinter();
        }

        @Transient
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return "K.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", annotations=" + this.getAnnotations() + ", packageDeclaration=" + this.getPackageDeclaration() + ", imports=" + this.getImports() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, FileAttributes fileAttributes, String charsetName, boolean charsetBomMarked, Checksum checksum, List<J.Annotation> annotations, JRightPadded<J.Package> packageDeclaration, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.annotations = annotations;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        private CompilationUnit(SoftReference<TypesInUse> typesInUse, WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, FileAttributes fileAttributes, String charsetName, boolean charsetBomMarked, Checksum checksum, List<J.Annotation> annotations, JRightPadded<J.Package> packageDeclaration, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.annotations = annotations;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public UUID getId() {
            return this.id;
        }

        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public CompilationUnit withFileAttributes(FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        private CompilationUnit withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        public CompilationUnit withChecksum(Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public CompilationUnit withAnnotations(List<J.Annotation> annotations) {
            return this.annotations == annotations ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, annotations, this.packageDeclaration, this.imports, this.statements, this.eof);
        }

        public List<J.Annotation> getAnnotations() {
            return this.annotations;
        }

        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.annotations, this.packageDeclaration, this.imports, this.statements, eof);
        }

        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            @Nullable
            public JRightPadded<J.Package> getPackageDeclaration() {
                return this.t.packageDeclaration;
            }

            public CompilationUnit withPackageDeclaration(@Nullable JRightPadded<J.Package> packageDeclaration) {
                return this.t.packageDeclaration == packageDeclaration ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, this.t.annotations, packageDeclaration, this.t.imports, this.t.statements, this.t.eof);
            }

            @Transient
            public List<JRightPadded<J.ClassDeclaration>> getClasses() {
                return this.t.statements.stream().filter(s -> s.getElement() instanceof J.ClassDeclaration).map(s -> s).collect(Collectors.toList());
            }

            public CompilationUnit withClasses(List<JRightPadded<J.ClassDeclaration>> classes) {
                List<JRightPadded<Statement>> statements = this.t.statements.stream().filter(s -> !(s.getElement() instanceof J.ClassDeclaration)).collect(Collectors.toList());
                statements.addAll(0, classes.stream().map(i -> i).collect(Collectors.toList()));
                return this.t.getPadding().getClasses() == classes ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.annotations, (JRightPadded<J.Package>)this.t.packageDeclaration, this.t.imports, statements, this.t.eof);
            }

            public List<JRightPadded<J.Import>> getImports() {
                return this.t.imports;
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, this.t.annotations, (JRightPadded<J.Package>)this.t.packageDeclaration, imports, this.t.statements, this.t.eof);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.annotations, (JRightPadded<J.Package>)this.t.packageDeclaration, this.t.imports, statements, this.t.eof);
            }

            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }
}

