/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.marker.Modifier;
import org.openrewrite.kotlin.tree.K;

public final class ChangeTypeAlias
extends Recipe {
    @Option(displayName="Old alias name", description="Name of the alias type.", example="OldAlias")
    private final String aliasName;
    @Option(displayName="New alias name", description="Name of the alias type.", example="NewAlias")
    private final String newName;
    @Option(displayName="Target fully qualified type", description="Fully-qualified class name of the aliased type.", example="org.junit.Assume")
    private final String fullyQualifiedAliasedType;

    public String getDisplayName() {
        return "Change type alias";
    }

    public String getDescription() {
        return "Change a given type alias to another.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinIsoVisitor<ExecutionContext>(){

            @Override
            public K.CompilationUnit visitCompilationUnit(K.CompilationUnit cu, ExecutionContext executionContext) {
                J c = super.visitCompilationUnit(cu, executionContext);
                J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)this.getCursor().pollMessage("RENAME_VARIABLE");
                if (variable != null) {
                    String uniqueName = VariableNameUtils.generateVariableName((String)ChangeTypeAlias.this.newName, (Cursor)this.getCursor(), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                    c = (K.CompilationUnit)new RenameVariable(variable, uniqueName).visit((Tree)c, (Object)executionContext, this.getCursor());
                    assert (c != null);
                }
                return c;
            }

            public J visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                if (this.isTypeAlias(multiVariable.getLeadingAnnotations()) && TypeUtils.isOfClassType((JavaType)multiVariable.getType(), (String)ChangeTypeAlias.this.fullyQualifiedAliasedType)) {
                    return super.visitVariableDeclarations(multiVariable, (Object)executionContext);
                }
                return multiVariable;
            }

            public J visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
                if (ChangeTypeAlias.this.aliasName.equals(variable.getSimpleName())) {
                    this.getCursor().putMessageOnFirstEnclosing(K.CompilationUnit.class, "RENAME_VARIABLE", (Object)variable);
                }
                return variable;
            }

            private boolean isTypeAlias(List<J.Annotation> annotationList) {
                return annotationList.stream().anyMatch(a -> "typealias".equals(a.getSimpleName()) && a.getMarkers().findFirst(Modifier.class).isPresent());
            }
        };
    }

    public ChangeTypeAlias(String aliasName, String newName, String fullyQualifiedAliasedType) {
        this.aliasName = aliasName;
        this.newName = newName;
        this.fullyQualifiedAliasedType = fullyQualifiedAliasedType;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getNewName() {
        return this.newName;
    }

    public String getFullyQualifiedAliasedType() {
        return this.fullyQualifiedAliasedType;
    }

    public String toString() {
        return "ChangeTypeAlias(aliasName=" + this.getAliasName() + ", newName=" + this.getNewName() + ", fullyQualifiedAliasedType=" + this.getFullyQualifiedAliasedType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTypeAlias)) {
            return false;
        }
        ChangeTypeAlias other = (ChangeTypeAlias)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$aliasName = this.getAliasName();
        String other$aliasName = other.getAliasName();
        if (this$aliasName == null ? other$aliasName != null : !this$aliasName.equals(other$aliasName)) {
            return false;
        }
        String this$newName = this.getNewName();
        String other$newName = other.getNewName();
        if (this$newName == null ? other$newName != null : !this$newName.equals(other$newName)) {
            return false;
        }
        String this$fullyQualifiedAliasedType = this.getFullyQualifiedAliasedType();
        String other$fullyQualifiedAliasedType = other.getFullyQualifiedAliasedType();
        return !(this$fullyQualifiedAliasedType == null ? other$fullyQualifiedAliasedType != null : !this$fullyQualifiedAliasedType.equals(other$fullyQualifiedAliasedType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangeTypeAlias;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $aliasName = this.getAliasName();
        result = result * 59 + ($aliasName == null ? 43 : $aliasName.hashCode());
        String $newName = this.getNewName();
        result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
        String $fullyQualifiedAliasedType = this.getFullyQualifiedAliasedType();
        result = result * 59 + ($fullyQualifiedAliasedType == null ? 43 : $fullyQualifiedAliasedType.hashCode());
        return result;
    }
}

