/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.kotlin.table.KotlinSourceFile;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.quark.Quark;
import org.openrewrite.text.PlainText;

public final class FindKotlinSources
extends Recipe {
    private final transient KotlinSourceFile kotlinSourceFile = new KotlinSourceFile(this);

    public String getDisplayName() {
        return "Find Kotlin sources and collect data metrics";
    }

    public String getDescription() {
        return "Use data table to collect source files types and counts of files with extensions `.kt`.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visitSourceFile(SourceFile sourceFile, ExecutionContext ctx) {
                if (sourceFile.getSourcePath().toString().endsWith(".kt")) {
                    KotlinSourceFile.SourceFileType sourceFileType = null;
                    if (sourceFile instanceof K.CompilationUnit) {
                        sourceFileType = KotlinSourceFile.SourceFileType.Kotlin;
                    } else if (sourceFile instanceof Quark) {
                        sourceFileType = KotlinSourceFile.SourceFileType.Quark;
                    } else if (sourceFile instanceof PlainText) {
                        sourceFileType = KotlinSourceFile.SourceFileType.PlainText;
                    }
                    FindKotlinSources.this.kotlinSourceFile.insertRow(ctx, new KotlinSourceFile.Row(sourceFile.getSourcePath().toString(), sourceFileType));
                    return SearchResult.found((Tree)sourceFile);
                }
                return sourceFile;
            }
        };
    }

    public KotlinSourceFile getKotlinSourceFile() {
        return this.kotlinSourceFile;
    }

    public String toString() {
        return "FindKotlinSources(kotlinSourceFile=" + (Object)((Object)this.getKotlinSourceFile()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindKotlinSources)) {
            return false;
        }
        FindKotlinSources other = (FindKotlinSources)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindKotlinSources;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

