/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonParser;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class ChangeValue
extends Recipe {
    @Option(displayName="Key path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression to locate a JSON entry.", example="$.subjects.kind")
    private final String oldKeyPath;
    @Option(displayName="New value", description="The new JSON value to set for the key identified by oldKeyPath.", example="'Deployment'")
    @Language(value="json")
    private final String value;

    public String getDisplayName() {
        return "Change value";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldKeyPath, this.value);
    }

    public String getDescription() {
        return "Change a JSON mapping entry value leaving the key intact.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.oldKeyPath);
        final Optional<JsonValue> jsonValue = ChangeValue.parseValues(this.firstParserInput(), '\"' + this.value + '\"');
        final int optionsHash = Objects.hash(this.oldKeyPath, this.value);
        return new JsonIsoVisitor<ExecutionContext>(){

            @Override
            public Json.Member visitMember(Json.Member member, ExecutionContext ctx) {
                Json m = super.visitMember(member, ctx);
                if (matcher.matches(this.getCursor()) && !((Json.Member)m).getMarkers().findFirst(Changed.class).map(c -> c.getRecipeOptionsHash() == optionsHash).orElse(false).booleanValue()) {
                    if (!jsonValue.isPresent()) {
                        return (Json.Member)SearchResult.found((Tree)m, (String)("Could not parse value: " + ChangeValue.this.value));
                    }
                    JsonValue parsedValue = (JsonValue)jsonValue.get();
                    return ((Json.Member)m).withValue((JsonValue)parsedValue.withPrefix(((Json.Member)m).getValue().getPrefix())).withMarkers(((Json.Member)m).getMarkers().add((Marker)new Changed(Tree.randomId(), optionsHash)));
                }
                return m;
            }
        };
    }

    private String firstParserInput() {
        if (this.value.startsWith("'") && this.value.endsWith("'")) {
            if (this.value.startsWith("'\"") && this.value.endsWith("\"'") && this.value.length() > 3) {
                return "\"'\\\"" + this.value.substring(2, this.value.length() - 2) + "\\\"'\"";
            }
            return '\"' + this.value + '\"';
        }
        return this.value;
    }

    private static Optional<JsonValue> parseValues(String ... values) {
        return JsonParser.builder().build().parse(values).filter(Json.Document.class::isInstance).map(Json.Document.class::cast).findFirst().map(Json.Document::getValue);
    }

    @Generated
    public ChangeValue(String oldKeyPath, @Language(value="json") String value) {
        this.oldKeyPath = oldKeyPath;
        this.value = value;
    }

    @Generated
    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    @Language(value="json")
    @Generated
    public String getValue() {
        return this.value;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeValue(oldKeyPath=" + this.getOldKeyPath() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeValue)) {
            return false;
        }
        ChangeValue other = (ChangeValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    static final class Changed
    implements Marker {
        private final UUID id;
        private final int recipeOptionsHash;

        @Generated
        public Changed(UUID id, int recipeOptionsHash) {
            this.id = id;
            this.recipeOptionsHash = recipeOptionsHash;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public int getRecipeOptionsHash() {
            return this.recipeOptionsHash;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Changed)) {
                return false;
            }
            Changed other = (Changed)o;
            if (this.getRecipeOptionsHash() != other.getRecipeOptionsHash()) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRecipeOptionsHash();
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ChangeValue.Changed(id=" + this.getId() + ", recipeOptionsHash=" + this.getRecipeOptionsHash() + ")";
        }

        @NonNull
        @Generated
        public Changed withId(UUID id) {
            return this.id == id ? this : new Changed(id, this.recipeOptionsHash);
        }

        @NonNull
        @Generated
        public Changed withRecipeOptionsHash(int recipeOptionsHash) {
            return this.recipeOptionsHash == recipeOptionsHash ? this : new Changed(this.id, recipeOptionsHash);
        }
    }
}

