/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonParser;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonKey;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;
import org.openrewrite.marker.Markers;

public final class AddKeyValue
extends Recipe {
    @Option(displayName="Key path", description="A JsonPath expression to locate the *parent* JSON entry.", example="'$.subjects.*' or '$.' or '$.x[1].y.*' etc.")
    private final String keyPath;
    @Option(displayName="Key", description="The key to create.", example="myKey")
    private final String key;
    @Option(displayName="Value", description="The value to add to the document at the specified key. Can be of any type representing JSON value. String values should be quoted to be inserted as Strings.", example="`\"myValue\"` or `{\"a\": 1}` or `[ 123 ]`")
    @Language(value="json")
    private final String value;
    @Option(displayName="Prepend", required=false, description="If set to `true` the value will be added to the beginning of the object")
    private final boolean prepend;

    public String getDisplayName() {
        return "Add value to JSON Object";
    }

    public String getDescription() {
        return "Adds a `value` at the specified `keyPath` with the specified `key`, if the key doesn't already exist.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JsonIsoVisitor<ExecutionContext>(){
            private final JsonPathMatcher pathMatcher;
            {
                this.pathMatcher = new JsonPathMatcher(AddKeyValue.this.keyPath);
            }

            @Override
            public Json.JsonObject visitObject(Json.JsonObject obj, ExecutionContext ctx) {
                obj = super.visitObject((Json.JsonObject)obj, ctx);
                if (this.pathMatcher.matches(this.getCursor()) && this.objectDoesNotContainKey((Json.JsonObject)obj, AddKeyValue.this.key)) {
                    List<Json> originalMembers = ((Json.JsonObject)obj).getMembers();
                    boolean jsonIsEmpty = originalMembers.isEmpty() || originalMembers.get(0) instanceof Json.Empty;
                    Space space = jsonIsEmpty || AddKeyValue.this.prepend ? originalMembers.get(0).getPrefix() : Space.build("\n", Collections.emptyList());
                    Json.Member newMember = new Json.Member(Tree.randomId(), space, Markers.EMPTY, this.rightPaddedKey(), this.parsedValue());
                    if (jsonIsEmpty) {
                        return this.autoFormat(((Json.JsonObject)obj).withMembers(Collections.singletonList(newMember)), ctx, this.getCursor().getParent());
                    }
                    List newMembers = AddKeyValue.this.prepend ? ListUtils.concat((Object)newMember, originalMembers) : ListUtils.concat(originalMembers, (Object)newMember);
                    return this.autoFormat(((Json.JsonObject)obj).withMembers(newMembers), ctx, this.getCursor().getParent());
                }
                return obj;
            }

            private JsonValue parsedValue() {
                Json.Document parsedDoc = (Json.Document)JsonParser.builder().build().parse(AddKeyValue.this.value.trim()).findFirst().get();
                JsonValue value = parsedDoc.getValue();
                return (JsonValue)value.withPrefix(value.getPrefix().withWhitespace(" "));
            }

            private JsonRightPadded<JsonKey> rightPaddedKey() {
                return new JsonRightPadded<JsonKey>(new Json.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "\"" + AddKeyValue.this.key + "\"", AddKeyValue.this.key), Space.EMPTY, Markers.EMPTY);
            }

            private boolean objectDoesNotContainKey(Json.JsonObject obj, String key) {
                for (Json member : obj.getMembers()) {
                    if (!(member instanceof Json.Member) || !this.keyMatches(((Json.Member)member).getKey(), key)) continue;
                    return false;
                }
                return true;
            }

            private boolean keyMatches(JsonKey jsonKey, String key) {
                if (jsonKey instanceof Json.Literal) {
                    return key.equals(((Json.Literal)jsonKey).getValue());
                }
                if (jsonKey instanceof Json.Identifier) {
                    return key.equals(((Json.Identifier)jsonKey).getName());
                }
                return false;
            }
        };
    }

    @Generated
    public AddKeyValue(String keyPath, String key, @Language(value="json") String value, boolean prepend) {
        this.keyPath = keyPath;
        this.key = key;
        this.value = value;
        this.prepend = prepend;
    }

    @Generated
    public String getKeyPath() {
        return this.keyPath;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Language(value="json")
    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean isPrepend() {
        return this.prepend;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddKeyValue(keyPath=" + this.getKeyPath() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", prepend=" + this.isPrepend() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddKeyValue)) {
            return false;
        }
        AddKeyValue other = (AddKeyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isPrepend() != other.isPrepend()) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddKeyValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrepend() ? 79 : 97);
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

