/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.style.TabsAndIndentsStyle;
import org.openrewrite.json.style.WrappingAndBracesStyle;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.LineWrapSetting;

public class TabsAndIndentsVisitor<P>
extends JsonIsoVisitor<P> {
    private final String singleIndent;
    private final GeneralFormatStyle generalFormatStyle;
    private final WrappingAndBracesStyle wrappingAndBracesStyle;
    private final @Nullable Tree stopAfter;

    public TabsAndIndentsVisitor(WrappingAndBracesStyle wrappingAndBracesStyle, TabsAndIndentsStyle tabsAndIndentsStyle, GeneralFormatStyle generalFormatStyle, @Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
        this.singleIndent = tabsAndIndentsStyle.singleIndent();
        this.wrappingAndBracesStyle = wrappingAndBracesStyle;
        this.generalFormatStyle = generalFormatStyle;
    }

    public Json preVisit(Json tree, P p) {
        Json json = (Json)super.preVisit((Tree)tree, p);
        if (tree instanceof Json.JsonObject || tree instanceof Json.Array) {
            String newIndent = this.getCurrentIndent() + this.singleIndent;
            this.getCursor().putMessage("indentToUse", (Object)newIndent);
        }
        return json;
    }

    public @Nullable Json postVisit(Json tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "stop", (Object)true);
        }
        return (Json)super.postVisit((Tree)tree, p);
    }

    public @Nullable Json visit(@Nullable Tree tree, P p) {
        LineWrapSetting wrappingSetting;
        List<JsonRightPadded<JsonValue>> members;
        String shiftedPrefix;
        String ws;
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Json)tree;
        }
        Json json = (Json)super.visit(tree, p);
        String relativeIndent = this.getCurrentIndent();
        if (json != null && (ws = json.getPrefix().getWhitespace()).contains("\n") && !(shiftedPrefix = this.combineIndent(ws, relativeIndent)).equals(ws)) {
            json = json.withPrefix(json.getPrefix().withWhitespace(shiftedPrefix));
        }
        if (json instanceof Json.JsonObject) {
            Json.JsonObject obj = (Json.JsonObject)json;
            members = obj.getPadding().getMembers();
            wrappingSetting = this.wrappingAndBracesStyle.getWrapObjects();
            members = this.applyWrappingStyleToLastChildSuffix(members, wrappingSetting, relativeIndent);
            json = obj.getPadding().withMembers(members);
        }
        if (json instanceof Json.Array) {
            Json.Array array = (Json.Array)json;
            members = array.getPadding().getValues();
            wrappingSetting = this.wrappingAndBracesStyle.getWrapArrays();
            members = this.applyWrappingStyleToLastChildSuffix(members, wrappingSetting, relativeIndent);
            json = array.getPadding().withValues(members);
        }
        return json;
    }

    private <JS extends Json> List<JsonRightPadded<JS>> applyWrappingStyleToLastChildSuffix(List<JsonRightPadded<JS>> elements, LineWrapSetting wrapping, String relativeIndent) {
        return ListUtils.mapLast(elements, elem -> {
            String newAfter;
            String currentAfter = elem.getAfter().getWhitespace();
            if (wrapping == LineWrapSetting.DoNotWrap) {
                newAfter = "";
            } else if (wrapping == LineWrapSetting.WrapAlways) {
                newAfter = this.generalFormatStyle.newLine() + relativeIndent;
            } else {
                throw new UnsupportedOperationException("Unknown LineWrapSetting: " + wrapping);
            }
            if (!newAfter.equals(currentAfter)) {
                return elem.withAfter(Space.build(newAfter, Collections.emptyList()));
            }
            return elem;
        });
    }

    private String getCurrentIndent() {
        String ret = (String)this.getCursor().getNearestMessage("indentToUse");
        if (ret == null) {
            Optional<Json> containingNode = this.getCursor().getPathAsStream().filter(obj -> obj instanceof Json && ((Json)obj).getPrefix().getWhitespace().contains("\n")).findFirst().map(obj -> (Json)obj);
            return containingNode.map(node -> node.getPrefix().getWhitespaceIndent()).orElse("");
        }
        return ret;
    }

    private String combineIndent(String oldWs, String relativeIndent) {
        return oldWs.substring(0, oldWs.lastIndexOf(10) + 1) + relativeIndent;
    }
}

