/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.format.TabsAndIndentsVisitor;
import org.openrewrite.json.style.Autodetect;
import org.openrewrite.json.style.TabsAndIndentsStyle;
import org.openrewrite.json.tree.Json;
import org.openrewrite.style.NamedStyles;

public class Indents
extends Recipe {
    public String getDisplayName() {
        return "JSON indent";
    }

    public String getDescription() {
        return "Format tabs and indents in JSON.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TabsAndIndentsFromCompilationUnitStyle();
    }

    private static class TabsAndIndentsFromCompilationUnitStyle
    extends JsonIsoVisitor<ExecutionContext> {
        private TabsAndIndentsFromCompilationUnitStyle() {
        }

        @Override
        public Json.Document visitDocument(Json.Document docs, ExecutionContext ctx) {
            TabsAndIndentsStyle style = (TabsAndIndentsStyle)docs.getStyle(TabsAndIndentsStyle.class);
            if (style == null) {
                style = (TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, Collections.singletonList(Autodetect.detector().sample(docs).build()));
                assert (style != null);
            }
            this.doAfterVisit(new TabsAndIndentsVisitor(style, null));
            return docs;
        }
    }
}

