/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import java.util.Collections;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.format.NormalizeLineBreaksVisitor;
import org.openrewrite.json.format.TabsAndIndentsVisitor;
import org.openrewrite.json.style.Autodetect;
import org.openrewrite.json.style.TabsAndIndentsStyle;
import org.openrewrite.json.tree.Json;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;

public class AutoFormatVisitor<P>
extends JsonIsoVisitor<P> {
    private final @Nullable Tree stopAfter;

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public Json preVisit(Json tree, P p) {
        this.stopAfterPreVisit();
        Json.Document doc = (Json.Document)this.getCursor().firstEnclosingOrThrow(Json.Document.class);
        Cursor cursor = this.getCursor().getParentOrThrow();
        Autodetect autodetectedStyle = Autodetect.detector().sample(doc).build();
        Json js = tree;
        TabsAndIndentsStyle taiStyle = Optional.ofNullable((TabsAndIndentsStyle)doc.getStyle(TabsAndIndentsStyle.class)).orElseGet(() -> (TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, Collections.singletonList(autodetectedStyle)));
        assert (taiStyle != null);
        js = (Json)new TabsAndIndentsVisitor(taiStyle, this.stopAfter).visitNonNull(js, p, cursor.fork());
        GeneralFormatStyle gfStyle = Optional.ofNullable((GeneralFormatStyle)doc.getStyle(GeneralFormatStyle.class)).orElseGet(() -> (GeneralFormatStyle)NamedStyles.merge(GeneralFormatStyle.class, Collections.singletonList(autodetectedStyle)));
        assert (gfStyle != null);
        js = (Json)new NormalizeLineBreaksVisitor(gfStyle, this.stopAfter).visitNonNull(js, p, cursor.fork());
        return js;
    }

    @Override
    public Json.Document visitDocument(Json.Document js, P p) {
        Autodetect autodetectedStyle = Autodetect.detector().sample(js).build();
        TabsAndIndentsStyle taiStyle = Optional.ofNullable((TabsAndIndentsStyle)js.getStyle(TabsAndIndentsStyle.class)).orElseGet(() -> (TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, Collections.singletonList(autodetectedStyle)));
        assert (taiStyle != null);
        js = (Json.Document)new TabsAndIndentsVisitor(taiStyle, this.stopAfter).visitNonNull(js, p);
        GeneralFormatStyle gfStyle = Optional.ofNullable((GeneralFormatStyle)js.getStyle(GeneralFormatStyle.class)).orElseGet(() -> (GeneralFormatStyle)NamedStyles.merge(GeneralFormatStyle.class, Collections.singletonList(autodetectedStyle)));
        assert (gfStyle != null);
        js = (Json.Document)new NormalizeLineBreaksVisitor(gfStyle, this.stopAfter).visitNonNull(js, p);
        return js;
    }

    public @Nullable Json postVisit(Json tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "stop", (Object)true);
        }
        return (Json)super.postVisit((Tree)tree, p);
    }

    public @Nullable Json visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Json)tree;
        }
        return (Json)super.visit(tree, p);
    }
}

