/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;

public class JsonVisitor<P>
extends TreeVisitor<Json, P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Json.Document;
    }

    public String getLanguage() {
        return "json";
    }

    public Json visitArray(Json.Array array, P p) {
        Json.Array a = array;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), p));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        a = a.withValues(ListUtils.map(a.getValues(), v -> (JsonValue)this.visit((Tree)v, p)));
        return a;
    }

    public Json visitDocument(Json.Document document, P p) {
        Json.Document d = document;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withValue((JsonValue)this.visit(d.getValue(), p));
        return d;
    }

    public Json visitEmpty(Json.Empty empty, P p) {
        Json.Empty e = empty;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        return e;
    }

    public Json visitIdentifier(Json.Identifier identifier, P p) {
        Json.Identifier i = identifier;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        return i;
    }

    public Json visitLiteral(Json.Literal literal, P p) {
        Json.Literal l = literal;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), p));
        l = l.withMarkers(this.visitMarkers(l.getMarkers(), p));
        return l;
    }

    public Json visitMember(Json.Member member, P p) {
        Json.Member m = member;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), p));
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), p));
        m = m.getPadding().withKey(this.visitRightPadded(m.getPadding().getKey(), p));
        m = m.withValue((JsonValue)this.visit(m.getValue(), p));
        return m;
    }

    public Json visitObject(Json.JsonObject obj, P p) {
        Json.JsonObject o = obj;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), p));
        o = o.withMarkers(this.visitMarkers(o.getMarkers(), p));
        o = o.withMembers(ListUtils.map(o.getMembers(), m -> (Json)this.visit((Tree)m, p)));
        return o;
    }

    public Space visitSpace(Space space, P p) {
        return space;
    }

    public <T extends Json> JsonRightPadded<T> visitRightPadded(@Nullable JsonRightPadded<T> right, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof Json) {
            t = (Json)this.visit((Tree)right.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), p);
        return after == right.getAfter() && t == right.getElement() ? right : new JsonRightPadded<T>(t, after, right.getMarkers());
    }
}

