/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonParsingException;
import org.openrewrite.json.internal.JsonParserVisitor;
import org.openrewrite.json.internal.grammar.JSON5Lexer;
import org.openrewrite.json.internal.grammar.JSON5Parser;
import org.openrewrite.json.tree.Json;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class JsonParser
implements Parser {
    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).map(input -> {
            SourceFile sourceFile;
            block8: {
                EncodingDetectingInputStream sourceStream = input.getSource(ctx);
                try {
                    JSON5Parser parser = new JSON5Parser((TokenStream)new CommonTokenStream((TokenSource)new JSON5Lexer(CharStreams.fromStream((InputStream)sourceStream))));
                    parser.removeErrorListeners();
                    parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(input.getPath(), ctx));
                    Json.Document document = new JsonParserVisitor(input.getRelativePath(relativeTo), input.getFileAttributes(), input.getSource(ctx)).visitJson5(parser.json5());
                    parsingListener.parsed(input, (SourceFile)document);
                    sourceFile = this.requirePrintEqualsInput(document, (Parser.Input)input, relativeTo, ctx);
                    if (sourceStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (sourceStream != null) {
                            try {
                                sourceStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        ctx.getOnError().accept(t);
                        return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
                    }
                }
                sourceStream.close();
            }
            return sourceFile;
        });
    }

    public Stream<SourceFile> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".json");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.json");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(Json.Document.class);
        }

        public JsonParser build() {
            return new JsonParser();
        }

        public String getDslName() {
            return "json";
        }
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new JsonParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), e));
        }
    }
}

