/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonParsingException;
import org.openrewrite.json.internal.JsonParserVisitor;
import org.openrewrite.json.internal.grammar.JSON5Lexer;
import org.openrewrite.json.internal.grammar.JSON5Parser;
import org.openrewrite.json.tree.Json;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class JsonParser
implements Parser<Json.Document> {
    public List<Json.Document> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Json.Document document;
            block8: {
                Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing an Json file").tag("file.type", "Json");
                Timer.Sample sample = Timer.start();
                InputStream sourceStream = sourceFile.getSource();
                try {
                    JSON5Parser parser = new JSON5Parser((TokenStream)new CommonTokenStream((TokenSource)new JSON5Lexer(CharStreams.fromStream((InputStream)sourceStream))));
                    parser.removeErrorListeners();
                    parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(sourceFile.getPath(), ctx));
                    Json.Document document2 = new JsonParserVisitor(sourceFile.getRelativePath(relativeTo), StringUtils.readFully((InputStream)sourceFile.getSource())).visitJson5(parser.json5());
                    sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                    parsingListener.parsed(sourceFile, (SourceFile)document2);
                    document = document2;
                    if (sourceStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (sourceStream != null) {
                            try {
                                sourceStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                        ctx.getOnError().accept(new IllegalStateException(sourceFile.getPath() + " " + t.getMessage(), t));
                        return null;
                    }
                }
                sourceStream.close();
            }
            return document;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Json.Document> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".json");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.json");
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new JsonParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), e));
        }
    }
}

