/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.internal.grammar.JsonPathLexer;
import org.openrewrite.json.internal.grammar.JsonPathParser;
import org.openrewrite.json.internal.grammar.JsonPathParserBaseVisitor;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonValue;

public class JsonPathMatcher {
    private final String jsonPath;

    public JsonPathMatcher(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public <T> Optional<T> find(Cursor cursor) {
        LinkedList cursorPath = cursor.getPathAsStream().filter(o -> o instanceof Tree).map(Tree.class::cast).collect(Collectors.toCollection(LinkedList::new));
        if (cursorPath.isEmpty()) {
            return Optional.empty();
        }
        Collections.reverse(cursorPath);
        Tree start = this.jsonPath.startsWith(".") && !this.jsonPath.startsWith("..") ? (Tree)cursor.getValue() : (Tree)cursorPath.peekFirst();
        JsonPathParserJsonVisitor v = new JsonPathParserJsonVisitor(cursorPath, start, false);
        JsonPathParser.JsonPathContext ctx = this.jsonPath().jsonPath();
        Object result = v.visit((ParseTree)ctx);
        return Optional.ofNullable(result);
    }

    public boolean matches(Cursor cursor) {
        List cursorPath = cursor.getPathAsStream().collect(Collectors.toList());
        return this.find(cursor).map(o -> {
            if (o instanceof List) {
                List l = (List)o;
                return !Collections.disjoint(l, cursorPath) && l.contains(cursor.getValue());
            }
            return Objects.equals(o, cursor.getValue());
        }).orElse(false);
    }

    private JsonPathParser jsonPath() {
        return new JsonPathParser((TokenStream)new CommonTokenStream((TokenSource)new JsonPathLexer((CharStream)CharStreams.fromString((String)this.jsonPath))));
    }

    private static class JsonPathParserJsonVisitor
    extends JsonPathParserBaseVisitor<Object> {
        private final List<Tree> cursorPath;
        protected Object scope;
        private final boolean isRecursiveDescent;

        public JsonPathParserJsonVisitor(List<Tree> cursorPath, Object scope, boolean isRecursiveDescent) {
            this.cursorPath = cursorPath;
            this.scope = scope;
            this.isRecursiveDescent = isRecursiveDescent;
        }

        protected Object defaultResult() {
            return this.scope;
        }

        protected Object aggregateResult(Object aggregate, Object nextResult) {
            this.scope = nextResult;
            return this.scope;
        }

        @Override
        public Object visitJsonPath(JsonPathParser.JsonPathContext ctx) {
            if (ctx.ROOT() != null || "[".equals(ctx.start.getText())) {
                this.scope = this.cursorPath.stream().filter(t -> t instanceof Json.JsonObject).findFirst().orElseGet(() -> this.cursorPath.stream().filter(t -> t instanceof Json.Document && ((Json.Document)t).getValue() instanceof Json.JsonObject).map(t -> ((Json.Document)t).getValue()).findFirst().orElse(null));
            }
            return super.visitJsonPath(ctx);
        }

        @Override
        public Object visitRecursiveDecent(JsonPathParser.RecursiveDecentContext ctx) {
            if (this.scope == null) {
                return null;
            }
            Object result = null;
            List previous = ctx.getParent().getParent().children;
            ParserRuleContext current = ctx.getParent();
            if (previous.indexOf(current) - 1 < 0 || "$".equals(((ParseTree)previous.get(previous.indexOf(current) - 1)).getText())) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Tree path : this.cursorPath) {
                    JsonPathParserJsonVisitor v = new JsonPathParserJsonVisitor(this.cursorPath, path, false);
                    for (int i = 1; i < ctx.getChildCount(); ++i) {
                        result = v.visit(ctx.getChild(i));
                        if (result == null) continue;
                        results.add(result);
                    }
                }
                return results;
            }
            JsonPathParserJsonVisitor v = new JsonPathParserJsonVisitor(this.cursorPath, this.scope, true);
            for (int i = 1; i < ctx.getChildCount() && (result = v.visit(ctx.getChild(i))) == null; ++i) {
            }
            return result;
        }

        @Override
        public Object visitBracketOperator(JsonPathParser.BracketOperatorContext ctx) {
            if (!ctx.property().isEmpty()) {
                if (ctx.property().size() == 1) {
                    return this.visitProperty(ctx.property(0));
                }
                return ctx.property().stream().map(this::visitProperty).collect(Collectors.toList());
            }
            if (ctx.slice() != null) {
                return this.visitSlice(ctx.slice());
            }
            if (ctx.indexes() != null) {
                return this.visitIndexes(ctx.indexes());
            }
            if (ctx.filter() != null) {
                return this.visitFilter(ctx.filter());
            }
            return null;
        }

        @Override
        public Object visitSlice(JsonPathParser.SliceContext ctx) {
            ArrayList<Object> results;
            if (this.scope instanceof List) {
                results = (ArrayList)this.scope;
            } else if (this.scope instanceof Json.Array) {
                Json.Array array = (Json.Array)this.scope;
                results = new ArrayList<JsonValue>(array.getValues());
            } else {
                if (this.scope instanceof Json.Member) {
                    this.scope = ((Json.Member)this.scope).getValue();
                    return this.visitSlice(ctx);
                }
                results = new ArrayList();
            }
            int start = 0;
            int limit = Integer.MAX_VALUE;
            if (ctx.PositiveNumber() != null) {
                limit = Integer.parseInt(ctx.PositiveNumber().getText());
            } else if (ctx.NegativeNumber() != null) {
                start = results.size() + Integer.parseInt(ctx.NegativeNumber().getText());
            } else if (ctx.start() != null) {
                start = ctx.start() != null ? Integer.parseInt(ctx.start().getText()) : 0;
                limit = ctx.end() != null ? Integer.parseInt(ctx.end().getText()) + 1 : limit;
            }
            return results.stream().skip(start).limit(limit).collect(Collectors.toList());
        }

        @Override
        public Object visitIndexes(JsonPathParser.IndexesContext ctx) {
            ArrayList<Object> results;
            if (this.scope instanceof List) {
                results = (ArrayList)this.scope;
            } else if (this.scope instanceof Json.Array) {
                Json.Array array = (Json.Array)this.scope;
                results = new ArrayList<JsonValue>(array.getValues());
            } else {
                if (this.scope instanceof Json.Member) {
                    this.scope = ((Json.Member)this.scope).getValue();
                    return this.visitIndexes(ctx);
                }
                results = new ArrayList();
            }
            ArrayList indexes = new ArrayList();
            for (TerminalNode terminalNode : ctx.PositiveNumber()) {
                for (int i = 0; i < results.size(); ++i) {
                    if (!terminalNode.getText().contains(String.valueOf(i))) continue;
                    indexes.add(results.get(i));
                }
            }
            return this.getResultFromList(indexes);
        }

        @Override
        public Object visitProperty(JsonPathParser.PropertyContext ctx) {
            if (this.scope instanceof Json.Member) {
                String name;
                Json.Member member = (Json.Member)this.scope;
                ArrayList<Object> matches = new ArrayList<Object>();
                String key = ((Json.Literal)member.getKey()).getValue().toString();
                String string = name = ctx.StringLiteral() != null ? JsonPathParserJsonVisitor.unquoteStringLiteral(ctx.StringLiteral().getText()) : ctx.Identifier().getText();
                if (this.isRecursiveDescent) {
                    if (key.equals(name)) {
                        matches.add(member);
                    }
                    this.scope = member.getValue();
                    Object result = this.getResultFromList(this.visitProperty(ctx));
                    if (result != null) {
                        matches.add(result);
                    }
                    return this.getResultFromList(matches);
                }
                if (member.getValue() instanceof Json.Literal) {
                    return key.equals(name) ? member : null;
                }
                this.scope = member.getValue();
                return this.visitProperty(ctx);
            }
            if (this.scope instanceof List) {
                List results = ((List)this.scope).stream().map(o -> {
                    this.scope = o;
                    return this.visitProperty(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                ArrayList matches = new ArrayList();
                for (Object result : results) {
                    if (result instanceof List) {
                        matches.addAll((List)result);
                        continue;
                    }
                    matches.add(result);
                }
                return this.getResultFromList(matches);
            }
            if (this.scope instanceof Json.JsonObject) {
                Json.JsonObject jsonObject = (Json.JsonObject)this.scope;
                if (this.isRecursiveDescent) {
                    this.scope = jsonObject.getMembers();
                    return this.getResultFromList(this.visitProperty(ctx));
                }
                for (Json json : jsonObject.getMembers()) {
                    String name;
                    Json.Member member;
                    String key;
                    if (!(json instanceof Json.Member) || !(key = ((Json.Literal)(member = (Json.Member)json).getKey()).getValue().toString()).equals(name = ctx.StringLiteral() != null ? JsonPathParserJsonVisitor.unquoteStringLiteral(ctx.StringLiteral().getText()) : ctx.Identifier().getText())) continue;
                    return member;
                }
            } else if (this.scope instanceof Json.Array) {
                List matches = ((Json.Array)this.scope).getValues().stream().map(o -> {
                    this.scope = o;
                    return this.visitProperty(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return this.getResultFromList(matches);
            }
            return null;
        }

        @Override
        public Object visitWildcard(JsonPathParser.WildcardContext ctx) {
            if (this.scope instanceof Json.Member) {
                Json.Member member = (Json.Member)this.scope;
                return member.getValue();
            }
            if (this.scope instanceof List) {
                return ((List)this.scope).stream().map(o -> {
                    this.scope = o;
                    return this.visitWildcard(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (this.scope instanceof Json.JsonObject) {
                Json.JsonObject jsonObject = (Json.JsonObject)this.scope;
                return jsonObject.getMembers();
            }
            if (this.scope instanceof Json.Array) {
                return ((Json.Array)this.scope).getValues().stream().map(o -> {
                    this.scope = o;
                    return this.visitWildcard(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return null;
        }

        @Override
        public Object visitFilterExpression(JsonPathParser.FilterExpressionContext ctx) {
            if (ctx.binaryExpression() != null) {
                Object filterOfScope = this.scope;
                Object result = this.visitBinaryExpression(ctx.binaryExpression());
                if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                    this.scope = filterOfScope;
                    return this.scope;
                }
            } else {
                if (ctx.regexExpression() != null) {
                    Object result = this.visitRegexExpression(ctx.regexExpression());
                    if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                        return this.scope;
                    }
                    return this.visitRegexExpression(ctx.regexExpression());
                }
                if (ctx.unaryExpression() != null && this.scope instanceof Json.Member) {
                    ArrayList<JsonValue> results = new ArrayList<JsonValue>();
                    Json.Member member = (Json.Member)this.scope;
                    if (member.getValue() instanceof Json.Array) {
                        Json.Array array = (Json.Array)member.getValue();
                        for (JsonValue value : array.getValues()) {
                            this.scope = value;
                            Object result = this.visitUnaryExpression(ctx.unaryExpression());
                            if (result == null) continue;
                            results.add(value);
                        }
                    }
                    return results;
                }
            }
            return null;
        }

        @Override
        public Object visitUnaryExpression(JsonPathParser.UnaryExpressionContext ctx) {
            if (ctx.property() != null) {
                return this.visitProperty(ctx.property());
            }
            if (ctx.jsonPath() != null) {
                Object result = this.getValue(this.visit((ParseTree)ctx.jsonPath()));
                result = this.getResultByKey(result, ctx.stop.getText());
                return result;
            }
            return null;
        }

        @Override
        public Object visitRegexExpression(JsonPathParser.RegexExpressionContext ctx) {
            Object lhs;
            if (this.scope == null || this.scope instanceof List && ((List)this.scope).isEmpty()) {
                return null;
            }
            String rhs = ctx.REGEX().getText();
            if (this.scope instanceof Json.Literal) {
                lhs = this.getValue(this.scope);
            } else {
                if (this.scope instanceof Json.Member) {
                    this.scope = ((Json.Member)this.scope).getValue();
                    return this.visitRegexExpression(ctx);
                }
                lhs = this.getValue(this.visitProperty(ctx.property()));
            }
            if (lhs instanceof Json.Member && ((Json.Member)lhs).getValue() instanceof Json.Literal) {
                lhs = this.getValue(lhs);
            }
            if (lhs != null) {
                String lhStr = lhs.toString();
                String rhStr = rhs.toString();
                if (Pattern.compile(rhStr).matcher(lhStr).matches()) {
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }

        @Override
        public Object visitBinaryExpression(JsonPathParser.BinaryExpressionContext ctx) {
            Object lhs = ctx.children.get(0);
            Object rhs = ctx.children.get(2);
            lhs = this.getBinaryExpressionResult(lhs);
            rhs = this.getBinaryExpressionResult(rhs);
            if (ctx.LOGICAL_OPERATOR() != null) {
                throw new UnsupportedOperationException("Logical operators are not supported. Please open an issue if you need this functionality.");
            }
            if (ctx.EQUALITY_OPERATOR() != null) {
                String operator;
                switch (ctx.EQUALITY_OPERATOR().getText()) {
                    case "==": {
                        operator = "==";
                        break;
                    }
                    case "!=": {
                        operator = "!=";
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (lhs instanceof List) {
                    for (Object match : (List)lhs) {
                        if (!this.checkObjectEquality(this.getValue(match), rhs, operator)) continue;
                        return Boolean.TRUE;
                    }
                } else if (this.checkObjectEquality(this.getValue(lhs), rhs, operator)) {
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }

        @Override
        public Object visitLiteralExpression(JsonPathParser.LiteralExpressionContext ctx) {
            String s = null;
            if (ctx.StringLiteral() != null) {
                s = ctx.StringLiteral().getText();
            } else if (!ctx.children.isEmpty()) {
                s = ((ParseTree)ctx.children.get(0)).getText();
            }
            if (s != null && (s.startsWith("'") || s.startsWith("\""))) {
                return s.substring(1, s.length() - 1);
            }
            return "null".equals(s) ? null : s;
        }

        @Nullable
        private Object getBinaryExpressionResult(Object ctx) {
            if (ctx instanceof JsonPathParser.BinaryExpressionContext) {
                ctx = this.visitBinaryExpression((JsonPathParser.BinaryExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.UnaryExpressionContext) {
                ctx = this.getValue(this.visitUnaryExpression((JsonPathParser.UnaryExpressionContext)((Object)ctx)));
            } else if (ctx instanceof JsonPathParser.RegexExpressionContext) {
                ctx = this.visitRegexExpression((JsonPathParser.RegexExpressionContext)((Object)ctx));
            } else if (ctx instanceof JsonPathParser.LiteralExpressionContext) {
                ctx = this.visitLiteralExpression((JsonPathParser.LiteralExpressionContext)((Object)ctx));
            }
            return ctx;
        }

        @Nullable
        public Object getResultByKey(Object result, String key) {
            if (result instanceof Json.Member) {
                Json.Member member = (Json.Member)result;
                if (member.getValue() instanceof Json.Literal) {
                    String k = member.getKey() instanceof Json.Literal ? ((Json.Literal)member.getKey()).getValue().toString() : ((Json.Identifier)member.getKey()).getName();
                    return k.equals(key) ? member : null;
                }
            } else if (result instanceof List) {
                for (Object o : (List)result) {
                    Object r = this.getResultByKey(o, key);
                    if (r == null) continue;
                    return r;
                }
            }
            return null;
        }

        private Object getResultFromList(Object results) {
            if (results instanceof List) {
                List matches = (List)results;
                if (matches.isEmpty()) {
                    return null;
                }
                if (matches.size() == 1) {
                    return matches.get(0);
                }
            }
            return results;
        }

        @Nullable
        private Object getValue(Object result) {
            if (result instanceof Json.Member) {
                return this.getValue(((Json.Member)result).getValue());
            }
            if (result instanceof Json.JsonObject) {
                return ((Json.JsonObject)result).getMembers();
            }
            if (result instanceof List) {
                return ((List)result).stream().map(this::getValue).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (result instanceof Json.Array) {
                return ((Json.Array)result).getValues();
            }
            if (result instanceof Json.Literal) {
                return ((Json.Literal)result).getValue();
            }
            if (result instanceof String) {
                return result;
            }
            return null;
        }

        private boolean checkObjectEquality(Object lhs, Object rhs, String operator) {
            BiPredicate<Object, Object> predicate = (lh, rh) -> {
                if (lh == null || rh == null) {
                    return false;
                }
                if ("==".equals(operator)) {
                    return Objects.equals(lh, rh);
                }
                if ("!=".equals(operator)) {
                    return !Objects.equals(lh, rh);
                }
                throw new UnsupportedOperationException("oops");
            };
            return predicate.test(lhs, rhs);
        }

        private static String unquoteStringLiteral(String literal) {
            if (literal != null && (literal.startsWith("'") || literal.startsWith("\""))) {
                return literal.substring(1, literal.length() - 1);
            }
            return "null".equals(literal) ? null : literal;
        }
    }
}

