/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.internal;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Comment;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JsonPrinter<P>
extends JsonVisitor<P> {
    private static final String PRINTER_ACC_KEY = "printed";
    private final TreePrinter<P> treePrinter;

    public JsonPrinter(TreePrinter<P> treePrinter) {
        this.treePrinter = treePrinter;
    }

    @NonNull
    protected StringBuilder getPrinter() {
        StringBuilder acc = (StringBuilder)this.getCursor().getRoot().getMessage(PRINTER_ACC_KEY);
        if (acc == null) {
            acc = new StringBuilder();
            this.getCursor().getRoot().putMessage(PRINTER_ACC_KEY, (Object)acc);
        }
        return acc;
    }

    public String print(Json json, P p) {
        this.setCursor(new Cursor(null, (Object)"EPSILON"));
        this.visit((Tree)json, (Object)p);
        return this.getPrinter().toString();
    }

    @Nullable
    public Json visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return (Json)this.defaultValue(null, p);
        }
        StringBuilder printerAcc = this.getPrinter();
        this.treePrinter.doBefore(tree, printerAcc, p);
        tree = super.visit(tree, p);
        if (tree != null) {
            this.treePrinter.doAfter(tree, printerAcc, p);
        }
        return (Json)tree;
    }

    public void visit(@Nullable List<? extends Json> nodes, P p) {
        if (nodes != null) {
            for (Json json : nodes) {
                this.visit((Tree)json, (Object)p);
            }
        }
    }

    @Override
    public Json visitArray(Json.Array array, P p) {
        this.visitSpace(array.getPrefix(), p);
        this.visitMarkers(array.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append('[');
        this.visitRightPadded(array.getPadding().getValues(), ",", p);
        acc.append(']');
        return array;
    }

    @Override
    public Json visitDocument(Json.Document document, P p) {
        this.visitSpace(document.getPrefix(), p);
        this.visitMarkers(document.getMarkers(), p);
        this.visit((Tree)document.getValue(), (Object)p);
        this.visitSpace(document.getEof(), p);
        return document;
    }

    @Override
    public Json visitEmpty(Json.Empty empty, P p) {
        this.visitSpace(empty.getPrefix(), p);
        this.visitMarkers(empty.getMarkers(), p);
        return empty;
    }

    @Override
    public Json visitIdentifier(Json.Identifier ident, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(ident.getPrefix(), p);
        this.visitMarkers(ident.getMarkers(), p);
        acc.append(ident.getName());
        return ident;
    }

    @Override
    public Json visitLiteral(Json.Literal literal, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(literal.getPrefix(), p);
        this.visitMarkers(literal.getMarkers(), p);
        acc.append(literal.getSource());
        return literal;
    }

    @Override
    public Json visitMember(Json.Member member, P p) {
        StringBuilder acc = this.getPrinter();
        this.visitSpace(member.getPrefix(), p);
        this.visitMarkers(member.getMarkers(), p);
        this.visitRightPadded(member.getPadding().getKey(), p);
        acc.append(':');
        this.visit((Tree)member.getValue(), (Object)p);
        return member;
    }

    @Override
    public Json visitObject(Json.JsonObject obj, P p) {
        this.visitSpace(obj.getPrefix(), p);
        this.visitMarkers(obj.getMarkers(), p);
        StringBuilder acc = this.getPrinter();
        acc.append('{');
        this.visitRightPadded(obj.getPadding().getMembers(), ",", p);
        acc.append('}');
        return obj;
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)marker, acc, p);
        acc.append(marker.print(this.treePrinter, p));
        this.treePrinter.doAfter((Tree)marker, acc, p);
        return (M)marker;
    }

    public Markers visitMarkers(Markers markers, P p) {
        StringBuilder acc = this.getPrinter();
        this.treePrinter.doBefore((Tree)markers, acc, p);
        Markers m = super.visitMarkers(markers, p);
        this.treePrinter.doAfter((Tree)markers, acc, p);
        return m;
    }

    @Override
    public Space visitSpace(Space space, P p) {
        StringBuilder acc = this.getPrinter();
        acc.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            if (comment.isMultiline()) {
                acc.append("/*").append(comment.getText()).append("*/");
            } else {
                acc.append("//").append(comment.getText());
            }
            acc.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitRightPadded(List<? extends JsonRightPadded<? extends Json>> nodes, String suffixBetween, P p) {
        StringBuilder acc = this.getPrinter();
        for (int i = 0; i < nodes.size(); ++i) {
            JsonRightPadded<? extends Json> node = nodes.get(i);
            this.visit((Tree)node.getElement(), (Object)p);
            this.visitSpace(node.getAfter(), p);
            if (i >= nodes.size() - 1) continue;
            acc.append(suffixBetween);
        }
    }
}

