/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Json;

public final class ChangeKey
extends Recipe {
    @Option(displayName="Old key path", description="A JsonPath expression to locate a JSON entry.", example="subjects/kind")
    private final String oldKeyPath;
    @Option(displayName="New key", description="The new name for the key selected by oldKeyPath.", example="kind")
    private final String newKey;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.json")
    @Nullable
    @Incubating(since="7.11.0")
    private final String fileMatcher;

    public String getDisplayName() {
        return "Change key";
    }

    public String getDescription() {
        return "Change a JSON mapping entry key leaving the value intact.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    public JsonVisitor<ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.oldKeyPath);
        return new JsonIsoVisitor<ExecutionContext>(){

            @Override
            public Json.Member visitMember(Json.Member member, ExecutionContext executionContext) {
                Json m = super.visitMember(member, executionContext);
                if (matcher.matches(this.getCursor())) {
                    String value = ChangeKey.this.newKey;
                    if (value.startsWith("'") || value.startsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    m = ((Json.Member)m).withKey(((Json.Member)m).getKey() instanceof Json.Literal ? ((Json.Literal)((Json.Member)m).getKey()).withSource(ChangeKey.this.newKey).withValue(value) : new Json.Literal(Tree.randomId(), ((Json.Member)m).getKey().getPrefix(), ((Json.Member)m).getKey().getMarkers(), ChangeKey.this.newKey, value));
                }
                return m;
            }
        };
    }

    public ChangeKey(String oldKeyPath, String newKey, @Nullable String fileMatcher) {
        this.oldKeyPath = oldKeyPath;
        this.newKey = newKey;
        this.fileMatcher = fileMatcher;
    }

    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    public String getNewKey() {
        return this.newKey;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "ChangeKey(oldKeyPath=" + this.getOldKeyPath() + ", newKey=" + this.getNewKey() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeKey)) {
            return false;
        }
        ChangeKey other = (ChangeKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$newKey = this.getNewKey();
        String other$newKey = other.getNewKey();
        if (this$newKey == null ? other$newKey != null : !this$newKey.equals(other$newKey)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $newKey = this.getNewKey();
        result = result * 59 + ($newKey == null ? 43 : $newKey.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

