/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.internal.grammar.JsonPath;
import org.openrewrite.json.internal.grammar.JsonPathBaseVisitor;
import org.openrewrite.json.internal.grammar.JsonPathLexer;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonValue;

public class JsonPathMatcher {
    private final String jsonPath;

    public JsonPathMatcher(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    private String debugPath(Cursor cursor) {
        return cursor.getPathAsStream().filter(Json.Member.class::isInstance).map(Json.Member.class::cast).map(m -> m.getKey().print()).collect(Collectors.joining(","));
    }

    public <T> Optional<T> find(Cursor cursor) {
        LinkedList cursorPath = cursor.getPathAsStream().filter(o -> o instanceof Tree).map(Tree.class::cast).collect(Collectors.toCollection(LinkedList::new));
        if (cursorPath.isEmpty()) {
            return Optional.empty();
        }
        Collections.reverse(cursorPath);
        Tree start = this.jsonPath.startsWith(".") && !this.jsonPath.startsWith("..") ? (Tree)cursor.getValue() : (Tree)cursorPath.peekFirst();
        JsonPathJsonVisitor v = new JsonPathJsonVisitor(cursorPath, start);
        JsonPath.JsonpathContext ctx = this.jsonPath().jsonpath();
        Object result = v.visit((ParseTree)ctx);
        return Optional.ofNullable(result);
    }

    public boolean matches(Cursor cursor) {
        List cursorPath = cursor.getPathAsStream().collect(Collectors.toList());
        return this.find(cursor).map(o -> {
            if (o instanceof List) {
                List l = (List)o;
                return !Collections.disjoint(l, cursorPath) && l.contains(cursor.getValue());
            }
            return Objects.equals(o, cursor.getValue());
        }).orElse(false);
    }

    public boolean encloses(Cursor cursor) {
        List cursorPath = cursor.getPathAsStream().collect(Collectors.toList());
        return this.find(cursor).map(o -> {
            if (o instanceof List) {
                return ((List)o).stream().anyMatch(cursorPath::contains);
            }
            return cursorPath.contains(o) && !Objects.equals(o, cursor.getValue());
        }).orElse(false);
    }

    private JsonPath jsonPath() {
        return new JsonPath((TokenStream)new CommonTokenStream((TokenSource)new JsonPathLexer((CharStream)CharStreams.fromString((String)this.jsonPath))));
    }

    private static class JsonPathJsonVisitor
    extends JsonPathBaseVisitor<Object> {
        private final List<Tree> cursorPath;
        protected Object context;

        public JsonPathJsonVisitor(List<Tree> cursorPath, Object context) {
            this.cursorPath = cursorPath;
            this.context = context;
        }

        protected Object defaultResult() {
            return this.context;
        }

        protected Object aggregateResult(Object aggregate, Object nextResult) {
            this.context = nextResult;
            return this.context;
        }

        @Override
        public Object visitJsonpath(JsonPath.JsonpathContext ctx) {
            if (ctx.ROOT() != null) {
                this.context = this.cursorPath.stream().filter(t -> t instanceof Json.JsonObject).findFirst().orElseGet(() -> this.cursorPath.stream().filter(t -> t instanceof Json.Document && ((Json.Document)t).getValue() instanceof Json.JsonObject).map(t -> ((Json.Document)t).getValue()).findFirst().orElse(null));
            }
            return super.visitJsonpath(ctx);
        }

        @Override
        public Object visitRecursiveDescent(JsonPath.RecursiveDescentContext ctx) {
            if (this.context == null) {
                return null;
            }
            Object result = null;
            for (Tree path : this.cursorPath) {
                JsonPathJsonVisitor v = new JsonPathJsonVisitor(this.cursorPath, path);
                int len = ctx.getParent().getChildCount();
                for (int i = 1; i < len && (result = v.visit(ctx.getParent().getChild(i))) != null; ++i) {
                }
                if (result == null) continue;
                return path;
            }
            return result;
        }

        @Override
        public Object visitWildcardExpression(JsonPath.WildcardExpressionContext ctx) {
            if (this.context instanceof Json.Member) {
                Json.Member e = (Json.Member)this.context;
                if (e.getValue() instanceof Json.Literal) {
                    return e;
                }
                this.context = e.getValue();
                return this.visitWildcardExpression(ctx);
            }
            if (this.context instanceof List) {
                return this.context;
            }
            if (this.context instanceof Json.JsonObject) {
                Json.JsonObject obj = (Json.JsonObject)this.context;
                return obj.getMembers();
            }
            if (this.context instanceof Json.Array) {
                Json.Array array = (Json.Array)this.context;
                return new ArrayList<JsonValue>(array.getValues());
            }
            return null;
        }

        @Override
        public Object visitRangeOp(JsonPath.RangeOpContext ctx) {
            ArrayList<Object> results;
            if (this.context == null) {
                return null;
            }
            if (this.context instanceof List) {
                results = (ArrayList)this.context;
            } else {
                if (this.context instanceof Json.JsonObject) {
                    return this.context;
                }
                if (this.context instanceof Json.Array) {
                    Json.Array array = (Json.Array)this.context;
                    results = new ArrayList<JsonValue>(array.getValues());
                } else {
                    if (this.context instanceof Json.Member) {
                        this.context = ((Json.Member)this.context).getValue();
                        return this.visitRangeOp(ctx);
                    }
                    results = new ArrayList();
                }
            }
            int start = ctx.start() != null ? Integer.parseInt(ctx.start().getText()) : 0;
            int end = ctx.end() != null ? Integer.parseInt(ctx.end().getText()) : Integer.MAX_VALUE;
            int entryCount = results.size();
            int limit = 0;
            if (end > 0) {
                limit = end - start;
            } else if (end < 0) {
                limit = entryCount + end;
            }
            return results.stream().skip(start).limit(limit).collect(Collectors.toList());
        }

        @Override
        public Object visitBinaryExpression(JsonPath.BinaryExpressionContext ctx) {
            BiPredicate<Object, Object> predicate = (lh, rh) -> {
                if (ctx.EQ() != null) {
                    return Objects.equals(lh, rh);
                }
                return false;
            };
            if (this.context instanceof Json.Member) {
                this.context = ((Json.Member)this.context).getValue();
                return this.visitBinaryExpression(ctx);
            }
            if (this.context instanceof Json.JsonObject) {
                return this.context;
            }
            if (this.context instanceof Json.Array) {
                Json.Array array = (Json.Array)this.context;
                JsonPath.ExpressionContext leftHandExpr = ctx.expression(0);
                Object rightHand = ctx.expression(1) instanceof JsonPath.LiteralExpressionContext ? JsonPathJsonVisitor.unquoteExpression((JsonPath.LiteralExpressionContext)ctx.expression(1)) : this.visit((ParseTree)ctx.expression(1));
                ArrayList<JsonValue> results = new ArrayList<JsonValue>();
                for (JsonValue v : array.getValues()) {
                    this.context = v;
                    Object leftHand = JsonPathJsonVisitor.getValue(this.visit((ParseTree)leftHandExpr));
                    if (!predicate.test(leftHand, rightHand)) continue;
                    results.add(v);
                }
                if (!results.isEmpty()) {
                    return results;
                }
            }
            return null;
        }

        @Override
        public Object visitBracketOperator(JsonPath.BracketOperatorContext ctx) {
            if (ctx.expression() instanceof JsonPath.LiteralExpressionContext) {
                if (this.context instanceof Json.Member) {
                    this.context = ((Json.Member)this.context).getValue();
                    return this.visitBracketOperator(ctx);
                }
                if (this.context instanceof Json.JsonObject) {
                    Json.JsonObject m = (Json.JsonObject)this.context;
                    JsonPath.LiteralExpressionContext litExpr = (JsonPath.LiteralExpressionContext)ctx.expression();
                    String key = JsonPathJsonVisitor.unquoteExpression(litExpr);
                    return m.getMembers().stream().filter(e -> e instanceof Json.Member && ((Json.Member)e).getKey() instanceof Json.Literal && ((Json.Literal)((Json.Member)e).getKey()).getValue().equals(key)).findFirst().orElse(null);
                }
            }
            return super.visitBracketOperator(ctx);
        }

        @Override
        @Nullable
        public Object visitIdentifier(JsonPath.IdentifierContext ctx) {
            if (this.context instanceof Json.Member) {
                Json.Member e2 = (Json.Member)this.context;
                if (e2.getValue() instanceof Json.Literal) {
                    return ((Json.Literal)e2.getKey()).getValue().equals(ctx.Identifier().getText()) ? e2 : null;
                }
                this.context = e2.getValue();
                return this.visitIdentifier(ctx);
            }
            if (this.context instanceof List) {
                List l = (List)this.context;
                return l.stream().map(o -> {
                    this.context = o;
                    return this.visitIdentifier(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            if (this.context instanceof Json.JsonObject) {
                Json.JsonObject m = (Json.JsonObject)this.context;
                return m.getMembers().stream().filter(e -> e instanceof Json.Member && ((Json.Member)e).getKey() instanceof Json.Literal && ((Json.Literal)((Json.Member)e).getKey()).getValue().equals(ctx.Identifier().getText())).findFirst().orElse(null);
            }
            if (this.context instanceof Json.Array) {
                Json.Array array = (Json.Array)this.context;
                return array.getValues().stream().map(e -> {
                    this.context = e;
                    return this.visitIdentifier(ctx);
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return null;
        }

        private static String unquoteExpression(JsonPath.LiteralExpressionContext ctx) {
            String s = null;
            if (ctx.litExpression().StringLiteral() != null) {
                s = ctx.litExpression().StringLiteral().getText();
            }
            if (s != null && (s.startsWith("'") || s.startsWith("\""))) {
                return s.substring(1, s.length() - 1);
            }
            return "null".equals(s) ? null : s;
        }

        private static Object getValue(Object o) {
            Json.Member e;
            if (o instanceof Json.Member && (e = (Json.Member)o).getValue() instanceof Json.Literal) {
                Json.Literal s = (Json.Literal)e.getValue();
                return s.getValue();
            }
            return null;
        }
    }
}

