/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;

@JsonIgnoreType
public class NodeDependenciesInUse
extends DataTable<Row> {
    public NodeDependenciesInUse(Recipe recipe) {
        super(recipe, "Node.js dependencies in use", "Direct and transitive dependencies in use in Node.js projects.");
    }

    public static final class Row {
        @Column(displayName="Project name", description="The name of the project that contains the dependency (from package.json).")
        private final @Nullable String projectName;
        @Column(displayName="Project path", description="The path to the project.")
        private final String projectPath;
        @Column(displayName="Package name", description="The name of the npm package.")
        private final String packageName;
        @Column(displayName="Version", description="The resolved version of the package.")
        private final String version;
        @Column(displayName="Version constraint", description="The version constraint as declared in package.json.")
        private final @Nullable String versionConstraint;
        @Column(displayName="Scope", description="Dependency scope: dependencies, devDependencies, peerDependencies, optionalDependencies, or bundledDependencies.")
        private final String scope;
        @Column(displayName="Direct", description="Whether this is a direct dependency (true) or transitive dependency (false).")
        private final Boolean direct;
        @Column(displayName="Count", description="How many times this dependency appears in the dependency tree.")
        private final Integer count;
        @Column(displayName="License", description="The SPDX license identifier of the package, if available.")
        private final @Nullable String license;

        @Generated
        public Row(@Nullable String projectName, String projectPath, String packageName, String version, @Nullable String versionConstraint, String scope, Boolean direct, Integer count, @Nullable String license) {
            this.projectName = projectName;
            this.projectPath = projectPath;
            this.packageName = packageName;
            this.version = version;
            this.versionConstraint = versionConstraint;
            this.scope = scope;
            this.direct = direct;
            this.count = count;
            this.license = license;
        }

        @Generated
        public @Nullable String getProjectName() {
            return this.projectName;
        }

        @Generated
        public String getProjectPath() {
            return this.projectPath;
        }

        @Generated
        public String getPackageName() {
            return this.packageName;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public @Nullable String getVersionConstraint() {
            return this.versionConstraint;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public Boolean getDirect() {
            return this.direct;
        }

        @Generated
        public Integer getCount() {
            return this.count;
        }

        @Generated
        public @Nullable String getLicense() {
            return this.license;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Boolean this$direct = this.getDirect();
            Boolean other$direct = other.getDirect();
            if (this$direct == null ? other$direct != null : !((Object)this$direct).equals(other$direct)) {
                return false;
            }
            Integer this$count = this.getCount();
            Integer other$count = other.getCount();
            if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                return false;
            }
            String this$projectName = this.getProjectName();
            String other$projectName = other.getProjectName();
            if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
                return false;
            }
            String this$projectPath = this.getProjectPath();
            String other$projectPath = other.getProjectPath();
            if (this$projectPath == null ? other$projectPath != null : !this$projectPath.equals(other$projectPath)) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$versionConstraint = this.getVersionConstraint();
            String other$versionConstraint = other.getVersionConstraint();
            if (this$versionConstraint == null ? other$versionConstraint != null : !this$versionConstraint.equals(other$versionConstraint)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$license = this.getLicense();
            String other$license = other.getLicense();
            return !(this$license == null ? other$license != null : !this$license.equals(other$license));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $direct = this.getDirect();
            result = result * 59 + ($direct == null ? 43 : ((Object)$direct).hashCode());
            Integer $count = this.getCount();
            result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
            String $projectName = this.getProjectName();
            result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
            String $projectPath = this.getProjectPath();
            result = result * 59 + ($projectPath == null ? 43 : $projectPath.hashCode());
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $versionConstraint = this.getVersionConstraint();
            result = result * 59 + ($versionConstraint == null ? 43 : $versionConstraint.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $license = this.getLicense();
            result = result * 59 + ($license == null ? 43 : $license.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "NodeDependenciesInUse.Row(projectName=" + this.getProjectName() + ", projectPath=" + this.getProjectPath() + ", packageName=" + this.getPackageName() + ", version=" + this.getVersion() + ", versionConstraint=" + this.getVersionConstraint() + ", scope=" + this.getScope() + ", direct=" + this.getDirect() + ", count=" + this.getCount() + ", license=" + this.getLicense() + ")";
        }
    }
}

