/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.marketplace;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.openrewrite.javascript.marketplace.NpmRecipeBundleReader;
import org.openrewrite.javascript.rpc.InstallRecipesResponse;
import org.openrewrite.javascript.rpc.JavaScriptRewriteRpc;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleReader;
import org.openrewrite.marketplace.RecipeBundleResolver;

public class NpmRecipeBundleResolver
implements RecipeBundleResolver {
    private final JavaScriptRewriteRpc rpc;

    public String getEcosystem() {
        return "npm";
    }

    public RecipeBundleReader resolve(RecipeBundle bundle) {
        Path pkgPath = Paths.get(bundle.getPackageName(), new String[0]);
        InstallRecipesResponse response = Files.exists(pkgPath, new LinkOption[0]) ? this.rpc.installRecipes(pkgPath.toFile()) : this.rpc.installRecipes(bundle.getPackageName(), bundle.getVersion());
        if (response.getVersion() != null) {
            bundle.setVersion(response.getVersion());
        }
        return new NpmRecipeBundleReader(bundle, this.rpc);
    }

    @Generated
    public NpmRecipeBundleResolver(JavaScriptRewriteRpc rpc) {
        this.rpc = rpc;
    }
}

