/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.marker;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Marker;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcSendQueue;

public final class NodeResolutionResult
implements Marker,
RpcCodec<NodeResolutionResult> {
    private final UUID id;
    private final @Nullable String name;
    private final @Nullable String version;
    private final @Nullable String description;
    private final String path;
    private final @Nullable List<String> workspacePackagePaths;
    private final List<Dependency> dependencies;
    private final List<Dependency> devDependencies;
    private final List<Dependency> peerDependencies;
    private final List<Dependency> optionalDependencies;
    private final List<Dependency> bundledDependencies;
    private final List<ResolvedDependency> resolvedDependencies;
    private final @Nullable PackageManager packageManager;
    private final @Nullable Map<String, String> engines;
    private final @Nullable List<Npmrc> npmrcConfigs;

    public @Nullable ResolvedDependency getResolvedDependency(String packageName) {
        return this.resolvedDependencies.stream().filter(r -> r.getName().equals(packageName)).findFirst().orElse(null);
    }

    public void rpcSend(NodeResolutionResult after, RpcSendQueue q) {
        q.getAndSend((Object)after, NodeResolutionResult::getId);
        q.getAndSend((Object)after, NodeResolutionResult::getName);
        q.getAndSend((Object)after, NodeResolutionResult::getVersion);
        q.getAndSend((Object)after, NodeResolutionResult::getDescription);
        q.getAndSend((Object)after, NodeResolutionResult::getPath);
        q.getAndSend((Object)after, NodeResolutionResult::getWorkspacePackagePaths);
        q.getAndSendListAsRef((Object)after, NodeResolutionResult::getDependencies, dep -> dep.getName() + "@" + dep.getVersionConstraint(), dep -> dep.rpcSend((Dependency)dep, q));
        q.getAndSendListAsRef((Object)after, NodeResolutionResult::getDevDependencies, dep -> dep.getName() + "@" + dep.getVersionConstraint(), dep -> dep.rpcSend((Dependency)dep, q));
        q.getAndSendListAsRef((Object)after, NodeResolutionResult::getPeerDependencies, dep -> dep.getName() + "@" + dep.getVersionConstraint(), dep -> dep.rpcSend((Dependency)dep, q));
        q.getAndSendListAsRef((Object)after, NodeResolutionResult::getOptionalDependencies, dep -> dep.getName() + "@" + dep.getVersionConstraint(), dep -> dep.rpcSend((Dependency)dep, q));
        q.getAndSendListAsRef((Object)after, NodeResolutionResult::getBundledDependencies, dep -> dep.getName() + "@" + dep.getVersionConstraint(), dep -> dep.rpcSend((Dependency)dep, q));
        q.getAndSendListAsRef((Object)after, NodeResolutionResult::getResolvedDependencies, resolved -> resolved.getName() + "@" + resolved.getVersion(), resolved -> resolved.rpcSend((ResolvedDependency)resolved, q));
        q.getAndSend((Object)after, NodeResolutionResult::getPackageManager);
        q.getAndSend((Object)after, NodeResolutionResult::getEngines);
        q.getAndSendList((Object)after, n -> n.getNpmrcConfigs() != null ? n.getNpmrcConfigs() : Collections.emptyList(), Npmrc::getScope, npmrc -> npmrc.rpcSend((Npmrc)npmrc, q));
    }

    public NodeResolutionResult rpcReceive(NodeResolutionResult before, RpcReceiveQueue q) {
        return before.withId((UUID)q.receiveAndGet((Object)before.id, UUID::fromString)).withName((String)q.receive((Object)before.name)).withVersion((String)q.receive((Object)before.version)).withDescription((String)q.receive((Object)before.description)).withPath((String)q.receive((Object)before.path)).withWorkspacePackagePaths((List)q.receive(before.workspacePackagePaths)).withDependencies(q.receiveList(before.dependencies, dep -> dep.rpcReceive((Dependency)dep, q))).withDevDependencies(q.receiveList(before.devDependencies, dep -> dep.rpcReceive((Dependency)dep, q))).withPeerDependencies(q.receiveList(before.peerDependencies, dep -> dep.rpcReceive((Dependency)dep, q))).withOptionalDependencies(q.receiveList(before.optionalDependencies, dep -> dep.rpcReceive((Dependency)dep, q))).withBundledDependencies(q.receiveList(before.bundledDependencies, dep -> dep.rpcReceive((Dependency)dep, q))).withResolvedDependencies(q.receiveList(before.resolvedDependencies, resolved -> resolved.rpcReceive((ResolvedDependency)resolved, q))).withPackageManager((PackageManager)((Object)q.receiveAndGet((Object)before.packageManager, RpcReceiveQueue.toEnum(PackageManager.class)))).withEngines((Map)q.receive(before.engines)).withNpmrcConfigs(q.receiveList(before.npmrcConfigs, npmrc -> npmrc.rpcReceive((Npmrc)npmrc, q)));
    }

    @Generated
    public NodeResolutionResult(UUID id, @Nullable String name, @Nullable String version, @Nullable String description, String path, @Nullable List<String> workspacePackagePaths, List<Dependency> dependencies, List<Dependency> devDependencies, List<Dependency> peerDependencies, List<Dependency> optionalDependencies, List<Dependency> bundledDependencies, List<ResolvedDependency> resolvedDependencies, @Nullable PackageManager packageManager, @Nullable Map<String, String> engines, @Nullable List<Npmrc> npmrcConfigs) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.description = description;
        this.path = path;
        this.workspacePackagePaths = workspacePackagePaths;
        this.dependencies = dependencies;
        this.devDependencies = devDependencies;
        this.peerDependencies = peerDependencies;
        this.optionalDependencies = optionalDependencies;
        this.bundledDependencies = bundledDependencies;
        this.resolvedDependencies = resolvedDependencies;
        this.packageManager = packageManager;
        this.engines = engines;
        this.npmrcConfigs = npmrcConfigs;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public @Nullable String getName() {
        return this.name;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getDescription() {
        return this.description;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public @Nullable List<String> getWorkspacePackagePaths() {
        return this.workspacePackagePaths;
    }

    @Generated
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public List<Dependency> getDevDependencies() {
        return this.devDependencies;
    }

    @Generated
    public List<Dependency> getPeerDependencies() {
        return this.peerDependencies;
    }

    @Generated
    public List<Dependency> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    @Generated
    public List<Dependency> getBundledDependencies() {
        return this.bundledDependencies;
    }

    @Generated
    public List<ResolvedDependency> getResolvedDependencies() {
        return this.resolvedDependencies;
    }

    @Generated
    public @Nullable PackageManager getPackageManager() {
        return this.packageManager;
    }

    @Generated
    public @Nullable Map<String, String> getEngines() {
        return this.engines;
    }

    @Generated
    public @Nullable List<Npmrc> getNpmrcConfigs() {
        return this.npmrcConfigs;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeResolutionResult)) {
            return false;
        }
        NodeResolutionResult other = (NodeResolutionResult)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        List<String> this$workspacePackagePaths = this.getWorkspacePackagePaths();
        List<String> other$workspacePackagePaths = other.getWorkspacePackagePaths();
        if (this$workspacePackagePaths == null ? other$workspacePackagePaths != null : !((Object)this$workspacePackagePaths).equals(other$workspacePackagePaths)) {
            return false;
        }
        List<Dependency> this$dependencies = this.getDependencies();
        List<Dependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<Dependency> this$devDependencies = this.getDevDependencies();
        List<Dependency> other$devDependencies = other.getDevDependencies();
        if (this$devDependencies == null ? other$devDependencies != null : !((Object)this$devDependencies).equals(other$devDependencies)) {
            return false;
        }
        List<Dependency> this$peerDependencies = this.getPeerDependencies();
        List<Dependency> other$peerDependencies = other.getPeerDependencies();
        if (this$peerDependencies == null ? other$peerDependencies != null : !((Object)this$peerDependencies).equals(other$peerDependencies)) {
            return false;
        }
        List<Dependency> this$optionalDependencies = this.getOptionalDependencies();
        List<Dependency> other$optionalDependencies = other.getOptionalDependencies();
        if (this$optionalDependencies == null ? other$optionalDependencies != null : !((Object)this$optionalDependencies).equals(other$optionalDependencies)) {
            return false;
        }
        List<Dependency> this$bundledDependencies = this.getBundledDependencies();
        List<Dependency> other$bundledDependencies = other.getBundledDependencies();
        if (this$bundledDependencies == null ? other$bundledDependencies != null : !((Object)this$bundledDependencies).equals(other$bundledDependencies)) {
            return false;
        }
        List<ResolvedDependency> this$resolvedDependencies = this.getResolvedDependencies();
        List<ResolvedDependency> other$resolvedDependencies = other.getResolvedDependencies();
        if (this$resolvedDependencies == null ? other$resolvedDependencies != null : !((Object)this$resolvedDependencies).equals(other$resolvedDependencies)) {
            return false;
        }
        PackageManager this$packageManager = this.getPackageManager();
        PackageManager other$packageManager = other.getPackageManager();
        if (this$packageManager == null ? other$packageManager != null : !((Object)((Object)this$packageManager)).equals((Object)other$packageManager)) {
            return false;
        }
        Map<String, String> this$engines = this.getEngines();
        Map<String, String> other$engines = other.getEngines();
        if (this$engines == null ? other$engines != null : !((Object)this$engines).equals(other$engines)) {
            return false;
        }
        List<Npmrc> this$npmrcConfigs = this.getNpmrcConfigs();
        List<Npmrc> other$npmrcConfigs = other.getNpmrcConfigs();
        return !(this$npmrcConfigs == null ? other$npmrcConfigs != null : !((Object)this$npmrcConfigs).equals(other$npmrcConfigs));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        List<String> $workspacePackagePaths = this.getWorkspacePackagePaths();
        result = result * 59 + ($workspacePackagePaths == null ? 43 : ((Object)$workspacePackagePaths).hashCode());
        List<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<Dependency> $devDependencies = this.getDevDependencies();
        result = result * 59 + ($devDependencies == null ? 43 : ((Object)$devDependencies).hashCode());
        List<Dependency> $peerDependencies = this.getPeerDependencies();
        result = result * 59 + ($peerDependencies == null ? 43 : ((Object)$peerDependencies).hashCode());
        List<Dependency> $optionalDependencies = this.getOptionalDependencies();
        result = result * 59 + ($optionalDependencies == null ? 43 : ((Object)$optionalDependencies).hashCode());
        List<Dependency> $bundledDependencies = this.getBundledDependencies();
        result = result * 59 + ($bundledDependencies == null ? 43 : ((Object)$bundledDependencies).hashCode());
        List<ResolvedDependency> $resolvedDependencies = this.getResolvedDependencies();
        result = result * 59 + ($resolvedDependencies == null ? 43 : ((Object)$resolvedDependencies).hashCode());
        PackageManager $packageManager = this.getPackageManager();
        result = result * 59 + ($packageManager == null ? 43 : ((Object)((Object)$packageManager)).hashCode());
        Map<String, String> $engines = this.getEngines();
        result = result * 59 + ($engines == null ? 43 : ((Object)$engines).hashCode());
        List<Npmrc> $npmrcConfigs = this.getNpmrcConfigs();
        result = result * 59 + ($npmrcConfigs == null ? 43 : ((Object)$npmrcConfigs).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "NodeResolutionResult(id=" + this.getId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", path=" + this.getPath() + ", workspacePackagePaths=" + this.getWorkspacePackagePaths() + ", dependencies=" + this.getDependencies() + ", devDependencies=" + this.getDevDependencies() + ", peerDependencies=" + this.getPeerDependencies() + ", optionalDependencies=" + this.getOptionalDependencies() + ", bundledDependencies=" + this.getBundledDependencies() + ", resolvedDependencies=" + this.getResolvedDependencies() + ", packageManager=" + (Object)((Object)this.getPackageManager()) + ", engines=" + this.getEngines() + ", npmrcConfigs=" + this.getNpmrcConfigs() + ")";
    }

    @NonNull
    @Generated
    public NodeResolutionResult withId(UUID id) {
        return this.id == id ? this : new NodeResolutionResult(id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withName(@Nullable String name) {
        return this.name == name ? this : new NodeResolutionResult(this.id, name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withVersion(@Nullable String version) {
        return this.version == version ? this : new NodeResolutionResult(this.id, this.name, version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withDescription(@Nullable String description) {
        return this.description == description ? this : new NodeResolutionResult(this.id, this.name, this.version, description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withPath(String path) {
        return this.path == path ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withWorkspacePackagePaths(@Nullable List<String> workspacePackagePaths) {
        return this.workspacePackagePaths == workspacePackagePaths ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withDependencies(List<Dependency> dependencies) {
        return this.dependencies == dependencies ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withDevDependencies(List<Dependency> devDependencies) {
        return this.devDependencies == devDependencies ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withPeerDependencies(List<Dependency> peerDependencies) {
        return this.peerDependencies == peerDependencies ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withOptionalDependencies(List<Dependency> optionalDependencies) {
        return this.optionalDependencies == optionalDependencies ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withBundledDependencies(List<Dependency> bundledDependencies) {
        return this.bundledDependencies == bundledDependencies ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withResolvedDependencies(List<ResolvedDependency> resolvedDependencies) {
        return this.resolvedDependencies == resolvedDependencies ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, resolvedDependencies, this.packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withPackageManager(@Nullable PackageManager packageManager) {
        return this.packageManager == packageManager ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, packageManager, this.engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withEngines(@Nullable Map<String, String> engines) {
        return this.engines == engines ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, engines, this.npmrcConfigs);
    }

    @NonNull
    @Generated
    public NodeResolutionResult withNpmrcConfigs(@Nullable List<Npmrc> npmrcConfigs) {
        return this.npmrcConfigs == npmrcConfigs ? this : new NodeResolutionResult(this.id, this.name, this.version, this.description, this.path, this.workspacePackagePaths, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.bundledDependencies, this.resolvedDependencies, this.packageManager, this.engines, npmrcConfigs);
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
    public static final class ResolvedDependency
    implements RpcCodec<ResolvedDependency> {
        private final String name;
        private final String version;
        private final @Nullable List<Dependency> dependencies;
        private final @Nullable List<Dependency> devDependencies;
        private final @Nullable List<Dependency> peerDependencies;
        private final @Nullable List<Dependency> optionalDependencies;
        private final @Nullable Map<String, String> engines;
        private final @Nullable String license;

        public void rpcSend(ResolvedDependency after, RpcSendQueue q) {
            q.getAndSend((Object)after, ResolvedDependency::getName);
            q.getAndSend((Object)after, ResolvedDependency::getVersion);
            q.getAndSendListAsRef((Object)after, r -> r.getDependencies() != null ? r.getDependencies() : Collections.emptyList(), dep -> dep.getName() + "@" + dep.getVersionConstraint(), dep -> dep.rpcSend((Dependency)dep, q));
            q.getAndSendListAsRef((Object)after, r -> r.getDevDependencies() != null ? r.getDevDependencies() : Collections.emptyList(), dep -> dep.getName() + "@" + dep.getVersionConstraint(), dep -> dep.rpcSend((Dependency)dep, q));
            q.getAndSendListAsRef((Object)after, r -> r.getPeerDependencies() != null ? r.getPeerDependencies() : Collections.emptyList(), dep -> dep.getName() + "@" + dep.getVersionConstraint(), dep -> dep.rpcSend((Dependency)dep, q));
            q.getAndSendListAsRef((Object)after, r -> r.getOptionalDependencies() != null ? r.getOptionalDependencies() : Collections.emptyList(), dep -> dep.getName() + "@" + dep.getVersionConstraint(), dep -> dep.rpcSend((Dependency)dep, q));
            q.getAndSend((Object)after, ResolvedDependency::getEngines);
            q.getAndSend((Object)after, ResolvedDependency::getLicense);
        }

        public ResolvedDependency rpcReceive(ResolvedDependency before, RpcReceiveQueue q) {
            return before.withName((String)q.receive((Object)before.name)).withVersion((String)q.receive((Object)before.version)).withDependencies(q.receiveList(before.dependencies, dep -> dep.rpcReceive((Dependency)dep, q))).withDevDependencies(q.receiveList(before.devDependencies, dep -> dep.rpcReceive((Dependency)dep, q))).withPeerDependencies(q.receiveList(before.peerDependencies, dep -> dep.rpcReceive((Dependency)dep, q))).withOptionalDependencies(q.receiveList(before.optionalDependencies, dep -> dep.rpcReceive((Dependency)dep, q))).withEngines((Map)q.receive(before.engines)).withLicense((String)q.receive((Object)before.license));
        }

        @Generated
        public ResolvedDependency(String name, String version, @Nullable List<Dependency> dependencies, @Nullable List<Dependency> devDependencies, @Nullable List<Dependency> peerDependencies, @Nullable List<Dependency> optionalDependencies, @Nullable Map<String, String> engines, @Nullable String license) {
            this.name = name;
            this.version = version;
            this.dependencies = dependencies;
            this.devDependencies = devDependencies;
            this.peerDependencies = peerDependencies;
            this.optionalDependencies = optionalDependencies;
            this.engines = engines;
            this.license = license;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public @Nullable List<Dependency> getDependencies() {
            return this.dependencies;
        }

        @Generated
        public @Nullable List<Dependency> getDevDependencies() {
            return this.devDependencies;
        }

        @Generated
        public @Nullable List<Dependency> getPeerDependencies() {
            return this.peerDependencies;
        }

        @Generated
        public @Nullable List<Dependency> getOptionalDependencies() {
            return this.optionalDependencies;
        }

        @Generated
        public @Nullable Map<String, String> getEngines() {
            return this.engines;
        }

        @Generated
        public @Nullable String getLicense() {
            return this.license;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResolvedDependency)) {
                return false;
            }
            ResolvedDependency other = (ResolvedDependency)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            List<Dependency> this$dependencies = this.getDependencies();
            List<Dependency> other$dependencies = other.getDependencies();
            if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
                return false;
            }
            List<Dependency> this$devDependencies = this.getDevDependencies();
            List<Dependency> other$devDependencies = other.getDevDependencies();
            if (this$devDependencies == null ? other$devDependencies != null : !((Object)this$devDependencies).equals(other$devDependencies)) {
                return false;
            }
            List<Dependency> this$peerDependencies = this.getPeerDependencies();
            List<Dependency> other$peerDependencies = other.getPeerDependencies();
            if (this$peerDependencies == null ? other$peerDependencies != null : !((Object)this$peerDependencies).equals(other$peerDependencies)) {
                return false;
            }
            List<Dependency> this$optionalDependencies = this.getOptionalDependencies();
            List<Dependency> other$optionalDependencies = other.getOptionalDependencies();
            if (this$optionalDependencies == null ? other$optionalDependencies != null : !((Object)this$optionalDependencies).equals(other$optionalDependencies)) {
                return false;
            }
            Map<String, String> this$engines = this.getEngines();
            Map<String, String> other$engines = other.getEngines();
            if (this$engines == null ? other$engines != null : !((Object)this$engines).equals(other$engines)) {
                return false;
            }
            String this$license = this.getLicense();
            String other$license = other.getLicense();
            return !(this$license == null ? other$license != null : !this$license.equals(other$license));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            List<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            List<Dependency> $devDependencies = this.getDevDependencies();
            result = result * 59 + ($devDependencies == null ? 43 : ((Object)$devDependencies).hashCode());
            List<Dependency> $peerDependencies = this.getPeerDependencies();
            result = result * 59 + ($peerDependencies == null ? 43 : ((Object)$peerDependencies).hashCode());
            List<Dependency> $optionalDependencies = this.getOptionalDependencies();
            result = result * 59 + ($optionalDependencies == null ? 43 : ((Object)$optionalDependencies).hashCode());
            Map<String, String> $engines = this.getEngines();
            result = result * 59 + ($engines == null ? 43 : ((Object)$engines).hashCode());
            String $license = this.getLicense();
            result = result * 59 + ($license == null ? 43 : $license.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "NodeResolutionResult.ResolvedDependency(name=" + this.getName() + ", version=" + this.getVersion() + ", dependencies=" + this.getDependencies() + ", devDependencies=" + this.getDevDependencies() + ", peerDependencies=" + this.getPeerDependencies() + ", optionalDependencies=" + this.getOptionalDependencies() + ", engines=" + this.getEngines() + ", license=" + this.getLicense() + ")";
        }

        @NonNull
        @Generated
        public ResolvedDependency withName(String name) {
            return this.name == name ? this : new ResolvedDependency(name, this.version, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.engines, this.license);
        }

        @NonNull
        @Generated
        public ResolvedDependency withVersion(String version) {
            return this.version == version ? this : new ResolvedDependency(this.name, version, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.engines, this.license);
        }

        @NonNull
        @Generated
        public ResolvedDependency withDependencies(@Nullable List<Dependency> dependencies) {
            return this.dependencies == dependencies ? this : new ResolvedDependency(this.name, this.version, dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.engines, this.license);
        }

        @NonNull
        @Generated
        public ResolvedDependency withDevDependencies(@Nullable List<Dependency> devDependencies) {
            return this.devDependencies == devDependencies ? this : new ResolvedDependency(this.name, this.version, this.dependencies, devDependencies, this.peerDependencies, this.optionalDependencies, this.engines, this.license);
        }

        @NonNull
        @Generated
        public ResolvedDependency withPeerDependencies(@Nullable List<Dependency> peerDependencies) {
            return this.peerDependencies == peerDependencies ? this : new ResolvedDependency(this.name, this.version, this.dependencies, this.devDependencies, peerDependencies, this.optionalDependencies, this.engines, this.license);
        }

        @NonNull
        @Generated
        public ResolvedDependency withOptionalDependencies(@Nullable List<Dependency> optionalDependencies) {
            return this.optionalDependencies == optionalDependencies ? this : new ResolvedDependency(this.name, this.version, this.dependencies, this.devDependencies, this.peerDependencies, optionalDependencies, this.engines, this.license);
        }

        @NonNull
        @Generated
        public ResolvedDependency withEngines(@Nullable Map<String, String> engines) {
            return this.engines == engines ? this : new ResolvedDependency(this.name, this.version, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, engines, this.license);
        }

        @NonNull
        @Generated
        public ResolvedDependency withLicense(@Nullable String license) {
            return this.license == license ? this : new ResolvedDependency(this.name, this.version, this.dependencies, this.devDependencies, this.peerDependencies, this.optionalDependencies, this.engines, license);
        }
    }

    public static enum PackageManager {
        Npm,
        YarnClassic,
        YarnBerry,
        Pnpm,
        Bun;

    }

    public static final class Npmrc
    implements RpcCodec<Npmrc> {
        private final NpmrcScope scope;
        private final Map<String, String> properties;

        public void rpcSend(Npmrc after, RpcSendQueue q) {
            q.getAndSend((Object)after, Npmrc::getScope);
            q.getAndSend((Object)after, Npmrc::getProperties);
        }

        public Npmrc rpcReceive(Npmrc before, RpcReceiveQueue q) {
            return before.withScope((NpmrcScope)((Object)q.receiveAndGet((Object)before.scope, RpcReceiveQueue.toEnum(NpmrcScope.class)))).withProperties((Map)q.receive(before.properties));
        }

        @Generated
        public Npmrc(NpmrcScope scope, Map<String, String> properties) {
            this.scope = scope;
            this.properties = properties;
        }

        @Generated
        public NpmrcScope getScope() {
            return this.scope;
        }

        @Generated
        public Map<String, String> getProperties() {
            return this.properties;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Npmrc)) {
                return false;
            }
            Npmrc other = (Npmrc)o;
            NpmrcScope this$scope = this.getScope();
            NpmrcScope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
                return false;
            }
            Map<String, String> this$properties = this.getProperties();
            Map<String, String> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NpmrcScope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            Map<String, String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "NodeResolutionResult.Npmrc(scope=" + (Object)((Object)this.getScope()) + ", properties=" + this.getProperties() + ")";
        }

        @NonNull
        @Generated
        public Npmrc withScope(NpmrcScope scope) {
            return this.scope == scope ? this : new Npmrc(scope, this.properties);
        }

        @NonNull
        @Generated
        public Npmrc withProperties(Map<String, String> properties) {
            return this.properties == properties ? this : new Npmrc(this.scope, properties);
        }
    }

    @JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
    public static final class Dependency
    implements RpcCodec<Dependency> {
        private final String name;
        private final String versionConstraint;
        private final @Nullable ResolvedDependency resolved;

        public void rpcSend(Dependency after, RpcSendQueue q) {
            q.getAndSend((Object)after, Dependency::getName);
            q.getAndSend((Object)after, Dependency::getVersionConstraint);
            q.getAndSend((Object)after, Dependency::getResolved);
        }

        public Dependency rpcReceive(Dependency before, RpcReceiveQueue q) {
            return before.withName((String)q.receive((Object)before.name)).withVersionConstraint((String)q.receive((Object)before.versionConstraint)).withResolved((ResolvedDependency)q.receive((Object)before.resolved));
        }

        @Generated
        public Dependency(String name, String versionConstraint, @Nullable ResolvedDependency resolved) {
            this.name = name;
            this.versionConstraint = versionConstraint;
            this.resolved = resolved;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersionConstraint() {
            return this.versionConstraint;
        }

        @Generated
        public @Nullable ResolvedDependency getResolved() {
            return this.resolved;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$versionConstraint = this.getVersionConstraint();
            String other$versionConstraint = other.getVersionConstraint();
            if (this$versionConstraint == null ? other$versionConstraint != null : !this$versionConstraint.equals(other$versionConstraint)) {
                return false;
            }
            ResolvedDependency this$resolved = this.getResolved();
            ResolvedDependency other$resolved = other.getResolved();
            return !(this$resolved == null ? other$resolved != null : !((Object)this$resolved).equals(other$resolved));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $versionConstraint = this.getVersionConstraint();
            result = result * 59 + ($versionConstraint == null ? 43 : $versionConstraint.hashCode());
            ResolvedDependency $resolved = this.getResolved();
            result = result * 59 + ($resolved == null ? 43 : ((Object)$resolved).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "NodeResolutionResult.Dependency(name=" + this.getName() + ", versionConstraint=" + this.getVersionConstraint() + ", resolved=" + this.getResolved() + ")";
        }

        @NonNull
        @Generated
        public Dependency withName(String name) {
            return this.name == name ? this : new Dependency(name, this.versionConstraint, this.resolved);
        }

        @NonNull
        @Generated
        public Dependency withVersionConstraint(String versionConstraint) {
            return this.versionConstraint == versionConstraint ? this : new Dependency(this.name, versionConstraint, this.resolved);
        }

        @NonNull
        @Generated
        public Dependency withResolved(@Nullable ResolvedDependency resolved) {
            return this.resolved == resolved ? this : new Dependency(this.name, this.versionConstraint, resolved);
        }
    }

    public static enum NpmrcScope {
        Global,
        User,
        Project;

    }
}

