/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Parser;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.javascript.JavaScriptParser;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.json.tree.Json;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

public class Assertions {
    private Assertions() {
    }

    public static SourceSpecs npm(Path relativeTo, SourceSpecs ... sources) {
        SourceSpec spec;
        boolean alreadyInstalled = false;
        for (SourceSpecs multiSpec : sources) {
            Path sourcePath;
            if (!(multiSpec instanceof SourceSpec) || (sourcePath = (spec = (SourceSpec)multiSpec).getSourcePath()) == null || !"package.json".equals(sourcePath.toFile().getName())) continue;
            try {
                Path packageJson = relativeTo.resolve(sourcePath);
                if (Files.exists(packageJson, new LinkOption[0]) && new String(Files.readAllBytes(packageJson), StandardCharsets.UTF_8).equals(spec.getBefore())) {
                    alreadyInstalled = true;
                    continue;
                }
                Files.write(packageJson, Objects.requireNonNull(spec.getBefore()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        for (SourceSpecs multiSpec : sources) {
            if (!(multiSpec instanceof SourceSpec)) continue;
            spec = (SourceSpec)multiSpec;
            if (alreadyInstalled || !(spec.getParser() instanceof JavaScriptParser.Builder)) continue;
            Path packageJsonPath = relativeTo.resolve("package.json");
            if (!Files.exists(packageJsonPath, new LinkOption[0])) {
                alreadyInstalled = true;
                continue;
            }
            try {
                ProcessBuilder pb = new ProcessBuilder("npm", "install");
                pb.directory(relativeTo.toFile());
                pb.inheritIO();
                Process process = pb.start();
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    throw new RuntimeException("npm install failed with exit code: " + exitCode + " in directory: " + relativeTo.toFile().getAbsolutePath());
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed to run npm install in directory: " + relativeTo.toFile().getAbsolutePath(), e);
            }
            alreadyInstalled = true;
        }
        return SourceSpecs.dir((String)relativeTo.toString(), (SourceSpecs[])sources);
    }

    public static SourceSpecs packageJson(@Language(value="json") @Nullable String before) {
        return org.openrewrite.json.Assertions.json((String)before, spec -> spec.path("package.json"));
    }

    public static SourceSpecs packageJson(@Language(value="json") @Nullable String before, @Language(value="json") @Nullable String after) {
        return org.openrewrite.json.Assertions.json((String)before, (String)after, spec -> spec.path("package.json"));
    }

    public static SourceSpecs packageJson(@Language(value="json") @Nullable String before, @Language(value="json") @Nullable String after, Consumer<SourceSpec<Json.Document>> spec) {
        return org.openrewrite.json.Assertions.json((String)before, (String)after, s -> {
            s.path("package.json");
            spec.accept((SourceSpec<Json.Document>)s);
        });
    }

    public static SourceSpecs javascript(@Language(value="js") @Nullable String before) {
        return Assertions.javascript(before, (SourceSpec<JS.CompilationUnit> s) -> {});
    }

    public static SourceSpecs javascript(@Language(value="js") @Nullable String before, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        SourceSpec js = new SourceSpec(JS.CompilationUnit.class, null, (Parser.Builder)JavaScriptParser.builder(), before, SourceSpec.ValidateSource.noop, ctx -> {});
        Assertions.acceptSpec(spec, (SourceSpec<JS.CompilationUnit>)js);
        return js;
    }

    public static SourceSpecs javascript(@Language(value="js") @Nullable String before, @Language(value="js") @Nullable String after) {
        return Assertions.javascript(before, after, s -> {});
    }

    public static SourceSpecs javascript(@Language(value="js") @Nullable String before, @Language(value="js") @Nullable String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        SourceSpec js = new SourceSpec(JS.CompilationUnit.class, null, (Parser.Builder)JavaScriptParser.builder(), before, SourceSpec.ValidateSource.noop, ctx -> {}).after(s -> after);
        Assertions.acceptSpec(spec, (SourceSpec<JS.CompilationUnit>)js);
        return js;
    }

    public static SourceSpecs typescript(@Language(value="ts") @Nullable String before) {
        return Assertions.typescript(before, (SourceSpec<JS.CompilationUnit> s) -> {});
    }

    public static SourceSpecs typescript(@Language(value="ts") @Nullable String before, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javascript(before, (SourceSpec<JS.CompilationUnit> spec2) -> {
            spec2.path(System.nanoTime() + ".ts");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    public static SourceSpecs typescript(@Language(value="ts") @Nullable String before, @Language(value="ts") @Nullable String after) {
        return Assertions.typescript(before, after, s -> {});
    }

    public static SourceSpecs typescript(@Language(value="ts") @Nullable String before, @Language(value="ts") @Nullable String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javascript(before, after, spec2 -> {
            spec2.path(System.nanoTime() + ".tsx");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    public static SourceSpecs tsx(@Language(value="tsx") @Nullable String before) {
        return Assertions.typescript(before, (SourceSpec<JS.CompilationUnit> s) -> {});
    }

    public static SourceSpecs tsx(@Language(value="tsx") @Nullable String before, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.typescript(before, (SourceSpec<JS.CompilationUnit> spec2) -> {
            spec2.path(System.nanoTime() + ".tsx");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    public static SourceSpecs tsx(@Language(value="tsx") @Nullable String before, @Language(value="tsx") @Nullable String after) {
        return Assertions.tsx(before, after, s -> {});
    }

    public static SourceSpecs tsx(@Language(value="tsx") @Nullable String before, @Language(value="tsx") @Nullable String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.typescript(before, after, spec2 -> {
            spec2.path(System.nanoTime() + ".tsx");
            spec.accept((SourceSpec<JS.CompilationUnit>)spec2);
        });
    }

    private static void acceptSpec(Consumer<SourceSpec<JS.CompilationUnit>> spec, SourceSpec<JS.CompilationUnit> js) {
        ThrowingConsumer userSuppliedAfterRecipe = js.getAfterRecipe();
        js.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        spec.accept(js);
    }
}

