/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.javascript.internal.rpc.JavaScriptValidator;
import org.openrewrite.javascript.rpc.JavaScriptRewriteRpc;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.tree.ParseError;

public class JavaScriptParser
implements Parser {
    private final long maxSizeBytes;
    private static final List<String> EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".js", ".jsx", ".mjs", ".cjs", ".ts", ".tsx", ".mts", ".cts"));
    private static final List<String> EXCLUSIONS = Collections.unmodifiableList(Arrays.asList(".pnp.cjs", ".pnp.loader.mjs"));

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ArrayList<Parser.Input> smallFiles = new ArrayList<Parser.Input>();
        ArrayList<Parser.Input> largeFiles = new ArrayList<Parser.Input>();
        for (Parser.Input input : sources) {
            if (input.getFileAttributes() != null && input.getFileAttributes().getSize() > this.maxSizeBytes) {
                largeFiles.add(input);
                continue;
            }
            if (this.isMinified(input)) {
                largeFiles.add(input);
                continue;
            }
            smallFiles.add(input);
        }
        Stream largeFileStream = Stream.empty();
        if (!largeFiles.isEmpty()) {
            PlainTextParser plainTextParser = PlainTextParser.builder().build();
            largeFileStream = plainTextParser.parseInputs(largeFiles, relativeTo, ctx);
        }
        Stream<Object> smallFileStream = Stream.empty();
        if (!smallFiles.isEmpty()) {
            JavaScriptValidator validator = new JavaScriptValidator();
            smallFileStream = JavaScriptRewriteRpc.getOrStart().parse(smallFiles, relativeTo, this, ctx).map(source -> {
                try {
                    validator.visit((Tree)source, 0);
                    return source;
                }
                catch (Exception e) {
                    Optional<Parser.Input> input = StreamSupport.stream(smallFiles.spliterator(), false).filter(i -> i.getRelativePath(relativeTo).equals(source.getSourcePath())).findFirst();
                    return ParseError.build((Parser)this, (Parser.Input)input.orElseThrow(NoSuchElementException::new), (Path)relativeTo, (ExecutionContext)ctx, (Throwable)e);
                }
            });
        }
        return Stream.concat(largeFileStream, smallFileStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMinified(Parser.Input input) {
        try {
            String filename = input.getPath().getFileName().toString().toLowerCase();
            if (filename.contains(".min.")) return true;
            if (filename.endsWith(".min.js")) return true;
            if (filename.endsWith(".min.mjs")) return true;
            if (filename.endsWith(".min.cjs")) {
                return true;
            }
            try (EncodingDetectingInputStream is = input.getSource((ExecutionContext)new InMemoryExecutionContext());){
                boolean bl;
                int ch;
                int sampleSize = 10240;
                int longLineThreshold = 1000;
                int currentLineLength = 0;
                int totalCharsRead = 0;
                while ((ch = is.read()) != -1 && totalCharsRead < 10240) {
                    ++totalCharsRead;
                    if (ch == 10 || ch == 13) {
                        int next;
                        currentLineLength = 0;
                        if (ch != 13 || (next = is.read()) == -1) continue;
                        ++totalCharsRead;
                        if (next == 10) continue;
                        currentLineLength = 1;
                        continue;
                    }
                    if (++currentLineLength <= 1000) continue;
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public boolean accept(Path path) {
        if (path.toString().contains("/dist/")) {
            return false;
        }
        String filename = path.getFileName().toString().toLowerCase();
        for (String ext : EXTENSIONS) {
            if (!filename.endsWith(ext) || EXCLUSIONS.contains(filename)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("source.ts");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public JavaScriptParser(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
    }

    public static class Builder
    extends Parser.Builder {
        long maxSizeBytes = 0x100000L;

        Builder() {
            super(JS.CompilationUnit.class);
        }

        public Builder maxSizeBytes(long maxSizeBytes) {
            this.maxSizeBytes = maxSizeBytes;
            return this;
        }

        public JavaScriptParser build() {
            return new JavaScriptParser(this.maxSizeBytes);
        }

        public String getDslName() {
            return "javascript";
        }
    }
}

