/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc.generated;

public enum TSCFlowFlag {
    Unreachable(1),
    Start(2),
    BranchLabel(4),
    LoopLabel(8),
    Assignment(16),
    TrueCondition(32),
    FalseCondition(64),
    SwitchClause(128),
    ArrayMutation(256),
    Call(512),
    ReduceLabel(1024),
    Referenced(2048),
    Shared(4096),
    Label(12),
    Condition(96);

    public final int code;

    private TSCFlowFlag(int code) {
        this.code = code;
    }

    public static TSCFlowFlag fromMaskExact(int code) {
        switch (code) {
            case 1: {
                return Unreachable;
            }
            case 2: {
                return Start;
            }
            case 4: {
                return BranchLabel;
            }
            case 8: {
                return LoopLabel;
            }
            case 16: {
                return Assignment;
            }
            case 32: {
                return TrueCondition;
            }
            case 64: {
                return FalseCondition;
            }
            case 128: {
                return SwitchClause;
            }
            case 256: {
                return ArrayMutation;
            }
            case 512: {
                return Call;
            }
            case 1024: {
                return ReduceLabel;
            }
            case 2048: {
                return Referenced;
            }
            case 4096: {
                return Shared;
            }
            case 12: {
                return Label;
            }
            case 96: {
                return Condition;
            }
        }
        throw new IllegalArgumentException("unknown TSCFlowFlag code: " + code);
    }

    public boolean matches(int bitfield) {
        return (bitfield & this.code) != 0;
    }

    public static int union(TSCFlowFlag ... args) {
        int result = 0;
        for (TSCFlowFlag arg : args) {
            result |= arg.code;
        }
        return result;
    }
}

