/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.javascript.JavaScriptIsoVisitor;
import org.openrewrite.javascript.JavaScriptParser;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

public final class Assertions {
    private Assertions() {
    }

    public static SourceSpecs javaScript(@Nullable @Language(value="typescript") String before) {
        return Assertions.javaScript(before, (SourceSpec<JS.CompilationUnit> s) -> {});
    }

    public static SourceSpecs javaScript(@Nullable @Language(value="typescript") String before, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javaScript0(before, null, spec);
    }

    public static SourceSpecs javaScript(@Nullable @Language(value="typescript") String before, @Language(value="typescript") String after) {
        return Assertions.javaScript(before, after, s -> {});
    }

    public static SourceSpecs javaScript(@Nullable @Language(value="typescript") String before, @Language(value="typescript") String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        return Assertions.javaScript0(before, after, spec);
    }

    private static SourceSpec<JS.CompilationUnit> javaScript0(@Nullable @Language(value="typescript") String before, @Nullable @Language(value="typescript") String after, Consumer<SourceSpec<JS.CompilationUnit>> spec) {
        SourceSpec js = new SourceSpec(JS.CompilationUnit.class, null, (Parser.Builder)JavaScriptParser.builder(), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext);
        if (after != null) {
            js = js.after(s -> after);
        }
        Assertions.acceptSpec(spec, (SourceSpec<JS.CompilationUnit>)js);
        return js;
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
    }

    private static void acceptSpec(Consumer<SourceSpec<JS.CompilationUnit>> spec, SourceSpec<JS.CompilationUnit> javaScript) {
        ThrowingConsumer userSuppliedAfterRecipe = javaScript.getAfterRecipe();
        javaScript.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        Assertions.isFullyParsed().andThen(spec).accept(javaScript);
    }

    public static Consumer<SourceSpec<JS.CompilationUnit>> isFullyParsed() {
        return spec -> spec.afterRecipe(cu -> {
            new JavaScriptIsoVisitor<Integer>(){

                public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                    org.assertj.core.api.Assertions.assertThat((String)space.getWhitespace().trim()).isEmpty();
                    return super.visitSpace(space, loc, (Object)integer);
                }
            }.visit((Tree)cu, 0);
            new JavaScriptVisitor<Integer>(){

                @Nullable
                public J preVisit(J tree, Integer integer) {
                    if (tree instanceof J.Unknown) {
                        ((J.Unknown)tree).getSource().getMarkers().findFirst(ParseExceptionResult.class).ifPresent(result -> org.assertj.core.api.Assertions.assertThat((String)result.getMessage()).isEqualTo(""));
                    }
                    return (J)super.preVisit((Tree)tree, (Object)integer);
                }
            }.visit((Tree)cu, 0);
        });
    }
}

