/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc.generated;

public enum TSCObjectFlag {
    None(0),
    Class(1),
    Interface(2),
    Reference(4),
    Tuple(8),
    Anonymous(16),
    Mapped(32),
    Instantiated(64),
    ObjectLiteral(128),
    EvolvingArray(256),
    ObjectLiteralPatternWithComputedProperties(512),
    ReverseMapped(1024),
    JsxAttributes(2048),
    JSLiteral(4096),
    FreshLiteral(8192),
    ArrayLiteral(16384),
    PrimitiveUnion(32768),
    ContainsWideningType(65536),
    ContainsObjectOrArrayLiteral(131072),
    NonInferrableType(262144),
    CouldContainTypeVariablesComputed(524288),
    CouldContainTypeVariables(0x100000),
    ClassOrInterface(3),
    RequiresWidening(196608),
    PropagatingFlags(458752),
    ObjectTypeKindMask(1343),
    ContainsSpread(0x200000),
    ObjectRestType(0x400000),
    InstantiationExpressionType(0x800000),
    IsClassInstanceClone(0x1000000),
    IdenticalBaseTypeCalculated(0x2000000),
    IdenticalBaseTypeExists(0x4000000),
    IsGenericType(0xC00000);

    public final int code;

    private TSCObjectFlag(int code) {
        this.code = code;
    }

    public static TSCObjectFlag fromMaskExact(int code) {
        switch (code) {
            case 0: {
                return None;
            }
            case 1: {
                return Class;
            }
            case 2: {
                return Interface;
            }
            case 4: {
                return Reference;
            }
            case 8: {
                return Tuple;
            }
            case 16: {
                return Anonymous;
            }
            case 32: {
                return Mapped;
            }
            case 64: {
                return Instantiated;
            }
            case 128: {
                return ObjectLiteral;
            }
            case 256: {
                return EvolvingArray;
            }
            case 512: {
                return ObjectLiteralPatternWithComputedProperties;
            }
            case 1024: {
                return ReverseMapped;
            }
            case 2048: {
                return JsxAttributes;
            }
            case 4096: {
                return JSLiteral;
            }
            case 8192: {
                return FreshLiteral;
            }
            case 16384: {
                return ArrayLiteral;
            }
            case 32768: {
                return PrimitiveUnion;
            }
            case 65536: {
                return ContainsWideningType;
            }
            case 131072: {
                return ContainsObjectOrArrayLiteral;
            }
            case 262144: {
                return NonInferrableType;
            }
            case 524288: {
                return CouldContainTypeVariablesComputed;
            }
            case 0x100000: {
                return CouldContainTypeVariables;
            }
            case 3: {
                return ClassOrInterface;
            }
            case 196608: {
                return RequiresWidening;
            }
            case 458752: {
                return PropagatingFlags;
            }
            case 1343: {
                return ObjectTypeKindMask;
            }
            case 0x200000: {
                return ContainsSpread;
            }
            case 0x400000: {
                return ObjectRestType;
            }
            case 0x800000: {
                return InstantiationExpressionType;
            }
            case 0x1000000: {
                return IsClassInstanceClone;
            }
            case 0x2000000: {
                return IdenticalBaseTypeCalculated;
            }
            case 0x4000000: {
                return IdenticalBaseTypeExists;
            }
            case 0xC00000: {
                return IsGenericType;
            }
        }
        throw new IllegalArgumentException("unknown TSCObjectFlag code: " + code);
    }

    public boolean matches(int bitfield) {
        return (bitfield & this.code) != 0;
    }

    public static int union(TSCObjectFlag ... args) {
        int result = 0;
        for (TSCObjectFlag arg : args) {
            result |= arg.code;
        }
        return result;
    }
}

