/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JsContainer;
import org.openrewrite.javascript.tree.JsLeftPadded;
import org.openrewrite.javascript.tree.JsRightPadded;
import org.openrewrite.javascript.tree.JsSpace;
import org.openrewrite.marker.Markers;

public class JavaScriptVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof JS.CompilationUnit;
    }

    public String getLanguage() {
        return "javascript";
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("JS has a different structure for its compilation unit. See JS.CompilationUnit.");
    }

    public J visitCompilationUnit(JS.CompilationUnit cu, P p) {
        JS.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.withStatements(ListUtils.map(c.getStatements(), e -> (Statement)this.visitAndCast((Tree)e, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitAlias(JS.Alias alias, P p) {
        JS.Alias a = alias;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.ALIAS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.Alias)) {
            return temp;
        }
        a = (JS.Alias)temp;
        a = a.getPadding().withPropertyName(this.visitRightPadded(a.getPadding().getPropertyName(), JsRightPadded.Location.ALIAS_PROPERTY_NAME, p));
        a = a.withAlias((J.Identifier)this.visitAndCast((Tree)a.getAlias(), p));
        return a;
    }

    public J visitArrowFunction(JS.ArrowFunction arrowFunction, P p) {
        JS.ArrowFunction a = arrowFunction;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.ARROW_FUNCTION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.ArrowFunction)) {
            return temp;
        }
        a = (JS.ArrowFunction)temp;
        a = a.withLeadingAnnotations(ListUtils.map(a.getLeadingAnnotations(), ann -> (J.Annotation)this.visitAndCast((Tree)ann, p)));
        a = a.withModifiers(ListUtils.map(a.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))));
        a = a.withModifiers(ListUtils.map(a.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p)));
        a = a.withParameters(a.getParameters().withPrefix(this.visitSpace(a.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p)));
        a = a.withParameters(a.getParameters().getPadding().withParams(ListUtils.map((List)a.getParameters().getPadding().getParams(), param -> this.visitRightPadded((JRightPadded)param, JRightPadded.Location.LAMBDA_PARAM, p))));
        a = a.withParameters((J.Lambda.Parameters)this.visitAndCast((Tree)a.getParameters(), p));
        a = a.withReturnTypeExpression((TypeTree)this.visitAndCast((Tree)a.getReturnTypeExpression(), p));
        a = a.withArrow(this.visitSpace(a.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p));
        a = a.withBody((J)this.visitAndCast((Tree)a.getBody(), p));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitAwait(JS.Await await, P p) {
        JS.Await a = await;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.AWAIT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.Await)) {
            return temp;
        }
        a = (JS.Await)temp;
        a = a.withExpression((Expression)this.visitAndCast((Tree)a.getExpression(), p));
        return a;
    }

    public J visitBinding(JS.ObjectBindingDeclarations.Binding binding, P p) {
        JS.ObjectBindingDeclarations.Binding b = binding;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), JsSpace.Location.BINDING_PREFIX, p));
        b = b.withMarkers(this.visitMarkers(b.getMarkers(), p));
        b = b.withPropertyName((J.Identifier)this.visitAndCast((Tree)b.getPropertyName(), p));
        b = b.withName((J.Identifier)this.visitAndCast((Tree)b.getName(), p));
        if ((b = b.withDimensionsAfterName(ListUtils.map(b.getDimensionsAfterName(), dim -> dim.withBefore(this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, p)).withElement((Object)this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p))))).getPadding().getInitializer() != null) {
            b = b.getPadding().withInitializer(this.visitLeftPadded(b.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_INITIALIZER, p));
        }
        b = b.withVariableType((JavaType.Variable)this.visitType((JavaType)b.getVariableType(), p));
        return b;
    }

    public J visitDefaultType(JS.DefaultType defaultType, P p) {
        JS.DefaultType d = defaultType;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.ASSIGNMENT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof JS.DefaultType)) {
            return temp;
        }
        d = (JS.DefaultType)temp;
        d = d.withLeft((Expression)this.visitAndCast((Tree)d.getLeft(), p));
        d = d.withBeforeEquals(this.visitSpace(d.getBeforeEquals(), Space.Location.ASSIGNMENT_OPERATION_PREFIX, p));
        d = d.withRight((Expression)this.visitAndCast((Tree)d.getRight(), p));
        d = d.withType(this.visitType(d.getType(), p));
        return d;
    }

    public J visitDelete(JS.Delete delete, P p) {
        JS.Delete d = delete;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), JsSpace.Location.DELETE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof JS.Delete)) {
            return temp;
        }
        d = (JS.Delete)temp;
        d = d.withType(this.visitType(d.getType(), p));
        return d;
    }

    public J visitExport(JS.Export export, P p) {
        JS.Export e = export;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), JsSpace.Location.EXPORT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(e = e.withMarkers(this.visitMarkers(e.getMarkers(), p)), p);
        if (!(temp instanceof JS.Export)) {
            return temp;
        }
        e = (JS.Export)temp;
        if (e.getPadding().getExports() != null) {
            e = e.getPadding().withExports(this.visitContainer(e.getPadding().getExports(), JsContainer.Location.EXPORT_ELEMENT, p));
        }
        if (e.getFrom() != null) {
            e = e.withFrom(this.visitSpace(e.getFrom(), JsSpace.Location.EXPORT_FROM_PREFIX, p));
        }
        if ((e = e.withTarget((J.Literal)this.visitAndCast((Tree)e.getTarget(), p))).getPadding().getInitializer() != null) {
            e = e.getPadding().withInitializer(this.visitLeftPadded(e.getPadding().getInitializer(), JsLeftPadded.Location.EXPORT_INITIALIZER, p));
        }
        return e;
    }

    public J visitExpressionStatement(JS.ExpressionStatement statement, P p) {
        JS.ExpressionStatement es = statement;
        Statement temp = (Statement)this.visitStatement(es = (JS.ExpressionStatement)es.withMarkers(this.visitMarkers(es.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExpressionStatement)) {
            return temp;
        }
        es = (JS.ExpressionStatement)temp;
        J expression = (J)this.visit((Tree)es.getExpression(), p);
        if (expression instanceof Statement) {
            return expression;
        }
        es = es.withExpression((Expression)expression);
        return es;
    }

    public J visitFunctionType(JS.FunctionType functionType, P p) {
        JS.FunctionType f = functionType;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), JsSpace.Location.FUNCTION_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof JS.FunctionType)) {
            return temp;
        }
        f = (JS.FunctionType)temp;
        f = f.getPadding().withParameters((JContainer<Statement>)this.visitContainer(f.getPadding().getParameters(), JContainer.Location.LANGUAGE_EXTENSION, p));
        f = f.withParameters(ListUtils.map(f.getParameters(), e -> (Statement)this.visitAndCast((Tree)e, p)));
        f = f.withArrow(this.visitSpace(f.getArrow(), JsSpace.Location.FUNCTION_TYPE_ARROW_PREFIX, p));
        f = f.withReturnType((Expression)this.visitAndCast((Tree)f.getReturnType(), p));
        f = f.withType(this.visitType(f.getType(), p));
        return f;
    }

    public J visitJsBinary(JS.JsBinary binary, P p) {
        JS.JsBinary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), JsSpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof JS.JsBinary)) {
            return temp;
        }
        b = (JS.JsBinary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), JsLeftPadded.Location.BINARY_OPERATOR, p));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), p));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public J visitJsImport(JS.JsImport jsImport, P p) {
        JS.JsImport i = jsImport;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), JsSpace.Location.IMPORT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(i = i.withMarkers(this.visitMarkers(i.getMarkers(), p)), p);
        if (!(temp instanceof JS.JsImport)) {
            return temp;
        }
        i = (JS.JsImport)temp;
        this.visit((Tree)i.getName(), p);
        if (i.getPadding().getImports() != null) {
            i = i.getPadding().withImports(this.visitContainer(i.getPadding().getImports(), JsContainer.Location.IMPORT_ELEMENT, p));
        }
        if (i.getFrom() != null) {
            i = i.withFrom(this.visitSpace(i.getFrom(), JsSpace.Location.IMPORT_FROM_PREFIX, p));
        }
        if ((i = i.withTarget((J.Literal)this.visitAndCast((Tree)i.getTarget(), p))).getPadding().getInitializer() != null) {
            i = i.getPadding().withInitializer(this.visitLeftPadded(i.getPadding().getInitializer(), JsLeftPadded.Location.IMPORT_INITIALIZER, p));
        }
        return i;
    }

    public J visitObjectBindingDeclarations(JS.ObjectBindingDeclarations objectBindingDeclarations, P p) {
        JS.ObjectBindingDeclarations o = objectBindingDeclarations;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), JsSpace.Location.OBJECT_BINDING_DECLARATIONS_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(o = o.withMarkers(this.visitMarkers(o.getMarkers(), p)), p);
        if (!(temp instanceof JS.ObjectBindingDeclarations)) {
            return temp;
        }
        o = (JS.ObjectBindingDeclarations)temp;
        o = o.withLeadingAnnotations(ListUtils.map(o.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        o = o.withModifiers(ListUtils.map(o.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))));
        o = o.withModifiers(Objects.requireNonNull(ListUtils.map(o.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        o = o.withTypeExpression((o = o.withTypeExpression((TypeTree)this.visitAndCast((Tree)o.getTypeExpression(), p))).getTypeExpression() == null ? null : this.visitTypeName(o.getTypeExpression(), p));
        if ((o = o.getPadding().withBindings(this.visitContainer(o.getPadding().getBindings(), JsContainer.Location.BINDING_ELEMENT, p))).getPadding().getInitializer() != null) {
            o = o.getPadding().withInitializer(this.visitLeftPadded(o.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_INITIALIZER, p));
        }
        return o;
    }

    public J visitPropertyAssignment(JS.PropertyAssignment propertyAssignment, P p) {
        JS.PropertyAssignment pa = propertyAssignment;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), JsSpace.Location.PROPERTY_ASSIGNMENT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), p)), p);
        if (!(temp instanceof JS.PropertyAssignment)) {
            return temp;
        }
        pa = (JS.PropertyAssignment)temp;
        pa = pa.getPadding().withName(this.visitRightPadded(pa.getPadding().getName(), JsRightPadded.Location.PROPERTY_ASSIGNMENT_NAME, p));
        pa = pa.withInitializer((Expression)this.visitAndCast((Tree)pa.getInitializer(), p));
        return pa;
    }

    public J visitScopedVariableDeclarations(JS.ScopedVariableDeclarations scopedVariableDeclarations, P p) {
        JS.ScopedVariableDeclarations vd = scopedVariableDeclarations;
        vd = vd.withPrefix(this.visitSpace(vd.getPrefix(), JsSpace.Location.SCOPED_VARIABLE_DECLARATIONS_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(vd = vd.withMarkers(this.visitMarkers(vd.getMarkers(), p)), p);
        if (!(temp instanceof JS.ScopedVariableDeclarations)) {
            return temp;
        }
        vd = (JS.ScopedVariableDeclarations)temp;
        vd = vd.getPadding().withVariables(ListUtils.map(vd.getPadding().getVariables(), e -> this.visitRightPadded((JRightPadded)e, JsRightPadded.Location.SCOPED_VARIABLE_DECLARATIONS_VARIABLE, p)));
        return vd;
    }

    public J visitStatementExpression(JS.StatementExpression expression, P p) {
        JS.StatementExpression se = expression;
        Expression temp = (Expression)this.visitExpression(se, p);
        if (!(temp instanceof JS.StatementExpression)) {
            return temp;
        }
        se = (JS.StatementExpression)temp;
        J statement = (J)this.visit((Tree)se.getStatement(), p);
        if (statement instanceof Expression) {
            return statement;
        }
        se = se.withStatement((Statement)statement);
        return se;
    }

    public J visitTemplateExpression(JS.TemplateExpression templateExpression, P p) {
        JS.TemplateExpression s = templateExpression;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), JsSpace.Location.TEMPLATE_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(s = s.withMarkers(this.visitMarkers(s.getMarkers(), p)), p);
        if (!(temp instanceof JS.TemplateExpression)) {
            return temp;
        }
        s = (JS.TemplateExpression)temp;
        s = s.getPadding().withTag(this.visitRightPadded(s.getPadding().getTag(), JsRightPadded.Location.ALIAS_PROPERTY_NAME, p));
        s = s.withStrings(ListUtils.map(s.getStrings(), e -> (J)this.visitAndCast((Tree)e, p)));
        s = s.withType(this.visitType(s.getType(), p));
        return s;
    }

    public J visitTemplateExpressionValue(JS.TemplateExpression.Value value, P p) {
        JS.TemplateExpression.Value s = value;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), JsSpace.Location.TEMPLATE_EXPRESSION_VALUE_PREFIX, p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        s = s.withTree((J)this.visit((Tree)s.getTree(), p));
        s = s.withAfter(this.visitSpace(s.getAfter(), JsSpace.Location.TEMPLATE_EXPRESSION_VALUE_SUFFIX, p));
        return s;
    }

    public J visitTuple(JS.Tuple tuple, P p) {
        JS.Tuple t = tuple;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TUPLE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.Tuple)) {
            return temp;
        }
        t = (JS.Tuple)temp;
        t = t.getPadding().withElements(this.visitContainer(t.getPadding().getElements(), JsContainer.Location.TUPLE_ELEMENT, p));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitTypeDeclaration(JS.TypeDeclaration typeDeclaration, P p) {
        JS.TypeDeclaration t = typeDeclaration;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeDeclaration)) {
            return temp;
        }
        t = (JS.TypeDeclaration)temp;
        t = t.withLeadingAnnotations(ListUtils.map(t.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        t = t.withModifiers(ListUtils.map(t.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))));
        t = t.withModifiers(Objects.requireNonNull(ListUtils.map(t.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        t = t.withName((J.Identifier)this.visitAndCast((Tree)t.getName(), p));
        t = t.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)t.getTypeParameters(), p));
        t = t.getPadding().withInitializer(this.visitLeftPadded(t.getPadding().getInitializer(), JsLeftPadded.Location.TYPE_DECLARATION_INITIALIZER, p));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitTypeOperator(JS.TypeOperator typeOperator, P p) {
        JS.TypeOperator t = typeOperator;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_OPERATOR_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeOperator)) {
            return temp;
        }
        t = (JS.TypeOperator)temp;
        t = t.getPadding().withExpression(this.visitLeftPadded(t.getPadding().getExpression(), JsLeftPadded.Location.TYPE_OPERATOR, p));
        return t;
    }

    public J visitUnary(JS.Unary unary, P p) {
        JS.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNARY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof JS.Unary)) {
            return temp;
        }
        u = (JS.Unary)temp;
        Expression temp2 = (Expression)this.visitExpression(u, p);
        if (!(temp2 instanceof JS.Unary)) {
            return temp2;
        }
        u = (JS.Unary)temp2;
        u = u.getPadding().withOperator((JLeftPadded<JS.Unary.Type>)this.visitLeftPadded(u.getPadding().getOperator(), JLeftPadded.Location.UNARY_OPERATOR, p));
        u = u.withExpression((Expression)this.visitAndCast((Tree)u.getExpression(), p));
        u = u.withType(this.visitType(u.getType(), p));
        return u;
    }

    public J visitUnion(JS.Union union, P p) {
        JS.Union u = union;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), JsSpace.Location.UNION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof JS.Union)) {
            return temp;
        }
        u = (JS.Union)temp;
        u = u.getPadding().withTypes(ListUtils.map(u.getPadding().getTypes(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.UNION_TYPE, p)));
        u = u.withType(this.visitType(u.getType(), p));
        return u;
    }

    public J visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        J.AnnotatedType a = annotatedType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression((Expression)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p))), p);
        if (!(temp instanceof J.AnnotatedType)) {
            return temp;
        }
        a = (J.AnnotatedType)temp;
        a = a.withAnnotations(ListUtils.map((List)a.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p)));
        a = a.withTypeExpression((TypeTree)this.visitAndCast((Tree)a.getTypeExpression(), p));
        a = a.withTypeExpression(this.visitTypeName(a.getTypeExpression(), p));
        return a;
    }

    public J visitParameterizedType(J.ParameterizedType type, P p) {
        J.ParameterizedType pt = type;
        pt = pt.withPrefix(this.visitSpace(pt.getPrefix(), Space.Location.PARAMETERIZED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression((Expression)(pt = pt.withMarkers(this.visitMarkers(pt.getMarkers(), p))), p);
        if (!(temp instanceof J.ParameterizedType)) {
            return temp;
        }
        pt = (J.ParameterizedType)temp;
        if ((pt = pt.withClazz((NameTree)this.visitAndCast((Tree)pt.getClazz(), p))).getPadding().getTypeParameters() != null) {
            pt = pt.getPadding().withTypeParameters(this.visitContainer(pt.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        pt = pt.getPadding().withTypeParameters(this.visitTypeNames(pt.getPadding().getTypeParameters(), p));
        pt = pt.withType(this.visitType(pt.getType(), p));
        return pt;
    }

    public <N extends NameTree> N visitTypeName(N nameTree, P p) {
        return nameTree;
    }

    private <N extends NameTree> @Nullable JLeftPadded<N> visitTypeName(@Nullable JLeftPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement((Object)this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    private <N extends NameTree> @Nullable JRightPadded<N> visitTypeName(@Nullable JRightPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement((Object)this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    private <J2 extends J> @Nullable JContainer<J2> visitTypeNames(@Nullable JContainer<J2> nameTrees, P p) {
        if (nameTrees == null) {
            return null;
        }
        List js = ListUtils.map((List)nameTrees.getPadding().getElements(), t -> t.getElement() instanceof NameTree ? this.visitTypeName((JRightPadded)t, p) : t);
        return js == nameTrees.getPadding().getElements() ? nameTrees : JContainer.build((Space)nameTrees.getBefore(), (List)js, (Markers)Markers.EMPTY);
    }

    public Space visitSpace(Space space, JsSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JsRightPadded.Location loc, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, JsLeftPadded.Location loc, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, JsContainer.Location loc, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }

    public J visitTypeOf(JS.TypeOf typeOf, P p) {
        JS.TypeOf t = typeOf;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPEOF_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeOf)) {
            return temp;
        }
        t = (JS.TypeOf)temp;
        t = t.withExpression((Expression)this.visitAndCast((Tree)t.getExpression(), p));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitVoid(JS.Void aVoid, P p) {
        JS.Void v = aVoid;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), JsSpace.Location.VOID_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(v = v.withMarkers(this.visitMarkers(v.getMarkers(), p)), p);
        if (!(temp instanceof JS.Void)) {
            return temp;
        }
        v = (JS.Void)temp;
        v = v.withExpression((Expression)this.visitAndCast((Tree)v.getExpression(), p));
        return v;
    }

    public J visitYield(JS.Yield yield, P p) {
        JS.Yield y = yield;
        y = y.withPrefix(this.visitSpace(y.getPrefix(), JsSpace.Location.YIELD_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(y = y.withMarkers(this.visitMarkers(y.getMarkers(), p)), p);
        if (!(temp instanceof JS.Yield)) {
            return temp;
        }
        y = (JS.Yield)temp;
        y = y.withExpression((Expression)this.visitAndCast((Tree)y.getExpression(), p));
        return y;
    }

    public J visitTypeInfo(JS.TypeInfo typeInfo, P p) {
        JS.TypeInfo ti = typeInfo;
        ti = ti.withPrefix(this.visitSpace(ti.getPrefix(), JsSpace.Location.YIELD_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ti = ti.withMarkers(this.visitMarkers(ti.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeInfo)) {
            return temp;
        }
        ti = (JS.TypeInfo)temp;
        ti = ti.withTypeIdentifier((TypeTree)this.visitAndCast((Tree)ti.getTypeIdentifier(), p));
        return ti;
    }

    public J visitJSVariableDeclarations(JS.JSVariableDeclarations multiVariable, P p) {
        JS.JSVariableDeclarations m = multiVariable.withPrefix(this.visitSpace(multiVariable.getPrefix(), JsSpace.Location.JSVARIABLE_DECLARATIONS_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof J.VariableDeclarations)) {
            return temp;
        }
        m = (JS.JSVariableDeclarations)temp;
        m = m.withLeadingAnnotations(ListUtils.map(m.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        m = m.withModifiers(Objects.requireNonNull(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        m = m.withTypeExpression((m = m.withTypeExpression((TypeTree)this.visitAndCast((Tree)m.getTypeExpression(), p))).getTypeExpression() == null ? null : this.visitTypeName(m.getTypeExpression(), p));
        m = m.withVarargs(m.getVarargs() == null ? null : this.visitSpace(m.getVarargs(), Space.Location.VARARGS, p));
        m = m.getPadding().withVariables(ListUtils.map(m.getPadding().getVariables(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.JSNAMED_VARIABLE, p)));
        return m;
    }

    public J visitJSVariableDeclarationsJSNamedVariable(JS.JSVariableDeclarations.JSNamedVariable variable, P p) {
        JS.JSVariableDeclarations.JSNamedVariable v = variable.withPrefix(this.visitSpace(variable.getPrefix(), JsSpace.Location.JSVARIABLE_PREFIX, p));
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), p));
        v = v.withName((Expression)this.visitAndCast((Tree)v.getName(), p));
        if ((v = v.withDimensionsAfterName(ListUtils.map(v.getDimensionsAfterName(), dim -> dim.withBefore(this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, p)).withElement((Object)this.visitSpace((Space)dim.getElement(), Space.Location.DIMENSION, p))))).getPadding().getInitializer() != null) {
            v = v.getPadding().withInitializer(this.visitLeftPadded(v.getPadding().getInitializer(), JsLeftPadded.Location.JSVARIABLE_INITIALIZER, p));
        }
        v = v.withVariableType((JavaType.Variable)this.visitType((JavaType)v.getVariableType(), p));
        return v;
    }

    public J visitJSMethodDeclaration(JS.JSMethodDeclaration method, P p) {
        JS.JSMethodDeclaration m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof JS.JSMethodDeclaration)) {
            return temp;
        }
        m = (JS.JSMethodDeclaration)temp;
        m = m.withLeadingAnnotations(ListUtils.map(m.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        m = m.withModifiers(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p)));
        m = m.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)m.getTypeParameters(), p));
        m = m.withReturnTypeExpression((m = m.withReturnTypeExpression((TypeTree)this.visitAndCast((Tree)m.getReturnTypeExpression(), p))).getReturnTypeExpression() == null ? null : this.visitTypeName(m.getReturnTypeExpression(), p));
        m = m.withName((Expression)this.visitAndCast((Tree)m.getName(), p));
        if ((m = m.getPadding().withParameters((JContainer<Statement>)this.visitContainer(m.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, p))).getPadding().getThrowz() != null) {
            m = m.getPadding().withThrowz((JContainer<NameTree>)this.visitContainer(m.getPadding().getThrowz(), JContainer.Location.THROWS, p));
        }
        m = m.getPadding().withThrowz(this.visitTypeNames(m.getPadding().getThrowz(), p));
        if ((m = m.withBody((J.Block)this.visitAndCast((Tree)m.getBody(), p))).getPadding().getDefaultValue() != null) {
            m = m.getPadding().withDefaultValue((JLeftPadded<Expression>)this.visitLeftPadded(m.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, p));
        }
        m = m.withMethodType((JavaType.Method)this.visitType((JavaType)m.getMethodType(), p));
        return m;
    }

    public J visitNamespaceDeclaration(JS.NamespaceDeclaration namespaceDeclaration, P p) {
        JS.NamespaceDeclaration ns = namespaceDeclaration;
        ns = ns.withPrefix(this.visitSpace(ns.getPrefix(), JsSpace.Location.JSNAMESPACE_DECLARATION_PREFIX, p));
        ns = ns.withMarkers(this.visitMarkers(ns.getMarkers(), p));
        ns = ns.withModifiers(ListUtils.map(ns.getModifiers(), mod -> mod.withPrefix(this.visitSpace(mod.getPrefix(), Space.Location.MODIFIER_PREFIX, p))));
        Statement temp = (Statement)this.visitStatement(ns = ns.withModifiers(ListUtils.map(ns.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p))), p);
        if (!(temp instanceof JS.NamespaceDeclaration)) {
            return temp;
        }
        ns = (JS.NamespaceDeclaration)temp;
        ns = ns.withNamespace(this.visitSpace(ns.getNamespace(), JsSpace.Location.JSNAMESPACE_KEYWORD_DECLARATION_PREFIX, p));
        ns = ns.getPadding().withName(this.visitRightPadded(ns.getPadding().getName(), JsRightPadded.Location.NAMESPACE_DECLARATION_NAME, p));
        ns = ns.withBody((J.Block)this.visitAndCast((Tree)ns.getBody(), p));
        return ns;
    }
}

