/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal;

import java.util.List;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.markers.Asterisk;
import org.openrewrite.javascript.markers.Braces;
import org.openrewrite.javascript.markers.Comma;
import org.openrewrite.javascript.markers.ForLoopType;
import org.openrewrite.javascript.markers.FunctionKeyword;
import org.openrewrite.javascript.markers.Keyword;
import org.openrewrite.javascript.markers.OmitDot;
import org.openrewrite.javascript.markers.PostFixOperator;
import org.openrewrite.javascript.markers.TypeReferencePrefix;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JsContainer;
import org.openrewrite.javascript.tree.JsLeftPadded;
import org.openrewrite.javascript.tree.JsRightPadded;
import org.openrewrite.javascript.tree.JsSpace;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JavaScriptPrinter<P>
extends JavaScriptVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> JAVA_SCRIPT_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";
    private final JavaScriptJavaPrinter delegate = new JavaScriptJavaPrinter();

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof JS)) {
            return this.delegate.visit(tree, p);
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J visitCompilationUnit(JS.CompilationUnit cu, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visitRightPadded(cu.getPadding().getStatements(), JRightPadded.Location.LANGUAGE_EXTENSION, "", p);
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        this.afterSyntax(cu, p);
        return cu;
    }

    @Override
    public J visitAlias(JS.Alias alias, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)alias, JsSpace.Location.ALIAS_PREFIX, p);
        this.visitRightPadded(alias.getPadding().getPropertyName(), JsRightPadded.Location.ALIAS_PROPERTY_NAME, p);
        p.append("as");
        this.visit((Tree)alias.getAlias(), p);
        this.afterSyntax(alias, p);
        return alias;
    }

    @Override
    public J visitArrowFunction(JS.ArrowFunction arrowFunction, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)arrowFunction, JsSpace.Location.ARROW_FUNCTION_PREFIX, p);
        this.visit(arrowFunction.getLeadingAnnotations(), p);
        arrowFunction.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        if (arrowFunction.getParameters().isParenthesized()) {
            this.visitSpace(arrowFunction.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
            p.append('(');
            this.visitRightPadded((List<JRightPadded<J>>)arrowFunction.getParameters().getPadding().getParams(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
            p.append(')');
        } else {
            this.visitRightPadded((List<JRightPadded<J>>)arrowFunction.getParameters().getPadding().getParams(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
        }
        if (arrowFunction.getReturnTypeExpression() != null) {
            TypeReferencePrefix typeReferencePrefix = arrowFunction.getMarkers().findFirst(TypeReferencePrefix.class).orElse(null);
            if (typeReferencePrefix != null) {
                this.visitSpace(typeReferencePrefix.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                p.append(":");
            }
            this.visit((Tree)arrowFunction.getReturnTypeExpression(), p);
        }
        this.visitSpace(arrowFunction.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
        p.append("=>");
        this.visit((Tree)arrowFunction.getBody(), p);
        this.afterSyntax(arrowFunction, p);
        return arrowFunction;
    }

    @Override
    public J visitAwait(JS.Await await, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)await, JsSpace.Location.AWAIT_PREFIX, p);
        p.append("await");
        this.visit((Tree)await.getExpression(), p);
        this.afterSyntax(await, p);
        return await;
    }

    @Override
    public J visitBinding(JS.ObjectBindingDeclarations.Binding binding, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)binding, JsSpace.Location.BINDING_PREFIX, p);
        if (binding.getAfterVararg() != null) {
            p.append("...");
            this.visitSpace(binding.getAfterVararg(), Space.Location.VARARGS, p);
        }
        if (binding.getPropertyName() != null) {
            this.visitRightPadded(binding.getPadding().getPropertyName(), JsRightPadded.Location.BINDING_PROPERTY_NAME_SUFFIX, p);
            p.append(":");
        }
        this.visit((Tree)binding.getName(), p);
        for (JLeftPadded<Space> dimension : binding.getDimensionsAfterName()) {
            this.visitSpace(dimension.getBefore(), Space.Location.DIMENSION_PREFIX, p);
            p.append('[');
            this.visitSpace((Space)dimension.getElement(), Space.Location.DIMENSION, p);
            p.append(']');
        }
        this.visitLeftPadded("=", binding.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_INITIALIZER, p);
        this.afterSyntax(binding, p);
        return binding;
    }

    @Override
    public J visitDefaultType(JS.DefaultType defaultType, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)defaultType, JsSpace.Location.DEFAULT_TYPE_PREFIX, p);
        this.visit((Tree)defaultType.getLeft(), p);
        this.visitSpace(defaultType.getBeforeEquals(), Space.Location.ASSIGNMENT_OPERATION_PREFIX, p);
        p.append("=");
        this.visit((Tree)defaultType.getRight(), p);
        this.afterSyntax(defaultType, p);
        return defaultType;
    }

    @Override
    public J visitDelete(JS.Delete delete, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)delete, JsSpace.Location.DELETE_PREFIX, p);
        p.append("delete");
        this.visit((Tree)delete.getExpression(), p);
        this.afterSyntax(delete, p);
        return delete;
    }

    @Override
    public J visitExport(JS.Export export, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)export, JsSpace.Location.EXPORT_PREFIX, p);
        p.append("export");
        boolean printBrackets = export.getPadding().getExports() != null && export.getPadding().getExports().getMarkers().findFirst(Braces.class).isPresent();
        this.visitContainer(printBrackets ? "{" : "", export.getPadding().getExports(), JsContainer.Location.FUNCTION_TYPE_PARAMETER, ",", printBrackets ? "}" : "", p);
        if (export.getFrom() != null) {
            this.visitSpace(export.getFrom(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("from");
        }
        this.visit((Tree)export.getTarget(), p);
        this.visitLeftPadded("default", export.getPadding().getInitializer(), JsLeftPadded.Location.IMPORT_INITIALIZER, p);
        this.afterSyntax(export, p);
        return export;
    }

    @Override
    public J visitFunctionType(JS.FunctionType functionType, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)functionType, JsSpace.Location.FUNCTION_TYPE_PREFIX, p);
        this.visitContainer("(", functionType.getPadding().getParameters(), JsContainer.Location.FUNCTION_TYPE_PARAMETER, ",", ")", p);
        this.visitSpace(functionType.getArrow(), JsSpace.Location.FUNCTION_TYPE_ARROW_PREFIX, p);
        p.append("=>");
        this.visit((Tree)functionType.getReturnType(), p);
        this.afterSyntax(functionType, p);
        return functionType;
    }

    @Override
    public J visitJsImport(JS.JsImport jsImport, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)jsImport, JsSpace.Location.EXPORT_PREFIX, p);
        p.append("import");
        JS.JsImport.Padding padding = jsImport.getPadding();
        this.visitRightPadded(padding.getName(), JsRightPadded.Location.IMPORT_NAME_SUFFIX, p);
        if (jsImport.getName() != null && padding.getImports() != null) {
            p.append(",");
        }
        boolean braces = padding.getImports() != null && padding.getImports().getPadding().getElements().stream().noneMatch(e -> e.getElement() instanceof JS.Alias);
        this.visitContainer(braces ? "{" : "", padding.getImports(), JsContainer.Location.IMPORT_ELEMENT, ",", braces ? "}" : "", p);
        if (jsImport.getFrom() != null) {
            this.visitSpace(jsImport.getFrom(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("from");
        }
        this.visit((Tree)jsImport.getTarget(), p);
        this.visitLeftPadded("=", padding.getInitializer(), JsLeftPadded.Location.IMPORT_INITIALIZER, p);
        this.afterSyntax(jsImport, p);
        return jsImport;
    }

    @Override
    public J visitJsBinary(JS.JsBinary binary, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)binary, JsSpace.Location.BINARY_PREFIX, p);
        this.visit((Tree)binary.getLeft(), p);
        String keyword = "";
        switch (binary.getOperator()) {
            case As: {
                keyword = "as";
                break;
            }
            case IdentityEquals: {
                keyword = "===";
                break;
            }
            case IdentityNotEquals: {
                keyword = "!==";
                break;
            }
            case In: {
                keyword = "in";
            }
        }
        this.visitSpace(binary.getPadding().getOperator().getBefore(), JsSpace.Location.BINARY_PREFIX, p);
        p.append(keyword);
        this.visit((Tree)binary.getRight(), p);
        this.afterSyntax(binary, p);
        return binary;
    }

    @Override
    public J visitPropertyAssignment(JS.PropertyAssignment propertyAssignment, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)propertyAssignment, JsSpace.Location.PROPERTY_ASSIGNMENT_PREFIX, p);
        this.visitRightPadded(propertyAssignment.getPadding().getName(), JsRightPadded.Location.PROPERTY_ASSIGNMENT_NAME, p);
        p.append(':');
        this.visit((Tree)propertyAssignment.getInitializer(), p);
        this.afterSyntax(propertyAssignment, p);
        return propertyAssignment;
    }

    @Override
    public J visitObjectBindingDeclarations(JS.ObjectBindingDeclarations objectBindingDeclarations, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)objectBindingDeclarations, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
        this.visit(objectBindingDeclarations.getLeadingAnnotations(), p);
        objectBindingDeclarations.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        this.visit((Tree)objectBindingDeclarations.getTypeExpression(), p);
        this.visitContainer("{", objectBindingDeclarations.getPadding().getBindings(), JsContainer.Location.BINDING_ELEMENT, ",", "}", p);
        this.visitLeftPadded("=", objectBindingDeclarations.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_INITIALIZER, p);
        this.afterSyntax(objectBindingDeclarations, p);
        return objectBindingDeclarations;
    }

    @Override
    public J visitTemplateExpression(JS.TemplateExpression templateExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)templateExpression, JsSpace.Location.TEMPLATE_EXPRESSION_PREFIX, p);
        String delimiter = templateExpression.getDelimiter();
        this.visitRightPadded(templateExpression.getPadding().getTag(), JsRightPadded.Location.TAG, p);
        PostFixOperator postFixOperator = templateExpression.getMarkers().findFirst(PostFixOperator.class).orElse(null);
        if (postFixOperator != null) {
            this.visitSpace(postFixOperator.getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
            p.append(postFixOperator.getOperator().getValue());
        }
        p.append(delimiter);
        this.visit(templateExpression.getStrings(), p);
        p.append(delimiter);
        this.afterSyntax(templateExpression, p);
        return templateExpression;
    }

    @Override
    public J visitTemplateExpressionValue(JS.TemplateExpression.Value value, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)value, JsSpace.Location.TEMPLATE_EXPRESSION_VALUE_PREFIX, p);
        if (value.isEnclosedInBraces()) {
            p.append("${");
        } else {
            p.append("$");
        }
        this.visit((Tree)value.getTree(), p);
        this.visitSpace(value.getAfter(), JsSpace.Location.TEMPLATE_EXPRESSION_VALUE_SUFFIX, p);
        if (value.isEnclosedInBraces()) {
            p.append('}');
        }
        this.afterSyntax(value, p);
        return value;
    }

    @Override
    public J visitTuple(JS.Tuple tuple, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)tuple, JsSpace.Location.TUPLE_PREFIX, p);
        this.visitContainer("[", tuple.getPadding().getElements(), JsContainer.Location.TUPLE_ELEMENT, ",", "]", p);
        this.afterSyntax(tuple, p);
        return tuple;
    }

    @Override
    public J visitTypeDeclaration(JS.TypeDeclaration typeDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeDeclaration, JsSpace.Location.TYPE_DECLARATION_PREFIX, p);
        this.visit(typeDeclaration.getLeadingAnnotations(), p);
        typeDeclaration.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        this.visit((Tree)typeDeclaration.getName(), p);
        J.TypeParameters typeParameters = typeDeclaration.getTypeParameters();
        if (typeParameters != null) {
            this.visit(typeParameters.getAnnotations(), p);
            this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
            this.visitMarkers(typeParameters.getMarkers(), p);
            p.append("<");
            this.visitRightPadded((List<JRightPadded<J>>)typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
            p.append(">");
        }
        this.visitLeftPadded("=", typeDeclaration.getPadding().getInitializer(), JsLeftPadded.Location.TYPE_DECLARATION_INITIALIZER, p);
        this.afterSyntax(typeDeclaration, p);
        return typeDeclaration;
    }

    @Override
    public J visitTypeOf(JS.TypeOf typeOf, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeOf, JsSpace.Location.TYPEOF_PREFIX, p);
        p.append("typeof");
        this.visit((Tree)typeOf.getExpression(), p);
        this.afterSyntax(typeOf, p);
        return typeOf;
    }

    @Override
    public J visitTypeOperator(JS.TypeOperator typeOperator, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeOperator, JsSpace.Location.TYPE_OPERATOR_PREFIX, p);
        String keyword = "";
        if (typeOperator.getOperator() == JS.TypeOperator.Type.ReadOnly) {
            keyword = "readonly";
        } else if (typeOperator.getOperator() == JS.TypeOperator.Type.KeyOf) {
            keyword = "keyof";
        }
        p.append(keyword);
        this.visitLeftPadded(typeOperator.getPadding().getExpression(), JsLeftPadded.Location.TYPE_OPERATOR, p);
        this.afterSyntax(typeOperator, p);
        return typeOperator;
    }

    @Override
    public J visitUnary(JS.Unary unary, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)unary, Space.Location.UNARY_PREFIX, p);
        switch (unary.getOperator()) {
            case Spread: {
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                p.append("...");
                this.visit((Tree)unary.getExpression(), p);
                break;
            }
        }
        this.afterSyntax(unary, p);
        return unary;
    }

    @Override
    public J visitUnion(JS.Union union, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)union, JsSpace.Location.UNION_PREFIX, p);
        this.visitRightPadded(union.getPadding().getTypes(), JsRightPadded.Location.UNION_TYPE, "|", p);
        this.afterSyntax(union, p);
        return union;
    }

    @Override
    public J visitVoid(JS.Void aVoid, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)aVoid, JsSpace.Location.VOID_PREFIX, p);
        p.append("void");
        this.visit((Tree)aVoid.getExpression(), p);
        this.afterSyntax(aVoid, p);
        return aVoid;
    }

    protected void beforeSyntax(J j, JsSpace.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable JsSpace.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
    }

    protected void beforeSyntax(J j, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
    }

    protected void afterSyntax(J j, PrintOutputCapture<P> p) {
        this.afterSyntax(j.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
    }

    protected void visitContainer(String before, @Nullable JContainer<? extends J> container, JsContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded((List<JRightPadded<J>>)container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.append(after == null ? "" : after);
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JsLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit((Tree)leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit((Tree)leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JsRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    @Override
    public Space visitSpace(Space space, JsSpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, loc, p);
    }

    public Markers visitMarkers(@Nullable Markers markers, PrintOutputCapture<P> pPrintOutputCapture) {
        return this.delegate.visitMarkers(markers, pPrintOutputCapture);
    }

    private class JavaScriptJavaPrinter
    extends JavaPrinter<P> {
        private JavaScriptJavaPrinter() {
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof JS) {
                return JavaScriptPrinter.this.visit(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public J visitAnnotation(J.Annotation annotation, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)annotation, Space.Location.ANNOTATION_PREFIX, p);
            if (!annotation.getMarkers().findFirst(Keyword.class).isPresent()) {
                p.append("@");
            }
            this.visit((Tree)annotation.getAnnotationType(), p);
            this.visitContainer("(", annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)annotation, p);
            return annotation;
        }

        public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
            String keyword = "";
            switch (binary.getOperator()) {
                case Addition: {
                    keyword = "+";
                    break;
                }
                case Subtraction: {
                    keyword = "-";
                    break;
                }
                case Multiplication: {
                    keyword = "*";
                    break;
                }
                case Division: {
                    keyword = "/";
                    break;
                }
                case Modulo: {
                    keyword = "%";
                    break;
                }
                case LessThan: {
                    keyword = "<";
                    break;
                }
                case GreaterThan: {
                    keyword = ">";
                    break;
                }
                case LessThanOrEqual: {
                    keyword = "<=";
                    break;
                }
                case GreaterThanOrEqual: {
                    keyword = ">=";
                    break;
                }
                case Equal: {
                    keyword = "==";
                    break;
                }
                case NotEqual: {
                    keyword = "!=";
                    break;
                }
                case BitAnd: {
                    keyword = "&";
                    break;
                }
                case BitOr: {
                    keyword = "|";
                    break;
                }
                case BitXor: {
                    keyword = "^";
                    break;
                }
                case LeftShift: {
                    keyword = "<<";
                    break;
                }
                case RightShift: {
                    keyword = ">>";
                    break;
                }
                case UnsignedRightShift: {
                    keyword = ">>>";
                    break;
                }
                case Or: {
                    keyword = binary.getMarkers().findFirst(Comma.class).isPresent() ? "," : "||";
                    break;
                }
                case And: {
                    keyword = "&&";
                }
            }
            this.beforeSyntax((J)binary, Space.Location.BINARY_PREFIX, p);
            this.visit((Tree)binary.getLeft(), p);
            this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
            p.append(keyword);
            this.visit((Tree)binary.getRight(), p);
            this.afterSyntax((J)binary, p);
            return binary;
        }

        public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)fieldAccess, Space.Location.FIELD_ACCESS_PREFIX, p);
            this.visit((Tree)fieldAccess.getTarget(), p);
            PostFixOperator postFixOperator = fieldAccess.getMarkers().findFirst(PostFixOperator.class).orElse(null);
            this.visitLeftPadded(postFixOperator != null ? "?." : ".", fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
            this.afterSyntax((J)fieldAccess, p);
            return fieldAccess;
        }

        public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
            p.append("for");
            J.ForEachLoop.Control ctrl = forEachLoop.getControl();
            this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
            p.append('(');
            ForLoopType forLoopType = forEachLoop.getMarkers().findFirst(ForLoopType.class).orElse(null);
            String suffix = forLoopType == null ? ":" : forLoopType.getKeyword().getWord();
            this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, suffix, p);
            this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
            p.append(')');
            this.visitStatement((JRightPadded<Statement>)forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
            this.afterSyntax((J)forEachLoop, p);
            return forEachLoop;
        }

        public J visitImport(J.Import import_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)import_, Space.Location.IMPORT_PREFIX, p);
            p.append("import");
            this.visit((Tree)import_.getAlias(), p);
            this.visitSpace(import_.getQualid().getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("from");
            this.visitLeftPadded(import_.getQualid().getPadding().getName(), JLeftPadded.Location.LANGUAGE_EXTENSION, p);
            this.afterSyntax((J)import_, p);
            return import_;
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
            Asterisk asterisk;
            this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(method.getLeadingAnnotations(), p);
            method.getModifiers().forEach(it -> this.visitModifier((J.Modifier)it, p));
            FunctionKeyword functionKeyword = method.getMarkers().findFirst(FunctionKeyword.class).orElse(null);
            if (functionKeyword != null) {
                this.visitSpace(functionKeyword.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                p.append("function");
            }
            if ((asterisk = (Asterisk)method.getMarkers().findFirst(Asterisk.class).orElse(null)) != null) {
                this.visitSpace(asterisk.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                p.append("*");
            }
            this.visit((Tree)method.getName(), p);
            J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
            if (typeParameters != null) {
                this.visit(typeParameters.getAnnotations(), p);
                this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
                this.visitMarkers(typeParameters.getMarkers(), p);
                p.append("<");
                this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
                p.append(">");
            }
            this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
            if (method.getReturnTypeExpression() != null) {
                TypeReferencePrefix typeReferencePrefix = method.getMarkers().findFirst(TypeReferencePrefix.class).orElse(null);
                if (typeReferencePrefix != null) {
                    this.visitSpace(typeReferencePrefix.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                    p.append(":");
                }
                this.visit((Tree)method.getReturnTypeExpression(), p);
            }
            this.visit((Tree)method.getBody(), p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            String suffix = method.getMarkers().findFirst(OmitDot.class).isPresent() ? "" : ".";
            this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, suffix, p);
            this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visit((Tree)method.getName(), p);
            this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public void visitModifier(J.Modifier mod, PrintOutputCapture<P> p) {
            String keyword;
            this.visit(mod.getAnnotations(), p);
            switch (mod.getType()) {
                case Default: {
                    keyword = "default";
                    break;
                }
                case Public: {
                    keyword = "public";
                    break;
                }
                case Protected: {
                    keyword = "protected";
                    break;
                }
                case Private: {
                    keyword = "private";
                    break;
                }
                case Abstract: {
                    keyword = "abstract";
                    break;
                }
                case Async: {
                    keyword = "async";
                    break;
                }
                case Static: {
                    keyword = "static";
                    break;
                }
                case Final: {
                    keyword = "final";
                    break;
                }
                case Native: {
                    keyword = "native";
                    break;
                }
                case NonSealed: {
                    keyword = "non-sealed";
                    break;
                }
                case Sealed: {
                    keyword = "sealed";
                    break;
                }
                case Strictfp: {
                    keyword = "strictfp";
                    break;
                }
                case Synchronized: {
                    keyword = "synchronized";
                    break;
                }
                case Transient: {
                    keyword = "transient";
                    break;
                }
                case Volatile: {
                    keyword = "volatile";
                    break;
                }
                default: {
                    keyword = mod.getKeyword();
                }
            }
            this.beforeSyntax((J)mod, Space.Location.MODIFIER_PREFIX, p);
            p.append(keyword);
            this.afterSyntax((J)mod, p);
        }

        public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)newArray, Space.Location.NEW_ARRAY_PREFIX, p);
            this.visit((Tree)newArray.getTypeExpression(), p);
            this.visit(newArray.getDimensions(), p);
            this.visitContainer("[", newArray.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, ",", "]", p);
            this.afterSyntax((J)newArray, p);
            return newArray;
        }

        public J visitNewClass(J.NewClass newClass, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)newClass, Space.Location.NEW_CLASS_PREFIX, p);
            this.visitRightPadded(newClass.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, ".", p);
            this.visitSpace(newClass.getNew(), Space.Location.NEW_PREFIX, p);
            if (newClass.getClazz() != null) {
                p.append("new");
                this.visit((Tree)newClass.getClazz(), p);
                this.visitContainer("(", newClass.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, ",", ")", p);
            }
            this.visit((Tree)newClass.getBody(), p);
            this.afterSyntax((J)newClass, p);
            return newClass;
        }

        public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)controlParens, Space.Location.CONTROL_PARENTHESES_PREFIX, p);
            if (this.getCursor().getParentTreeCursor().getValue() instanceof J.TypeCast) {
                p.append('<');
                this.visitRightPadded(controlParens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, ">", p);
            } else {
                p.append('(');
                this.visitRightPadded(controlParens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, ")", p);
            }
            this.afterSyntax((J)controlParens, p);
            return controlParens;
        }

        protected void visitStatements(List<JRightPadded<Statement>> statements, JRightPadded.Location location, PrintOutputCapture<P> p) {
            boolean objectLiteral = this.getCursor().getParent(0).getValue() instanceof J.Block && this.getCursor().getParent(1).getValue() instanceof J.NewClass;
            for (int i = 0; i < statements.size(); ++i) {
                JRightPadded<Statement> paddedStat = statements.get(i);
                this.visitStatement(paddedStat, location, p);
                if (i >= statements.size() - 1 || !objectLiteral) continue;
                p.append(',');
            }
        }

        public J visitTypeCast(J.TypeCast typeCast, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)typeCast, Space.Location.TYPE_CAST_PREFIX, p);
            this.visit((Tree)typeCast.getClazz(), p);
            this.visit((Tree)typeCast.getExpression(), p);
            this.afterSyntax((J)typeCast, p);
            return typeCast;
        }

        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
            boolean objectLiteral = this.getCursor().getParent(1).getValue() instanceof J.Block && this.getCursor().getParent(2).getValue() instanceof J.NewClass;
            this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visit(multiVariable.getLeadingAnnotations(), p);
            multiVariable.getModifiers().forEach(it -> this.visitModifier((J.Modifier)it, p));
            List variables = multiVariable.getPadding().getVariables();
            for (int i = 0; i < variables.size(); ++i) {
                JRightPadded variable = (JRightPadded)variables.get(i);
                this.beforeSyntax((J)variable.getElement(), Space.Location.VARIABLE_PREFIX, p);
                if (multiVariable.getVarargs() != null) {
                    p.append("...");
                }
                this.visit((Tree)((J.VariableDeclarations.NamedVariable)variable.getElement()).getName(), p);
                PostFixOperator postFixOperator = multiVariable.getMarkers().findFirst(PostFixOperator.class).orElse(null);
                if (postFixOperator != null) {
                    this.visitSpace(postFixOperator.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                    p.append(postFixOperator.getOperator().getValue());
                }
                if (multiVariable.getTypeExpression() != null) {
                    multiVariable.getMarkers().findFirst(TypeReferencePrefix.class).ifPresent(typeReferencePrefix -> this.visitSpace(typeReferencePrefix.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p));
                    p.append(":");
                    this.visit((Tree)multiVariable.getTypeExpression(), p);
                }
                if (((J.VariableDeclarations.NamedVariable)variable.getElement()).getInitializer() != null) {
                    JavaScriptPrinter.this.visitLeftPadded(objectLiteral ? ":" : "=", (JLeftPadded<J>)((J.VariableDeclarations.NamedVariable)variable.getElement()).getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p);
                }
                this.visitSpace(variable.getAfter(), Space.Location.NAMED_VARIABLE_SUFFIX, p);
                this.afterSyntax((J)variable.getElement(), p);
                if (i < variables.size() - 1) {
                    p.append(",");
                    continue;
                }
                if (!variable.getMarkers().findFirst(Semicolon.class).isPresent()) continue;
                p.append(";");
            }
            this.afterSyntax((J)multiVariable, p);
            return multiVariable;
        }

        public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)variable, Space.Location.VARIABLE_PREFIX, p);
            this.visit((Tree)variable.getName(), p);
            this.afterSyntax((J)variable, p);
            return variable;
        }

        public J visitYield(J.Yield yield, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)yield, Space.Location.YIELD_PREFIX, p);
            p.append("yield");
            Asterisk asterisk = yield.getMarkers().findFirst(Asterisk.class).orElse(null);
            if (asterisk != null) {
                this.visitSpace(asterisk.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
                p.append("*");
            }
            this.visit((Tree)yield.getValue(), p);
            this.afterSyntax((J)yield, p);
            return yield;
        }

        protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
            if (paddedStat != null) {
                this.visit((Tree)paddedStat.getElement(), p);
                this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
                this.visitMarkers(paddedStat.getMarkers(), p);
            }
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof TrailingComma) {
                p.append(",");
                this.visitSpace(((TrailingComma)marker).getSuffix(), Space.Location.LANGUAGE_EXTENSION, p);
            } else if (marker instanceof Semicolon) {
                p.append(';');
            }
            return (M)super.visitMarker(marker, p);
        }
    }
}

