/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.javascript.internal.tsc.TSCGlobals;
import org.openrewrite.javascript.internal.tsc.TSCInstanceOfChecks;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCNodeList;
import org.openrewrite.javascript.internal.tsc.TSCObjectCache;
import org.openrewrite.javascript.internal.tsc.TSCSignature;
import org.openrewrite.javascript.internal.tsc.TSCSymbol;
import org.openrewrite.javascript.internal.tsc.TSCType;
import org.openrewrite.javascript.internal.tsc.TSCTypeChecker;
import org.openrewrite.javascript.internal.tsc.TSCV8ValueHolder;

public class TSCProgramContext
extends TSCV8ValueHolder {
    private final V8ValueObject program;
    private final V8ValueFunction createScanner;
    private final V8ValueFunction getOpenRewriteId;
    private final Path compilerAppPath;
    private final Path compilerLibPath;
    private final TSCGlobals typescriptGlobals;
    private final TSCTypeChecker typeChecker;
    private final TSCInstanceOfChecks instanceOfChecks;
    final TSCObjectCache<TSCNode> nodeCache = this.lifecycleLinked(TSCObjectCache.usingInternalKey(TSCNode::wrap));
    final TSCObjectCache<TSCNodeList> nodeListCache = this.lifecycleLinked(TSCObjectCache.usingInternalKey(TSCNodeList::wrap));
    final TSCObjectCache<TSCType> typeCache = this.lifecycleLinked(TSCObjectCache.usingPropertyAsKey("id", TSCType::new));
    final TSCObjectCache<TSCSymbol> symbolCache = this.lifecycleLinked(TSCObjectCache.usingInternalKey(TSCSymbol::new));
    final TSCObjectCache<TSCSignature> signatureCache = this.lifecycleLinked(TSCObjectCache.usingInternalKey(TSCSignature::new));

    public TSCProgramContext(V8ValueObject program, V8ValueObject tsGlobalsV8, V8ValueObject typeCheckerV8, V8ValueFunction createScanner, V8ValueFunction getOpenRewriteId, Path compilerAppPath, Path compilerLibPath) {
        this.program = this.lifecycleLinked(program);
        this.typescriptGlobals = this.lifecycleLinked(TSCGlobals.fromJS(() -> this, tsGlobalsV8));
        this.typeChecker = this.lifecycleLinked(TSCTypeChecker.fromJS(() -> this, typeCheckerV8));
        this.instanceOfChecks = this.lifecycleLinked(TSCInstanceOfChecks.fromJS(tsGlobalsV8));
        this.createScanner = this.lifecycleLinked(createScanner);
        this.getOpenRewriteId = this.lifecycleLinked(getOpenRewriteId);
        this.compilerAppPath = compilerAppPath;
        this.compilerLibPath = compilerLibPath;
    }

    /*
     * Exception decompiling
     */
    public static TSCProgramContext fromJS(V8ValueObject contextV8) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 35[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getInternalObjectId(V8ValueObject objectV8) {
        try {
            return this.getOpenRewriteId.callLong(null, new Object[]{objectV8});
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public TSCGlobals getTypeScriptGlobals() {
        return this.typescriptGlobals;
    }

    @Nullable
    public TSCInstanceOfChecks.InterfaceKind identifyInterfaceKind(V8Value valueV8) {
        return this.getInstanceOfChecks().identifyInterfaceKind(valueV8);
    }

    @Nullable
    public TSCInstanceOfChecks.ConstructorKind identifyConstructorKind(V8Value valueV8) {
        return this.getInstanceOfChecks().identifyConstructorKind(valueV8);
    }

    public V8ValueFunction getCreateScannerFunction() {
        return this.createScanner;
    }

    public TSCType tscType(V8ValueObject v8Value) {
        return this.typeCache.getOrCreate(this, v8Value);
    }

    public TSCNode tscNode(V8ValueObject v8Value) {
        return this.nodeCache.getOrCreate(this, v8Value);
    }

    public TSCNodeList tscNodeList(V8ValueObject v8Value) {
        return this.nodeListCache.getOrCreate(this, v8Value);
    }

    public TSCSymbol tscSymbol(V8ValueObject v8Value) {
        return this.symbolCache.getOrCreate(this, v8Value);
    }

    public TSCSignature tscSignature(V8ValueObject v8Value) {
        return this.signatureCache.getOrCreate(this, v8Value);
    }

    protected CompilerBridgeSourceInfo getBridgeSourceInfo(TSCNode.SourceFile sourceFile) {
        CompilerBridgeSourceKind sourceKind;
        Path sourceKindRoot;
        Path rawPath = Paths.get(sourceFile.getOriginalFileName(), new String[0]);
        if (rawPath.startsWith(this.compilerAppPath)) {
            sourceKindRoot = this.compilerAppPath;
            sourceKind = CompilerBridgeSourceKind.ApplicationCode;
        } else if (rawPath.startsWith(this.compilerLibPath)) {
            sourceKindRoot = this.compilerLibPath;
            sourceKind = CompilerBridgeSourceKind.SystemLibrary;
        } else {
            throw new IllegalArgumentException("unknown bridge source path (expected app or lib): " + rawPath);
        }
        return new CompilerBridgeSourceInfo(sourceKind, sourceKindRoot.relativize(rawPath));
    }

    @Generated
    public TSCTypeChecker getTypeChecker() {
        return this.typeChecker;
    }

    @Generated
    public TSCInstanceOfChecks getInstanceOfChecks() {
        return this.instanceOfChecks;
    }

    public static enum CompilerBridgeSourceKind {
        ApplicationCode,
        SystemLibrary;

    }

    public static final class CompilerBridgeSourceInfo {
        private final CompilerBridgeSourceKind sourceKind;
        private final Path relativePath;

        @Generated
        public CompilerBridgeSourceInfo(CompilerBridgeSourceKind sourceKind, Path relativePath) {
            this.sourceKind = sourceKind;
            this.relativePath = relativePath;
        }

        @Generated
        public CompilerBridgeSourceKind getSourceKind() {
            return this.sourceKind;
        }

        @Generated
        public Path getRelativePath() {
            return this.relativePath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilerBridgeSourceInfo)) {
                return false;
            }
            CompilerBridgeSourceInfo other = (CompilerBridgeSourceInfo)o;
            CompilerBridgeSourceKind this$sourceKind = this.getSourceKind();
            CompilerBridgeSourceKind other$sourceKind = other.getSourceKind();
            if (this$sourceKind == null ? other$sourceKind != null : !((Object)((Object)this$sourceKind)).equals((Object)other$sourceKind)) {
                return false;
            }
            Path this$relativePath = this.getRelativePath();
            Path other$relativePath = other.getRelativePath();
            return !(this$relativePath == null ? other$relativePath != null : !((Object)this$relativePath).equals(other$relativePath));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompilerBridgeSourceKind $sourceKind = this.getSourceKind();
            result = result * 59 + ($sourceKind == null ? 43 : ((Object)((Object)$sourceKind)).hashCode());
            Path $relativePath = this.getRelativePath();
            result = result * 59 + ($relativePath == null ? 43 : ((Object)$relativePath).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TSCProgramContext.CompilerBridgeSourceInfo(sourceKind=" + (Object)((Object)this.getSourceKind()) + ", relativePath=" + this.getRelativePath() + ")";
        }
    }
}

