/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import lombok.Generated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.service.SourcePositionService;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.LineWrapSetting;

public final class WrapMethodInvocationArguments<P>
extends JavaIsoVisitor<P> {
    private final WrappingAndBracesStyle style;

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P ctx) {
        J m = super.visitMethodInvocation(method, (Object)ctx);
        try {
            if (this.style != null && this.style.getMethodCallArguments() != null && this.style.getMethodCallArguments().getWrap() != LineWrapSetting.DoNotWrap) {
                if (((J.MethodInvocation)m).getArguments().size() <= 1) {
                    return m;
                }
                JavaSourceFile sourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                if (this.style.getMethodCallArguments().getWrap() == LineWrapSetting.ChopIfTooLong) {
                    if (sourceFile == null) {
                        return m;
                    }
                    if (((SourcePositionService)sourceFile.service(SourcePositionService.class)).positionOf(this.getCursor(), method).getMaxColumn() <= this.style.getHardWrapAt()) {
                        return m;
                    }
                }
                if (this.style.getMethodCallArguments().getCloseNewLine().booleanValue()) {
                    m = ((J.MethodInvocation)m).getPadding().withArguments(((J.MethodInvocation)m).getPadding().getArguments().getPadding().withElements(ListUtils.mapLast(((J.MethodInvocation)m).getPadding().getArguments().getPadding().getElements(), rightPaddedParam -> {
                        Space after = rightPaddedParam.getAfter();
                        if (after.getLastWhitespace().contains("\n")) {
                            return rightPaddedParam;
                        }
                        after = after.getComments().isEmpty() ? after.withWhitespace("\n") : after.withComments(ListUtils.mapLast(after.getComments(), comment -> comment.withSuffix("\n")));
                        return rightPaddedParam.withAfter(after);
                    })));
                }
                m = ((J.MethodInvocation)m).withArguments(ListUtils.map(((J.MethodInvocation)m).getArguments(), (paramIndex, param) -> {
                    if (param instanceof J.Empty) {
                        return param;
                    }
                    Space prefix = param.getPrefix();
                    if (prefix.getComments().isEmpty()) {
                        if ((paramIndex != 0 || this.style.getMethodCallArguments().getOpenNewLine().booleanValue()) && !prefix.getWhitespace().contains("\n")) {
                            prefix = prefix.withWhitespace("\n");
                        }
                    } else {
                        int index = -1;
                        for (int i = prefix.getComments().size() - 1; i >= 0; --i) {
                            if (!prefix.getComments().get(i).getSuffix().contains("\n")) continue;
                            index = i;
                            break;
                        }
                        if (index == -1 && (paramIndex != 0 || this.style.getMethodCallArguments().getOpenNewLine().booleanValue())) {
                            if (prefix.getComments().isEmpty()) {
                                if (!prefix.getWhitespace().contains("\n")) {
                                    prefix = prefix.withWhitespace("\n");
                                }
                            } else {
                                prefix = prefix.withComments(ListUtils.mapLast(prefix.getComments(), comment -> comment.withSuffix("\n")));
                            }
                        }
                    }
                    return (Expression)param.withPrefix(prefix);
                }));
            }
        }
        catch (NoSuchFieldError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
        return m;
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P ctx) {
        J n = super.visitNewClass(newClass, (Object)ctx);
        try {
            if (this.style != null && this.style.getMethodCallArguments() != null && this.style.getMethodCallArguments().getWrap() != LineWrapSetting.DoNotWrap) {
                if (((J.NewClass)n).getArguments() == null || ((J.NewClass)n).getArguments().size() <= 1) {
                    return n;
                }
                JavaSourceFile sourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                if (this.style.getMethodCallArguments().getWrap() == LineWrapSetting.ChopIfTooLong) {
                    if (sourceFile == null) {
                        return n;
                    }
                    if (((SourcePositionService)sourceFile.service(SourcePositionService.class)).positionOf(this.getCursor(), newClass).getMaxColumn() <= this.style.getHardWrapAt()) {
                        return n;
                    }
                }
                if (this.style.getMethodCallArguments().getCloseNewLine().booleanValue()) {
                    n = ((J.NewClass)n).getPadding().withArguments(((J.NewClass)n).getPadding().getArguments().getPadding().withElements(ListUtils.mapLast(((J.NewClass)n).getPadding().getArguments().getPadding().getElements(), rightPaddedParam -> {
                        Space after = rightPaddedParam.getAfter();
                        if (after.getLastWhitespace().contains("\n")) {
                            return rightPaddedParam;
                        }
                        after = after.getComments().isEmpty() ? after.withWhitespace("\n") : after.withComments(ListUtils.mapLast(after.getComments(), comment -> comment.withSuffix("\n")));
                        return rightPaddedParam.withAfter(after);
                    })));
                }
                n = ((J.NewClass)n).withArguments(ListUtils.map(((J.NewClass)n).getArguments(), (paramIndex, param) -> {
                    if (param instanceof J.Empty) {
                        return param;
                    }
                    Space prefix = param.getPrefix();
                    if (prefix.getComments().isEmpty()) {
                        if ((paramIndex != 0 || this.style.getMethodCallArguments().getOpenNewLine().booleanValue()) && !prefix.getWhitespace().contains("\n")) {
                            prefix = prefix.withWhitespace("\n");
                        }
                    } else {
                        int index = -1;
                        for (int i = prefix.getComments().size() - 1; i >= 0; --i) {
                            if (!prefix.getComments().get(i).getSuffix().contains("\n")) continue;
                            index = i;
                            break;
                        }
                        if (index == -1 && (paramIndex != 0 || this.style.getMethodCallArguments().getOpenNewLine().booleanValue())) {
                            if (prefix.getComments().isEmpty()) {
                                if (!prefix.getWhitespace().contains("\n")) {
                                    prefix = prefix.withWhitespace("\n");
                                }
                            } else {
                                prefix = prefix.withComments(ListUtils.mapLast(prefix.getComments(), comment -> comment.withSuffix("\n")));
                            }
                        }
                    }
                    return (Expression)param.withPrefix(prefix);
                }));
            }
        }
        catch (NoSuchFieldError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
        return n;
    }

    @Generated
    public WrapMethodInvocationArguments(WrappingAndBracesStyle style) {
        this.style = style;
    }

    @Generated
    public WrappingAndBracesStyle getStyle() {
        return this.style;
    }

    @NonNull
    @Generated
    public String toString() {
        return "WrapMethodInvocationArguments(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrapMethodInvocationArguments)) {
            return false;
        }
        WrapMethodInvocationArguments other = (WrapMethodInvocationArguments)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WrappingAndBracesStyle this$style = this.getStyle();
        WrappingAndBracesStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)this$style).equals(other$style));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof WrapMethodInvocationArguments;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WrappingAndBracesStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        return result;
    }
}

