/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceFileWithReferences;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.TypeNameMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.table.TypeUses;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.trait.Reference;
import org.openrewrite.trait.Trait;

public final class FindTypes
extends Recipe {
    private final transient TypeUses typeUses = new TypeUses(this);
    @Option(displayName="Fully-qualified type name", description="A fully-qualified type name, that is used to find matching type references. Supports glob expressions. `java..*` finds every type from every subpackage of the `java` package.", example="java.util.List")
    private final String fullyQualifiedTypeName;
    @Option(displayName="Check for assignability", description="When enabled, find type references that are assignable to the provided type.", required=false)
    private final @Nullable Boolean checkAssignability;

    public String getDisplayName() {
        return "Find types";
    }

    public String getDescription() {
        return "Find type references by name.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TypeNameMatcher fullyQualifiedType = TypeNameMatcher.fromPattern(this.fullyQualifiedTypeName);
        return Preconditions.check(new UsesType(this.fullyQualifiedTypeName, false), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile instanceof JavaSourceFile || sourceFile instanceof SourceFileWithReferences;
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    return new JavaSourceFileVisitor(fullyQualifiedType).visit(tree, ctx);
                }
                if (tree instanceof SourceFileWithReferences) {
                    SourceFileWithReferences sourceFile = (SourceFileWithReferences)tree;
                    SourceFileWithReferences.References references = sourceFile.getReferences();
                    TypeMatcher matcher = new TypeMatcher(FindTypes.this.fullyQualifiedTypeName);
                    Set<Tree> matches = references.findMatches((Reference.Matcher)matcher).stream().map(Trait::getTree).collect(Collectors.toSet());
                    return new ReferenceVisitor(matches).visit(tree, ctx);
                }
                return tree;
            }
        });
    }

    public static Set<NameTree> findAssignable(J j, String fullyQualifiedClassName) {
        return FindTypes.find(true, j, fullyQualifiedClassName);
    }

    public static Set<NameTree> find(J j, String fullyQualifiedClassName) {
        return FindTypes.find(false, j, fullyQualifiedClassName);
    }

    private static Set<NameTree> find(final boolean checkAssignability, J j, String fullyQualifiedClassName) {
        final TypeNameMatcher fullyQualifiedType = TypeNameMatcher.fromPattern(fullyQualifiedClassName);
        JavaIsoVisitor<Set<NameTree>> findVisitor = new JavaIsoVisitor<Set<NameTree>>(){

            @Override
            public J.Identifier visitIdentifier(J.Identifier ident, Set<NameTree> ns) {
                JavaType.FullyQualified type;
                if (ident.getType() != null && FindTypes.typeMatches(checkAssignability, fullyQualifiedType, type = TypeUtils.asFullyQualified(ident.getType())) && ident.getSimpleName().equals(type.getClassName())) {
                    ns.add(ident);
                }
                return super.visitIdentifier(ident, ns);
            }

            @Override
            public <N extends NameTree> N visitTypeName(N name, Set<NameTree> ns) {
                N n = super.visitTypeName(name, ns);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(n.getType());
                if (FindTypes.typeMatches(checkAssignability, fullyQualifiedType, type) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                    ns.add(name);
                }
                return n;
            }

            @Override
            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, Set<NameTree> ns) {
                J fa = super.visitFieldAccess(fieldAccess, ns);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(((J.FieldAccess)fa).getTarget().getType());
                if (FindTypes.typeMatches(checkAssignability, fullyQualifiedType, type) && "class".equals(((J.FieldAccess)fa).getName().getSimpleName())) {
                    ns.add(fieldAccess);
                }
                return fa;
            }
        };
        HashSet<NameTree> ts = new HashSet<NameTree>();
        findVisitor.visit(j, ts);
        return ts;
    }

    private static boolean typeMatches(boolean checkAssignability, TypeNameMatcher matcher,  @Nullable JavaType.FullyQualified test) {
        if (test == null) {
            return false;
        }
        if (checkAssignability) {
            return test.isAssignableFrom(matcher);
        }
        return matcher.matches(test.getFullyQualifiedName());
    }

    @Generated
    public FindTypes(String fullyQualifiedTypeName, @Nullable Boolean checkAssignability) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
        this.checkAssignability = checkAssignability;
    }

    @Generated
    public TypeUses getTypeUses() {
        return this.typeUses;
    }

    @Generated
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @Generated
    public @Nullable Boolean getCheckAssignability() {
        return this.checkAssignability;
    }

    @org.openrewrite.internal.lang.NonNull
    @Generated
    public String toString() {
        return "FindTypes(typeUses=" + (Object)((Object)this.getTypeUses()) + ", fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ", checkAssignability=" + this.getCheckAssignability() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTypes)) {
            return false;
        }
        FindTypes other = (FindTypes)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$checkAssignability = this.getCheckAssignability();
        Boolean other$checkAssignability = other.getCheckAssignability();
        if (this$checkAssignability == null ? other$checkAssignability != null : !((Object)this$checkAssignability).equals(other$checkAssignability)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        return !(this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindTypes;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $checkAssignability = this.getCheckAssignability();
        result = result * 59 + ($checkAssignability == null ? 43 : ((Object)$checkAssignability).hashCode());
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        return result;
    }

    private class JavaSourceFileVisitor
    extends JavaVisitor<ExecutionContext> {
        private final TypeNameMatcher fullyQualifiedType;

        public JavaSourceFileVisitor(TypeNameMatcher fullyQualifiedType) {
            this.fullyQualifiedType = fullyQualifiedType;
        }

        @Override
        public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
            if (ident.getType() != null && this.getCursor().firstEnclosing(J.Import.class) == null && this.getCursor().firstEnclosing(J.FieldAccess.class) == null && !(this.getCursor().getParentOrThrow().getValue() instanceof J.ParameterizedType) && !(this.getCursor().getParentOrThrow().getValue() instanceof J.ArrayType)) {
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(ident.getType());
                if (FindTypes.typeMatches(Boolean.TRUE.equals(FindTypes.this.checkAssignability), this.fullyQualifiedType, type) && ident.getSimpleName().equals(type.getClassName())) {
                    return this.found(ident, ctx);
                }
            }
            return super.visitIdentifier(ident, ctx);
        }

        @Override
        public <N extends NameTree> N visitTypeName(N name, ExecutionContext ctx) {
            N n = super.visitTypeName(name, ctx);
            JavaType.FullyQualified type = TypeUtils.asFullyQualified(n.getType());
            if (FindTypes.typeMatches(Boolean.TRUE.equals(FindTypes.this.checkAssignability), this.fullyQualifiedType, type) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                return this.found(n, ctx);
            }
            return n;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            J.FieldAccess fa = (J.FieldAccess)super.visitFieldAccess(fieldAccess, ctx);
            JavaType.FullyQualified type = TypeUtils.asFullyQualified(fa.getTarget().getType());
            if (FindTypes.typeMatches(Boolean.TRUE.equals(FindTypes.this.checkAssignability), this.fullyQualifiedType, type) && "class".equals(fa.getName().getSimpleName())) {
                return this.found(fa, ctx);
            }
            return fa;
        }

        private <J2 extends TypedTree> J2 found(J2 j, ExecutionContext ctx) {
            JavaType.FullyQualified fqn = TypeUtils.asFullyQualified(j.getType());
            if (!j.getMarkers().findFirst(SearchResult.class).isPresent()) {
                FindTypes.this.typeUses.insertRow(ctx, new TypeUses.Row(((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), j.printTrimmed(this.getCursor().getParentTreeCursor()), fqn == null ? j.getType().toString() : fqn.getFullyQualifiedName()));
            }
            return (J2)((TypedTree)SearchResult.found(j));
        }
    }

    private static final class ReferenceVisitor
    extends TreeVisitor<Tree, ExecutionContext> {
        private final Set<Tree> matches;

        public Tree postVisit(@NonNull Tree tree, ExecutionContext ctx) {
            return this.matches.contains(tree) ? SearchResult.found((Tree)tree) : tree;
        }

        @Generated
        public ReferenceVisitor(Set<Tree> matches) {
            this.matches = matches;
        }

        @Generated
        public Set<Tree> getMatches() {
            return this.matches;
        }

        @org.openrewrite.internal.lang.NonNull
        @Generated
        public String toString() {
            return "FindTypes.ReferenceVisitor(matches=" + this.getMatches() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReferenceVisitor)) {
                return false;
            }
            ReferenceVisitor other = (ReferenceVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Set<Tree> this$matches = this.getMatches();
            Set<Tree> other$matches = other.getMatches();
            return !(this$matches == null ? other$matches != null : !((Object)this$matches).equals(other$matches));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof ReferenceVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Tree> $matches = this.getMatches();
            result = result * 59 + ($matches == null ? 43 : ((Object)$matches).hashCode());
            return result;
        }
    }
}

