/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public final class AddCommentToImport
extends Recipe {
    @Option(displayName="Comment", description="The comment to add.", example="This is a comment.")
    private final String comment;
    @Option(displayName="Type pattern", description="A type pattern that is used to find matching imports uses.", example="org.springframework..*")
    private final String typePattern;

    public String getDisplayName() {
        return "Add comment to import statement";
    }

    public String getDescription() {
        return "Add a comment to an import statement in a Java source file.";
    }

    public String getInstanceNameSuffix() {
        return "matching `" + this.typePattern + "`";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TypeMatcher typeMatcher = new TypeMatcher(this.typePattern);
        return new JavaIsoVisitor<ExecutionContext>(){
            private boolean foundImport = false;

            @Override
            public J.Import visitImport(J.Import anImport, ExecutionContext ctx) {
                if (this.foundImport) {
                    return anImport;
                }
                if (typeMatcher.matchesPackage(anImport.getTypeName())) {
                    String formattedCommentText;
                    this.foundImport = true;
                    String prefixWhitespace = anImport.getPrefix().getWhitespace();
                    Matcher newlineMatcher = Pattern.compile("\\R").matcher(AddCommentToImport.this.comment.trim());
                    String newCommentText = AddCommentToImport.this.comment.trim().replaceAll("\\R", prefixWhitespace + " * ").replace("*/", "*");
                    String string = formattedCommentText = newlineMatcher.find() ? System.lineSeparator() + " * " + newCommentText + System.lineSeparator() + " " : " " + newCommentText + " ";
                    if (this.doesNotHaveComment(formattedCommentText, anImport.getComments())) {
                        TextComment textComment = new TextComment(true, formattedCommentText, prefixWhitespace, Markers.EMPTY);
                        return this.autoFormat((J.Import)anImport.withComments(ListUtils.concat(anImport.getComments(), (Object)textComment)), ctx);
                    }
                }
                return super.visitImport(anImport, ctx);
            }

            private boolean doesNotHaveComment(String lookFor, List<Comment> comments) {
                for (Comment c : comments) {
                    if (!(c instanceof TextComment) || !lookFor.trim().equals(((TextComment)c).getText().trim())) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Generated
    public AddCommentToImport(String comment, String typePattern) {
        this.comment = comment;
        this.typePattern = typePattern;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getTypePattern() {
        return this.typePattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddCommentToImport(comment=" + this.getComment() + ", typePattern=" + this.getTypePattern() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCommentToImport)) {
            return false;
        }
        AddCommentToImport other = (AddCommentToImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$typePattern = this.getTypePattern();
        String other$typePattern = other.getTypePattern();
        return !(this$typePattern == null ? other$typePattern != null : !this$typePattern.equals(other$typePattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddCommentToImport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $typePattern = this.getTypePattern();
        result = result * 59 + ($typePattern == null ? 43 : $typePattern.hashCode());
        return result;
    }
}

