/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public class UsesMethod<P>
extends JavaIsoVisitor<P> {
    private final MethodMatcher methodMatcher;

    public UsesMethod(String methodPattern) {
        this(new MethodMatcher(methodPattern));
    }

    public UsesMethod(String methodPattern, boolean matchOverrides) {
        this(new MethodMatcher(methodPattern, matchOverrides));
    }

    public UsesMethod(String methodPattern, @Nullable Boolean matchOverrides) {
        this(new MethodMatcher(methodPattern, Boolean.TRUE.equals(matchOverrides)));
    }

    public UsesMethod(MethodMatcher methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            for (JavaType.Method type : cu.getTypesInUse().getUsedMethods()) {
                if (!this.methodMatcher.matches(type)) continue;
                return (J)SearchResult.found((Tree)cu);
            }
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        if (this.methodMatcher.matches(method)) {
            return (J.MethodInvocation)SearchResult.found((Tree)method);
        }
        return super.visitMethodInvocation(method, (Object)p);
    }

    @Override
    public J.MemberReference visitMemberReference(J.MemberReference memberRef, P p) {
        if (this.methodMatcher.matches(memberRef)) {
            return (J.MemberReference)SearchResult.found((Tree)memberRef);
        }
        return super.visitMemberReference(memberRef, (Object)p);
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        if (this.methodMatcher.matches(newClass)) {
            return (J.NewClass)SearchResult.found((Tree)newClass);
        }
        return super.visitNewClass(newClass, (Object)p);
    }
}

