/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.CommentOutProperty;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public class RemoveApplicabilityTestFromYamlRecipe
extends Recipe {
    public String getDisplayName() {
        return "Remove applicability test from Yaml recipe";
    }

    public String getDescription() {
        return "Remove the applicability test from the YAML recipe when migrating from Rewrite 7 to 8, as it is no longer supported and may require migrating the recipe to Java code.";
    }

    public Set<String> getTags() {
        return Collections.singleton("Rewrite8 migration");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        YamlIsoVisitor<ExecutionContext> yamlRecipeCheckVisitor = new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                List keys = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).map(Yaml.Mapping.Entry::getKey).map(YamlKey::getValue).collect(Collectors.toList());
                Collections.reverse(keys);
                String prop = String.join((CharSequence)".", keys);
                if (prop.equals("applicability.singleSource") || prop.equals("applicability.anySource")) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry);
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }
        };
        String commentText = "Applicability tests are no longer supported for yaml recipes, please remove or require migrating the recipe to Java code";
        return Preconditions.check((TreeVisitor)yamlRecipeCheckVisitor, (TreeVisitor)new CommentOutProperty("applicability", commentText).getVisitor());
    }
}

