/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.UnwrapParentheses;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.UnnecessaryParenthesesStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.Style;

public class UnnecessaryParenthesesVisitor<P>
extends JavaVisitor<P> {
    private static final String UNNECESSARY_PARENTHESES_MESSAGE = "unnecessaryParenthesesUnwrapTarget";
    transient UnnecessaryParenthesesStyle style;

    @Override
    public boolean isAcceptable(SourceFile sourceFile, P executionContext) {
        return sourceFile instanceof J.CompilationUnit;
    }

    private UnnecessaryParenthesesStyle getStyle() {
        if (this.style == null) {
            JavaSourceFile cu = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
            this.style = cu == null ? Checkstyle.unnecessaryParentheses() : (UnnecessaryParenthesesStyle)Style.from(UnnecessaryParenthesesStyle.class, (SourceFile)cu, Checkstyle::unnecessaryParentheses);
        }
        return this.style;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P ctx) {
        J par = super.visitParentheses(parens, ctx);
        Cursor c = (Cursor)this.getCursor().pollNearestMessage(UNNECESSARY_PARENTHESES_MESSAGE);
        if (c != null && (c.getValue() instanceof J.Literal || c.getValue() instanceof J.Identifier)) {
            par = (J)new UnwrapParentheses((J.Parentheses)par).visit(par, ctx, this.getCursor().getParentOrThrow());
        }
        assert (par != null);
        if (par instanceof J.Parentheses && this.getCursor().getParentTreeCursor().getValue() instanceof J.Parentheses) {
            return ((J.Parentheses)par).getTree().withPrefix(Space.EMPTY);
        }
        return par;
    }

    @Override
    public J visitIdentifier(J.Identifier ident, P ctx) {
        J.Identifier i = (J.Identifier)super.visitIdentifier(ident, ctx);
        if (this.getStyle().getIdent().booleanValue() && this.getCursor().getParentTreeCursor().getValue() instanceof J.Parentheses) {
            this.getCursor().putMessageOnFirstEnclosing(J.Parentheses.class, UNNECESSARY_PARENTHESES_MESSAGE, (Object)this.getCursor());
        }
        return i;
    }

    @Override
    public J visitLiteral(J.Literal literal, P ctx) {
        J.Literal l = (J.Literal)super.visitLiteral(literal, ctx);
        JavaType.Primitive type = l.getType();
        if ((this.getStyle().getNumInt() != false && type == JavaType.Primitive.Int || this.getStyle().getNumDouble() != false && type == JavaType.Primitive.Double || this.getStyle().getNumLong() != false && type == JavaType.Primitive.Long || this.getStyle().getNumFloat() != false && type == JavaType.Primitive.Float || this.getStyle().getStringLiteral() != false && type == JavaType.Primitive.String || this.getStyle().getLiteralNull() != false && type == JavaType.Primitive.Null || this.getStyle().getLiteralFalse() != false && type == JavaType.Primitive.Boolean && l.getValue() == Boolean.valueOf(false) || this.getStyle().getLiteralTrue().booleanValue() && type == JavaType.Primitive.Boolean && l.getValue() == Boolean.valueOf(true)) && this.getCursor().getParentTreeCursor().getValue() instanceof J.Parentheses) {
            this.getCursor().putMessageOnFirstEnclosing(J.Parentheses.class, UNNECESSARY_PARENTHESES_MESSAGE, (Object)this.getCursor());
        }
        return l;
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, P ctx) {
        J.AssignmentOperation a = (J.AssignmentOperation)super.visitAssignmentOperation(assignOp, ctx);
        J.AssignmentOperation.Type op = a.getOperator();
        if (a.getAssignment() instanceof J.Parentheses && (this.getStyle().getBitAndAssign() != false && op == J.AssignmentOperation.Type.BitAnd || this.getStyle().getBitOrAssign() != false && op == J.AssignmentOperation.Type.BitOr || this.getStyle().getBitShiftRightAssign() != false && op == J.AssignmentOperation.Type.UnsignedRightShift || this.getStyle().getBitXorAssign() != false && op == J.AssignmentOperation.Type.BitXor || this.getStyle().getShiftRightAssign() != false && op == J.AssignmentOperation.Type.RightShift || this.getStyle().getShiftLeftAssign() != false && op == J.AssignmentOperation.Type.LeftShift || this.getStyle().getMinusAssign() != false && op == J.AssignmentOperation.Type.Subtraction || this.getStyle().getDivAssign() != false && op == J.AssignmentOperation.Type.Division || this.getStyle().getPlusAssign() != false && op == J.AssignmentOperation.Type.Addition || this.getStyle().getStarAssign() != false && op == J.AssignmentOperation.Type.Multiplication || this.getStyle().getModAssign().booleanValue() && op == J.AssignmentOperation.Type.Modulo)) {
            a = (J.AssignmentOperation)new UnwrapParentheses((J.Parentheses)a.getAssignment()).visitNonNull(a, ctx, this.getCursor().getParentOrThrow());
        }
        return a;
    }

    @Override
    public J visitAssignment(J.Assignment assignment, P ctx) {
        J.Assignment a = (J.Assignment)this.visitAndCast(assignment, ctx, (x$0, x$1) -> super.visitAssignment((J.Assignment)x$0, x$1));
        if (this.getStyle().getAssign().booleanValue() && a.getAssignment() instanceof J.Parentheses) {
            a = (J.Assignment)new UnwrapParentheses((J.Parentheses)a.getAssignment()).visitNonNull(a, ctx, this.getCursor().getParentOrThrow());
        }
        return a;
    }

    @Override
    public J visitReturn(J.Return return_, P ctx) {
        J.Return rtn = (J.Return)super.visitReturn(return_, ctx);
        if (this.getStyle().getExpr().booleanValue() && rtn.getExpression() instanceof J.Parentheses) {
            rtn = (J.Return)new UnwrapParentheses((J.Parentheses)rtn.getExpression()).visitNonNull(rtn, ctx, this.getCursor().getParentOrThrow());
        }
        return rtn;
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, P ctx) {
        J.VariableDeclarations.NamedVariable v = (J.VariableDeclarations.NamedVariable)super.visitVariable(variable, ctx);
        if (this.getStyle().getAssign().booleanValue() && v.getInitializer() != null && v.getInitializer() instanceof J.Parentheses) {
            v = (J.VariableDeclarations.NamedVariable)new UnwrapParentheses((J.Parentheses)v.getInitializer()).visitNonNull(v, ctx, this.getCursor().getParentOrThrow());
        }
        return v;
    }

    @Override
    public J visitLambda(J.Lambda lambda, P ctx) {
        J.Lambda l = (J.Lambda)super.visitLambda(lambda, ctx);
        if (this.getStyle().getLambda().booleanValue() && l.getParameters().getParameters().size() == 1 && l.getParameters().isParenthesized() && l.getParameters().getParameters().get(0) instanceof J.VariableDeclarations && ((J.VariableDeclarations)l.getParameters().getParameters().get(0)).getTypeExpression() == null) {
            l = l.withParameters(l.getParameters().withParenthesized(false));
        }
        return l;
    }

    @Override
    public J visitIf(J.If iff, P ctx) {
        J.If i = (J.If)super.visitIf(iff, ctx);
        Expression expression = i.getIfCondition().getTree();
        if (expression instanceof J.Parentheses) {
            i = (J.If)new UnwrapParentheses((J.Parentheses)expression).visitNonNull(i, ctx, this.getCursor().getParentOrThrow());
        }
        return i;
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, P ctx) {
        J.WhileLoop w = (J.WhileLoop)super.visitWhileLoop(whileLoop, ctx);
        Expression expression = w.getCondition().getTree();
        if (expression instanceof J.Parentheses) {
            w = (J.WhileLoop)new UnwrapParentheses((J.Parentheses)expression).visitNonNull(w, ctx, this.getCursor().getParentOrThrow());
        }
        return w;
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P ctx) {
        J.DoWhileLoop dw = (J.DoWhileLoop)super.visitDoWhileLoop(doWhileLoop, ctx);
        Expression expression = dw.getWhileCondition().getTree();
        if (expression instanceof J.Parentheses) {
            dw = (J.DoWhileLoop)new UnwrapParentheses((J.Parentheses)expression).visitNonNull(dw, ctx, this.getCursor().getParentOrThrow());
        }
        return dw;
    }

    @Override
    public J visitForControl(J.ForLoop.Control control, P ctx) {
        J.ForLoop.Control fc = (J.ForLoop.Control)super.visitForControl(control, ctx);
        Expression condition = fc.getCondition();
        if (condition instanceof J.Parentheses) {
            fc = (J.ForLoop.Control)new UnwrapParentheses((J.Parentheses)condition).visitNonNull(fc, ctx, this.getCursor().getParentOrThrow());
        }
        return fc;
    }

    @Override
    public J visitTernary(J.Ternary ternary, P ctx) {
        J.Ternary te = (J.Ternary)super.visitTernary(ternary, ctx);
        if (te.getCondition() instanceof J.Parentheses) {
            te = (J.Ternary)new UnwrapParentheses((J.Parentheses)te.getCondition()).visitNonNull(te, ctx, this.getCursor().getParentOrThrow());
        }
        return te;
    }

    @Override
    public J visitUnary(J.Unary unary, P ctx) {
        J.Unary u = (J.Unary)super.visitUnary(unary, ctx);
        if (u.getExpression() instanceof J.Parentheses) {
            u = (J.Unary)new UnwrapParentheses((J.Parentheses)u.getExpression()).visitNonNull(u, ctx, this.getCursor().getParentOrThrow());
        }
        return u;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, p);
        if (mi.getSelect() instanceof J.Parentheses) {
            J.Parentheses parentheses = (J.Parentheses)mi.getSelect();
            if (parentheses.getTree() instanceof J.Assignment || parentheses.getTree() instanceof J.Binary || parentheses.getTree() instanceof J.Ternary || parentheses.getTree() instanceof J.TypeCast) {
                return mi;
            }
            Expression tree = (Expression)parentheses.getTree();
            mi = mi.withSelect((Expression)tree.withPrefix(UnnecessaryParenthesesVisitor.mergeSpace(mi.getSelect().getPrefix(), tree.getPrefix())));
        }
        return mi.withArguments(ListUtils.map(mi.getArguments(), arg -> {
            if (arg instanceof J.Parentheses) {
                Object tree = ((J.Parentheses)arg).getTree();
                return (Expression)tree.withPrefix(UnnecessaryParenthesesVisitor.mergeSpace(arg.getPrefix(), tree.getPrefix()));
            }
            return arg;
        }));
    }

    private static Space mergeSpace(Space outside, Space inside) {
        return Space.build(outside.getWhitespace() + inside.getWhitespace(), ListUtils.concatAll(outside.getComments(), inside.getComments()));
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnnecessaryParenthesesVisitor)) {
            return false;
        }
        UnnecessaryParenthesesVisitor other = (UnnecessaryParenthesesVisitor)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UnnecessaryParenthesesVisitor;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

