/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.trait.Reference;

public class PackageMatcher
implements Reference.Matcher {
    private final @Nullable String targetPackage;
    private final Boolean recursive;

    public PackageMatcher(@Nullable String targetPackage) {
        this(targetPackage, false);
    }

    public PackageMatcher(@Nullable String targetPackage, boolean recursive) {
        this.targetPackage = targetPackage;
        this.recursive = recursive;
    }

    public boolean matchesReference(Reference reference) {
        if (reference.getKind() == Reference.Kind.TYPE || reference.getKind() == Reference.Kind.PACKAGE) {
            String recursivePackageNamePrefix = this.targetPackage + ".";
            if (reference.getValue().equals(this.targetPackage) || this.recursive.booleanValue() && reference.getValue().startsWith(recursivePackageNamePrefix)) {
                return true;
            }
        }
        return false;
    }

    public Reference.Renamer createRenamer(String newName) {
        return reference -> this.getReplacement(reference.getValue(), this.targetPackage, newName);
    }

    String getReplacement(String value, @Nullable String oldValue, String newValue) {
        if (oldValue != null) {
            if (value.equals(oldValue)) {
                return newValue;
            }
            if (value.startsWith(oldValue) && (this.recursive.booleanValue() || value.length() > oldValue.length() + 1 && Character.isUpperCase(value.charAt(oldValue.length() + 1)))) {
                return newValue + value.substring(oldValue.length());
            }
        }
        return value;
    }

    @Generated
    public @Nullable String getTargetPackage() {
        return this.targetPackage;
    }

    @Generated
    public Boolean getRecursive() {
        return this.recursive;
    }
}

